/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.mq;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.impl.mq.ActiveMqMessage;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.springframework.jms.core.JmsOperations;

public class ActiveMqMessageMaintainableImpl
extends KualiMaintainableImpl {
    private static final String RESEND = "Resend";
    private transient JmsOperations jmsOperations;

    public void doRouteStatusChange(DocumentHeader documentHeader) {
        super.doRouteStatusChange(documentHeader);
        WorkflowDocument workflowDocument = documentHeader.getWorkflowDocument();
        if (workflowDocument.isProcessed() && RESEND.equals(this.getMaintenanceAction())) {
            Message message = ((ActiveMqMessage)this.getBusinessObject()).getJmsMessage();
            this.getJmsOperations().execute((session, producer) -> {
                producer.send((Destination)session.createQueue(((ActiveMqMessage)this.getBusinessObject()).getOriginalQueueName()), (Message)session.createObjectMessage(((ObjectMessage)message).getObject()));
                return null;
            });
            this.deleteBusinessObject();
        }
    }

    public JmsOperations getJmsOperations() {
        if (this.jmsOperations == null) {
            this.jmsOperations = (JmsOperations)KcServiceLocator.getService("genericJmsOperations");
        }
        return this.jmsOperations;
    }

    public void setJmsOperations(JmsOperations jmsOperations) {
        this.jmsOperations = jmsOperations;
    }

    public void saveBusinessObject() {
        if (!RESEND.equals(this.getMaintenanceAction())) {
            super.saveBusinessObject();
        }
    }

    public void saveDataObject() {
        if (!RESEND.equals(this.getMaintenanceAction())) {
            super.saveDataObject();
        }
    }
}

