/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.correspondence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTypeBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolCorrespondenceTemplateRule {
    private static final String PROPERTY_NAME_NEW_DEFAULT_TEMPLATE_FILE = "newDefaultCorrespondenceTemplates[%1$s].templateFile";
    private static final String PROPERTY_NAME_NEW_COMMITTEE_ID = "newCorrespondenceTemplates[%1$s].committeeId";
    private static final String PROPERTY_NAME_NEW_TEMPLATE_FILE = "newCorrespondenceTemplates[%1$s].templateFile";
    private static final String PROPERTY_NAME_REPLACE_TEMPLATE_FILE = "replaceCorrespondenceTemplates[%1$s].list[%2$s].templateFile";
    private static final String PROPERTY_NAME_COMMITTEE_ID = "correspondenceTypes[%1$s].protocolCorrespondenceTemplates[%2$s].committeeId";
    private static final String PROPERTY_NAME_TEMPLATE_FILE = "correspondenceTypes[%1$s].protocolCorrespondenceTemplates[%2$s].templateFile";

    public boolean processAddDefaultProtocolCorrespondenceTemplateRules(ProtocolCorrespondenceTypeBase correspondenceType, ProtocolCorrespondenceTemplateBase newCorrespondenceTemplate, int index) throws IOException {
        boolean valid = true;
        String filePropertyName = String.format(PROPERTY_NAME_NEW_DEFAULT_TEMPLATE_FILE, index);
        return valid &= this.validFile(newCorrespondenceTemplate.getTemplateFile(), filePropertyName);
    }

    public boolean processAddProtocolCorrespondenceTemplateRules(ProtocolCorrespondenceTypeBase correspondenceType, ProtocolCorrespondenceTemplateBase newCorrespondenceTemplate, int index) throws IOException {
        boolean valid = true;
        String committeePropertyName = String.format(PROPERTY_NAME_NEW_COMMITTEE_ID, index);
        String filePropertyName = String.format(PROPERTY_NAME_NEW_TEMPLATE_FILE, index);
        valid &= this.committeeSpecified(newCorrespondenceTemplate.getCommitteeId(), committeePropertyName);
        valid &= !this.duplicateCommittee(correspondenceType.getCommitteeProtocolCorrespondenceTemplates(), newCorrespondenceTemplate.getCommitteeId(), committeePropertyName);
        return valid &= this.validFile(newCorrespondenceTemplate.getTemplateFile(), filePropertyName);
    }

    public boolean processReplaceProtocolCorrespondenceTemplateRules(ProtocolCorrespondenceTypeBase correspondenceType, ProtocolCorrespondenceTemplateBase newCorrespondenceTemplate, int typeIndex, int templateIndex) throws IOException {
        boolean valid = true;
        String committeePropertyName = String.format(PROPERTY_NAME_COMMITTEE_ID, typeIndex, templateIndex);
        String filePropertyName = String.format(PROPERTY_NAME_REPLACE_TEMPLATE_FILE, typeIndex, templateIndex);
        valid &= this.committeeSpecified(newCorrespondenceTemplate.getCommitteeId(), committeePropertyName);
        return valid &= this.validFile(newCorrespondenceTemplate.getTemplateFile(), filePropertyName);
    }

    public boolean processSaveProtocolCorrespondenceTemplateRules(List<ProtocolCorrespondenceTypeBase> protocolCorrespondenceTypes) throws IOException {
        boolean valid = true;
        for (ProtocolCorrespondenceTypeBase protocolCorrespondenceType : protocolCorrespondenceTypes) {
            int typeIndex = protocolCorrespondenceTypes.indexOf(protocolCorrespondenceType);
            List<ProtocolCorrespondenceTemplateBase> protocolCorrespondenceTemplates = protocolCorrespondenceType.getCommitteeProtocolCorrespondenceTemplates();
            valid &= !this.hasInvalidCommittee(protocolCorrespondenceTemplates, typeIndex);
            valid &= !this.hasDuplicateCommittee(protocolCorrespondenceTemplates, typeIndex);
            valid &= this.validTemplates(protocolCorrespondenceType, typeIndex);
        }
        return valid;
    }

    private boolean hasInvalidCommittee(List<ProtocolCorrespondenceTemplateBase> protocolCorrespondenceTemplates, int typeIndex) {
        boolean hasInvalidCommittee = false;
        for (ProtocolCorrespondenceTemplateBase protocolCorrespondenceTemplate : protocolCorrespondenceTemplates) {
            int templateIndex = protocolCorrespondenceTemplates.indexOf(protocolCorrespondenceTemplate);
            String propertyName = String.format(PROPERTY_NAME_COMMITTEE_ID, typeIndex, templateIndex);
            hasInvalidCommittee |= !this.committeeSpecified(protocolCorrespondenceTemplate.getCommitteeId(), propertyName);
        }
        return hasInvalidCommittee;
    }

    private boolean hasDuplicateCommittee(List<ProtocolCorrespondenceTemplateBase> protocolCorrespondenceTemplates, int typeIndex) {
        ArrayList<ProtocolCorrespondenceTemplateBase> tmpTemplates = new ArrayList<ProtocolCorrespondenceTemplateBase>();
        for (ProtocolCorrespondenceTemplateBase protocolCorrespondenceTemplate : protocolCorrespondenceTemplates) {
            int templateIndex = protocolCorrespondenceTemplates.indexOf(protocolCorrespondenceTemplate);
            String propertyName = String.format(PROPERTY_NAME_COMMITTEE_ID, typeIndex, templateIndex);
            if (this.duplicateCommittee(tmpTemplates, protocolCorrespondenceTemplate.getCommitteeId(), propertyName)) {
                return true;
            }
            tmpTemplates.add(protocolCorrespondenceTemplate);
        }
        return false;
    }

    private boolean committeeSpecified(String committeeId, String propertyName) {
        if (StringUtils.isBlank((CharSequence)committeeId)) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.correspondence.template.committee.not.specified", new String[0]);
            return false;
        }
        return true;
    }

    private boolean duplicateCommittee(List<ProtocolCorrespondenceTemplateBase> correspondenceTemplates, String committeeId, String propertyName) {
        boolean duplicate = false;
        for (ProtocolCorrespondenceTemplateBase correspondenceTemplate : correspondenceTemplates) {
            if (!correspondenceTemplate.getCommitteeId().equals(committeeId)) continue;
            GlobalVariables.getMessageMap().putError(propertyName, "error.correspondence.template.committee.duplicate", new String[0]);
            duplicate = true;
            break;
        }
        return duplicate;
    }

    private boolean validFile(FormFile file, String propertyName) throws IOException {
        String contentType;
        boolean isValid = true;
        byte[] fileData = file.getFileData();
        if (fileData == null || fileData.length == 0) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.correspondence.template.empty.file", new String[0]);
            isValid = false;
        }
        if (isValid && !(contentType = file.getContentType()).equals("text/xml") && !contentType.equals("application/xml") && !contentType.equals("application/xslt+xml")) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.correspondence.template.invalid.file.type", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    private boolean validTemplates(ProtocolCorrespondenceTypeBase protocolCorrespondenceType, int typeIndex) throws IOException {
        boolean isValid = true;
        ProtocolCorrespondenceTemplateBase defaultTemplate = protocolCorrespondenceType.getDefaultProtocolCorrespondenceTemplate();
        if (defaultTemplate != null && (defaultTemplate.getCorrespondenceTemplate().length == 0 || StringUtils.isBlank((CharSequence)defaultTemplate.getFileName()))) {
            String filePropertyName = String.format(PROPERTY_NAME_NEW_DEFAULT_TEMPLATE_FILE, typeIndex);
            GlobalVariables.getMessageMap().putError(filePropertyName, "error.correspondence.template.invalid.file", new String[0]);
            isValid = false;
        }
        List<ProtocolCorrespondenceTemplateBase> protocolCorrespondenceTemplates = protocolCorrespondenceType.getCommitteeProtocolCorrespondenceTemplates();
        for (ProtocolCorrespondenceTemplateBase protocolCorrespondenceTemplate : protocolCorrespondenceTemplates) {
            if (protocolCorrespondenceTemplate.getCorrespondenceTemplate() != null && protocolCorrespondenceTemplate.getCorrespondenceTemplate().length != 0 && !StringUtils.isBlank((CharSequence)protocolCorrespondenceTemplate.getFileName())) continue;
            int templateIndex = protocolCorrespondenceTemplates.indexOf(protocolCorrespondenceTemplate);
            String filePropertyName = String.format(PROPERTY_NAME_TEMPLATE_FILE, typeIndex, templateIndex);
            GlobalVariables.getMessageMap().putError(filePropertyName, "error.correspondence.template.invalid.file", new String[0]);
            isValid = false;
        }
        return isValid;
    }
}

