/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSponsorAndProgramRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalSponsorAndProgramRuleEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalSponsorAndProgramRuleImpl
extends KcTransactionalDocumentRuleBase
implements InstitutionalProposalSponsorAndProgramRule {
    public static final String CFDA_NUMBER = "cfdaNumber";

    @Override
    public boolean processInstitutionalProposalSponsorAndProgramRules(InstitutionalProposalSponsorAndProgramRuleEvent institutionalProposalSponsorAndProgramRuleEvent) {
        return this.processCommonValidations(institutionalProposalSponsorAndProgramRuleEvent.getInstitutionalProposalForValidation());
    }

    public boolean processCommonValidations(InstitutionalProposal institutionalProposal) {
        boolean validSponsorCode = this.validateSponsorCodeExists(institutionalProposal.getSponsorCode());
        boolean validPrimeSponsorId = this.validatePrimeSponsorIdExists(institutionalProposal.getPrimeSponsorCode());
        boolean validSponsorDeadlineTime = this.validateSponsorDeadlineTime(institutionalProposal);
        return validSponsorCode && validSponsorDeadlineTime;
    }

    private boolean validateSponsorDeadlineTime(InstitutionalProposal institutionalProposal) {
        boolean valid = true;
        if (institutionalProposal.getDeadlineTime() != null) {
            String formatTime = DateUtils.formatFrom12Or24Str(institutionalProposal.getDeadlineTime());
            if (!formatTime.equalsIgnoreCase("Invalid Time")) {
                institutionalProposal.setDeadlineTime(formatTime);
            } else {
                GlobalVariables.getMessageMap().putError("document.institutionalProposal.deadlineTime", "error.invalid.deadLineTime", new String[0]);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validateSponsorCodeExists(String sponsorCode) {
        boolean valid = true;
        if (sponsorCode != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("sponsorCode", sponsorCode);
            List sponsors = (List)this.getBusinessObjectService().findMatching(Sponsor.class, fieldValues);
            if (sponsors.size() == 0) {
                this.reportError("document.institutionalProposalList[0].sponsorCode", "error.invalid.sponsorCode", new String[0]);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validatePrimeSponsorIdExists(String primeSponsorId) {
        boolean valid = true;
        if (primeSponsorId != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("sponsorCode", primeSponsorId);
            List sponsors = (List)this.getBusinessObjectService().findMatching(Sponsor.class, fieldValues);
            if (sponsors.size() == 0) {
                this.reportError("document.institutionalProposalList[0].primeSponsorCode", "error.invalid.primeSponsorCode", new String[0]);
                valid = false;
            }
        }
        return valid;
    }
}

