/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Comparator;
import org.kuali.kra.SkipVersioning;
import org.kuali.kra.infrastructure.KraNotepadInterface;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;

public abstract class ProtocolNotepadBase
extends ProtocolAssociateBase
implements Comparable<ProtocolNotepadBase>,
KraNotepadInterface {
    private static final long serialVersionUID = -294125058992878907L;
    protected Long id;
    protected Integer entryNumber = 0;
    protected String comments;
    protected boolean restrictedView;
    protected String noteTopic;
    protected boolean editable = false;
    private String createUser;
    private Timestamp createTimestamp;
    @SkipVersioning
    protected transient String updateUserFullName;
    protected transient String createUserFullName;

    protected ProtocolNotepadBase() {
    }

    public ProtocolNotepadBase(ProtocolBase protocol) {
        super(protocol);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getEntryNumber() {
        return this.entryNumber;
    }

    public void setEntryNumber(Integer entryNumber) {
        this.entryNumber = entryNumber;
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public boolean getRestrictedView() {
        return this.restrictedView;
    }

    public void setRestrictedView(boolean restrictedView) {
        this.restrictedView = restrictedView;
    }

    @Override
    public String getNoteTopic() {
        return this.noteTopic;
    }

    public void setNoteTopic(String noteTopic) {
        this.noteTopic = noteTopic;
    }

    @Override
    public String getUpdateUserFullName() {
        return this.updateUserFullName;
    }

    public void setUpdateUserFullName(String updateUserFullName) {
        this.updateUserFullName = updateUserFullName;
    }

    @Override
    public String getCreateUserFullName() {
        return this.createUserFullName;
    }

    public void setCreateUserFullName(String createUserFullName) {
        this.createUserFullName = createUserFullName;
    }

    @Override
    public void resetPersistenceState() {
        this.id = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.entryNumber == null ? 0 : this.entryNumber.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.noteTopic == null ? 0 : this.noteTopic.hashCode());
        result = 31 * result + (this.restrictedView ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolNotepadBase other = (ProtocolNotepadBase)obj;
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.entryNumber == null ? other.entryNumber != null : !this.entryNumber.equals(other.entryNumber)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.noteTopic == null ? other.noteTopic != null : !this.noteTopic.equals(other.noteTopic)) {
            return false;
        }
        return this.restrictedView == other.restrictedView;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (updateTimestamp == null || this.getUpdateTimestamp() == null || this.isEditable()) {
            super.setUpdateTimestamp(updateTimestamp);
        }
    }

    @Override
    public void setUpdateUser(String updateUser) {
        if (updateUser == null || this.getUpdateUser() == null || this.isEditable()) {
            super.setUpdateUser(updateUser);
        }
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public int compareTo(ProtocolNotepadBase protocolNotepad) {
        if (this.getCreateTimestamp() == null || protocolNotepad.getCreateTimestamp() == null) {
            return this.getUpdateTimestamp().compareTo(protocolNotepad.getUpdateTimestamp());
        }
        return this.getCreateTimestamp().compareTo(protocolNotepad.getCreateTimestamp());
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    @Override
    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public static final class NotepadByEntryNumber
    implements Comparator<ProtocolNotepadBase>,
    Serializable {
        public static final NotepadByEntryNumber INSTANCE = new NotepadByEntryNumber();
        private static final long serialVersionUID = -2271453419166988229L;

        private NotepadByEntryNumber() {
        }

        @Override
        public int compare(ProtocolNotepadBase o1, ProtocolNotepadBase o2) {
            return o1.getEntryNumber().compareTo(o2.getEntryNumber());
        }
    }
}

