/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.personnel.AddProtocolPersonnelEventBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.personnel.SaveProtocolPersonnelEventBase;

public abstract class ProtocolPersonnelRuleBase
extends KcTransactionalDocumentRuleBase {
    protected static final String ERROR_PROPERTY_NEW_PERSON = "newProtocolPerson";
    protected static final String ERROR_PROPERTY_EXISTING_PERSON = "document.protocolList[0].protocolPersons";
    protected static final String ERROR_PROPERTY_PERSON_ROLE = ".protocolPersonRoleId";
    protected static final String ERROR_PROPERTY_PERSON_UNIT = ".protocolPersonUnit";
    protected static final String ERROR_PROPERTY_PERSON_INDEX = "[personIndex]";
    protected static final String PERSON_INDEX = "personIndex";
    protected static final String REFERENCE_PERSON_ROLE = "protocolPersonRole";
    private ProtocolPersonnelService protocolPersonnelService;

    public boolean processAddProtocolPersonnelEvent(AddProtocolPersonnelEventBase addProtocolPersonnelEvent) {
        boolean isValid = true;
        ProtocolPersonBase protocolPerson = addProtocolPersonnelEvent.getProtocolPerson();
        if (this.isEmptyPersonOrRole(protocolPerson)) {
            isValid = false;
        } else {
            List<ProtocolPersonBase> protocolPersons = this.getProtocolPersons(addProtocolPersonnelEvent);
            isValid &= !this.isDuplicateInvestigator(protocolPerson, protocolPersons, true);
            isValid &= !this.isPISameAsCoI(protocolPerson, protocolPersons);
            isValid &= !this.isDuplicatePerson(protocolPerson, addProtocolPersonnelEvent);
        }
        return isValid;
    }

    private boolean isDuplicateInvestigator(ProtocolPersonBase protocolPerson, List<ProtocolPersonBase> protocolPersons, boolean newPerson) {
        boolean investigatorDuplicate = false;
        if (this.getProtocolPersonnelService().isPrincipalInvestigator(protocolPerson)) {
            investigatorDuplicate = this.isDuplicatePI(protocolPersons, protocolPersons, true);
        }
        return investigatorDuplicate;
    }

    private boolean isPISameAsCoI(ProtocolPersonBase newProtocolPerson, List<ProtocolPersonBase> protocolPersons) {
        ProtocolPersonBase pi = this.getProtocolPersonnelService().getPrincipalInvestigator(protocolPersons);
        boolean duplicatePerson = this.getProtocolPersonnelService().isPISameAsCoI(pi, newProtocolPerson);
        if (duplicatePerson) {
            this.reportError(this.formatErrorPropertyName(true, protocolPersons.indexOf(pi), ERROR_PROPERTY_PERSON_ROLE), "error.protocolPersonnel.pi.sameas.coi", new String[0]);
        }
        return duplicatePerson;
    }

    private boolean isDuplicatePI(List<ProtocolPersonBase> searchableProtocolPersons, List<ProtocolPersonBase> allProtocolPersons, boolean newPerson) {
        boolean investigatorDuplicate = false;
        ProtocolPersonBase principalInvestigator = this.getProtocolPersonnelService().getPrincipalInvestigator(searchableProtocolPersons);
        if (principalInvestigator != null) {
            investigatorDuplicate = true;
            this.reportError(this.formatErrorPropertyName(newPerson, allProtocolPersons.indexOf(principalInvestigator), ERROR_PROPERTY_PERSON_ROLE), "error.protocolPersonnel.pi.already.exists", new String[0]);
        }
        return investigatorDuplicate;
    }

    protected String formatErrorPropertyName(boolean newPerson, int personIndex, String errorKey) {
        String errorProperty = null;
        errorProperty = newPerson ? ERROR_PROPERTY_NEW_PERSON.concat(errorKey) : ERROR_PROPERTY_EXISTING_PERSON + ERROR_PROPERTY_PERSON_INDEX.replaceAll(PERSON_INDEX, Integer.toString(personIndex)) + errorKey;
        return errorProperty;
    }

    private boolean isDuplicatePerson(ProtocolPersonBase protocolPerson, AddProtocolPersonnelEventBase addProtocolPersonnelEvent) {
        boolean duplicatePerson = false;
        if (this.getProtocolPersonnelService().isDuplicatePerson(this.getProtocolPersons(addProtocolPersonnelEvent), protocolPerson)) {
            duplicatePerson = true;
            this.reportError(this.formatErrorPropertyName(true, 0, ERROR_PROPERTY_PERSON_ROLE), "error.duplicate.protocolPersonnel", new String[0]);
        }
        return duplicatePerson;
    }

    private boolean isEmptyPersonOrRole(ProtocolPersonBase protocolPerson) {
        boolean personRoleEmpty = false;
        if (StringUtils.isEmpty((CharSequence)protocolPerson.getProtocolPersonRoleId()) || StringUtils.isEmpty((CharSequence)protocolPerson.getPersonId()) && protocolPerson.getRolodexId() == null) {
            this.reportError(this.formatErrorPropertyName(true, 0, ERROR_PROPERTY_PERSON_ROLE), "error.protocolPersonnel.role.mandatory", new String[0]);
            personRoleEmpty = true;
        }
        return personRoleEmpty;
    }

    private List<ProtocolPersonBase> getProtocolPersons(AddProtocolPersonnelEventBase addProtocolPersonnelEvent) {
        return ((ProtocolDocumentBase)addProtocolPersonnelEvent.getDocument()).getProtocol().getProtocolPersons();
    }

    public boolean processSaveProtocolPersonnelEvent(SaveProtocolPersonnelEventBase saveProtocolPersonnelEvent) {
        boolean isValid = true;
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)saveProtocolPersonnelEvent.getDocument();
        List<ProtocolPersonBase> protocolPersons = protocolDocument.getProtocol().getProtocolPersons();
        this.getProtocolPersonnelService().syncProtocolPersonRoleChanges(protocolPersons);
        this.getProtocolPersonnelService().switchInvestigatorCoInvestigatorRole(protocolPersons);
        isValid &= this.isValidPrincipalInvestigator(protocolPersons);
        return isValid &= this.isValidPersonUnit(protocolPersons);
    }

    private boolean isValidPrincipalInvestigator(List<ProtocolPersonBase> protocolPersons) {
        boolean investigatorValid = true;
        ProtocolPersonBase principalInvestigator = this.getProtocolPersonnelService().getPrincipalInvestigator(protocolPersons);
        if (principalInvestigator == null) {
            investigatorValid = false;
            this.reportError(this.formatErrorPropertyName(true, 0, ERROR_PROPERTY_PERSON_ROLE), "error.investigator.notFound", new String[0]);
        } else {
            ArrayList<ProtocolPersonBase> existingProtocolPersons = new ArrayList<ProtocolPersonBase>();
            existingProtocolPersons.addAll(protocolPersons);
            existingProtocolPersons.remove(principalInvestigator);
            investigatorValid &= !this.isDuplicatePI(existingProtocolPersons, protocolPersons, false);
        }
        return investigatorValid;
    }

    private boolean isValidPersonUnit(List<ProtocolPersonBase> protocolPersons) {
        boolean personUnitValid = true;
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            protocolPerson.refreshReferenceObject(REFERENCE_PERSON_ROLE);
            if (!protocolPerson.getProtocolPersonRole().isUnitDetailsRequired()) continue;
            int personIndex = protocolPersons.indexOf(protocolPerson);
            if (protocolPerson.getProtocolUnits().size() == 0) {
                this.reportError(this.formatErrorPropertyName(false, personIndex, ERROR_PROPERTY_PERSON_UNIT), "error.protocolUnit.notFound", new String[0]);
                personUnitValid = false;
                continue;
            }
            boolean leadUnitExists = this.isPersonLeadUnitExists(protocolPerson.getProtocolUnits());
            if (leadUnitExists) continue;
            this.reportError(this.formatErrorPropertyName(false, personIndex, ERROR_PROPERTY_PERSON_UNIT), "error.protocolLeadUnit.notDefined", new String[0]);
            personUnitValid = false;
        }
        return personUnitValid;
    }

    private boolean isPersonLeadUnitExists(List<ProtocolUnitBase> protocolUnits) {
        boolean unitExists = false;
        for (ProtocolUnitBase protocolUnit : protocolUnits) {
            if (!protocolUnit.getLeadUnitFlag()) continue;
            unitExists = true;
            break;
        }
        return unitExists;
    }

    public ProtocolPersonnelService getProtocolPersonnelService() {
        if (this.protocolPersonnelService == null) {
            this.protocolPersonnelService = this.getProtocolPersonnelServiceHook();
        }
        return this.protocolPersonnelService;
    }

    public abstract ProtocolPersonnelService getProtocolPersonnelServiceHook();

    public void setProtocolPersonnelService(ProtocolPersonnelService protocolPersonnelService) {
        this.protocolPersonnelService = protocolPersonnelService;
    }
}

