/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.copy;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeAttachment;
import org.kuali.coeus.propdev.impl.attachment.NarrativeUserRights;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.copy.CopyProposalEvent;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyCriteria;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.coeus.propdev.impl.docperm.ProposalRoleTemplateService;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyStatusConstants;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyService;
import org.kuali.coeus.propdev.impl.location.ProposalSite;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelService;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.person.ProposalPersonYnq;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiographyAttachment;
import org.kuali.coeus.propdev.impl.person.creditsplit.ProposalUnitCreditSplit;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.s2s.S2sAppSubmission;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.propdev.impl.s2s.S2sOpportunity;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedForm;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormAtt;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedFormFile;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverride;
import org.kuali.coeus.propdev.impl.s2s.override.S2sOverrideApplicationData;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewAttachment;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalCopyService")
public class ProposalCopyServiceImpl
implements ProposalCopyService {
    private static final Logger LOG = LogManager.getLogger(ProposalCopyServiceImpl.class);
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="kualiRuleService")
    private KualiRuleService kualiRuleService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;
    @Autowired
    @Qualifier(value="kcAuthorizationService")
    private KcAuthorizationService kcAuthorizationService;
    @Autowired
    @Qualifier(value="keyPersonnelService")
    private KeyPersonnelService keyPersonnelService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="proposalRoleTemplateService")
    private ProposalRoleTemplateService proposalRoleTemplateService;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private ProposalBudgetService proposalBudgetService;
    @Autowired
    @Qualifier(value="proposalTypeService")
    private ProposalTypeService proposalTypeService;
    @Autowired
    @Qualifier(value="proposalHierarchyService")
    private ProposalHierarchyService proposalHierarchyService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    private static final String DEFAULT_HIERARCHY_BUDGET_TYPE_CODE = "B";

    @Override
    public ProposalDevelopmentDocument copyProposal(ProposalDevelopmentDocument doc, ProposalCopyCriteria criteria) {
        if (criteria.isHierarchyCopy()) {
            criteria.setLeadUnitNumber(doc.getDevelopmentProposal().getOwnedByUnitNumber());
        }
        ProposalDevelopmentDocument newDoc = null;
        boolean rulePassed = this.getKualiRuleService().applyRules((DocumentEvent)new CopyProposalEvent(doc, criteria));
        LOG.info("STARTING PROPOSAL COPY");
        if (rulePassed) {
            try {
                newDoc = this.createNewProposal(doc, criteria);
                this.copyProposal(doc, newDoc);
                this.setLeadUnit(newDoc, criteria.getLeadUnitNumber());
                this.clearSubmitFlag(newDoc.getDevelopmentProposal());
                this.clearNarrativeUserRights(newDoc);
                this.copyNotes(doc, newDoc);
                List<ProposalAbstract> abstracts = this.copyAbstracts(doc, newDoc);
                if (criteria.getIncludeBudget()) {
                    this.copyBudgets(doc, newDoc, criteria.getBudgetVersions());
                    this.setBudgetVersionsToIncomplete(newDoc);
                }
                if (!criteria.getIncludeBudget() && criteria.isHierarchyCopy()) {
                    newDoc = (ProposalDevelopmentDocument)this.getDocumentService().saveDocument((Document)newDoc);
                    this.createBudgetStubs(doc, newDoc);
                }
                newDoc.getDevelopmentProposal().setS2sOpportunity(null);
                this.clearProposalPersonNotificationDetails(newDoc);
                newDoc.getDevelopmentProposal().setProposalStateTypeCode("1");
                this.fixS2sOverride(newDoc);
                newDoc = (ProposalDevelopmentDocument)this.getDocumentService().saveDocument((Document)newDoc);
                newDoc.getDevelopmentProposal().getBudgets().forEach(budget -> this.getProposalBudgetService().syncBudgetReferencesForCopy((ProposalDevelopmentBudgetExt)budget));
                this.initializeCertificationAnswerHeaders(newDoc);
                this.addAbstracts(abstracts, newDoc);
                this.modifyNewProposal(doc, newDoc, criteria);
                this.addCreateDetails(newDoc);
                this.copyProposalSpecialReviewAttachments(newDoc.getDevelopmentProposal().getPropSpecialReviews());
                newDoc = (ProposalDevelopmentDocument)this.getDocumentService().saveDocument((Document)newDoc);
                this.initializeAuthorization(newDoc);
            }
            catch (Exception e) {
                throw new RuntimeException("An error occurred while trying to copy the proposal development document.", e);
            }
        }
        LOG.debug("New proposal generated...");
        return newDoc;
    }

    protected void initializeCertificationAnswerHeaders(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        proposalDevelopmentDocument.getDevelopmentProposal().getProposalPersons().stream().filter(ProposalPerson::needsCertification).forEach(proposalPerson -> {
            ProposalPersonModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalPersonModuleQuestionnaireBean(proposalDevelopmentDocument.getDevelopmentProposal(), (ProposalPerson)proposalPerson, false);
            List<AnswerHeader> answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
            this.getBusinessObjectService().save(answerHeaders);
        });
    }

    protected void addAbstracts(List<ProposalAbstract> abstracts, ProposalDevelopmentDocument newDoc) {
        for (ProposalAbstract abs : abstracts) {
            abs.setProposalNumber(newDoc.getDevelopmentProposal().getProposalNumber());
        }
        newDoc.getDevelopmentProposal().setProposalAbstracts(abstracts);
    }

    protected void clearSubmitFlag(DevelopmentProposal developmentProposal) {
        developmentProposal.setSubmitFlag(Boolean.FALSE);
    }

    protected void copyNotes(ProposalDevelopmentDocument doc, ProposalDevelopmentDocument newDoc) {
        List<Note> notes = doc.getNotes();
        ArrayList<Note> newNotes = new ArrayList<Note>();
        for (Note note : notes) {
            Note noteCopy = this.deepCopy(note);
            noteCopy.setVersionNumber(Long.valueOf(0L));
            newNotes.add(noteCopy);
        }
        newDoc.setNotes(newNotes);
    }

    protected List<ProposalAbstract> copyAbstracts(ProposalDevelopmentDocument oldDoc, ProposalDevelopmentDocument newDoc) {
        newDoc.getDevelopmentProposal().setProposalAbstracts(null);
        ArrayList<ProposalAbstract> abstracts = new ArrayList<ProposalAbstract>();
        for (ProposalAbstract abs : oldDoc.getDevelopmentProposal().getProposalAbstracts()) {
            ProposalAbstract absCopy = this.deepCopy(abs);
            absCopy.setAbstractType(abs.getAbstractType());
            abstracts.add(absCopy);
        }
        return abstracts;
    }

    protected void clearNarrativeUserRights(ProposalDevelopmentDocument newDoc) {
        for (Narrative narrative : newDoc.getDevelopmentProposal().getNarratives()) {
            narrative.setNarrativeUserRights(new ArrayList<NarrativeUserRights>());
        }
        for (Narrative narrative : newDoc.getDevelopmentProposal().getInstituteAttachments()) {
            narrative.setNarrativeUserRights(new ArrayList<NarrativeUserRights>());
        }
    }

    protected void copyQuestionnaire(ProposalDevelopmentDocument oldDoc, ProposalDevelopmentDocument newDoc) {
        ProposalDevelopmentModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(oldDoc.getDevelopmentProposal(), true);
        ProposalDevelopmentModuleQuestionnaireBean destModuleQuestionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(newDoc.getDevelopmentProposal(), false);
        this.getQuestionnaireAnswerService().copyAnswerHeaders(moduleQuestionnaireBean, destModuleQuestionnaireBean);
        moduleQuestionnaireBean = new ProposalDevelopmentS2sModuleQuestionnaireBean(oldDoc.getDevelopmentProposal());
        destModuleQuestionnaireBean = new ProposalDevelopmentS2sModuleQuestionnaireBean(newDoc.getDevelopmentProposal());
        this.getQuestionnaireAnswerService().copyAnswerHeaders(moduleQuestionnaireBean, destModuleQuestionnaireBean);
    }

    protected void removeAttachments(ProposalDevelopmentDocument newDoc) {
        newDoc.getDevelopmentProposal().setNarratives(new ArrayList<Narrative>());
        newDoc.getDevelopmentProposal().setInstituteAttachments(new ArrayList<Narrative>());
        newDoc.getDevelopmentProposal().setProposalAbstracts(new ArrayList<ProposalAbstract>());
        newDoc.getDevelopmentProposal().setPropPersonBios(new ArrayList<ProposalPersonBiography>());
    }

    protected ProposalDevelopmentDocument createNewProposal(ProposalDevelopmentDocument srcDoc, ProposalCopyCriteria criteria) throws WorkflowException {
        ProposalDevelopmentDocument newDoc = (ProposalDevelopmentDocument)this.getDocumentService().getNewDocument(srcDoc.getClass());
        LOG.info("Copying Proposal ....");
        this.copyOverviewProperties(srcDoc, newDoc);
        this.copyRequiredProperties(srcDoc, newDoc);
        this.setLeadUnit(newDoc, criteria.getLeadUnitNumber());
        newDoc.getDocumentHeader().setDocumentTemplateNumber(srcDoc.getDocumentNumber());
        return newDoc;
    }

    protected void copyRequiredProperties(ProposalDevelopmentDocument oldDoc, ProposalDevelopmentDocument newDoc) {
        DevelopmentProposal srcDevelopmentProposal = oldDoc.getDevelopmentProposal();
        DevelopmentProposal destDevelopmentProposal = newDoc.getDevelopmentProposal();
        newDoc.getDocumentHeader().setDocumentDescription(oldDoc.getDocumentHeader().getDocumentDescription());
        destDevelopmentProposal.setProposalTypeCode(srcDevelopmentProposal.getProposalTypeCode());
        destDevelopmentProposal.setActivityTypeCode(srcDevelopmentProposal.getActivityTypeCode());
        destDevelopmentProposal.setTitle(srcDevelopmentProposal.getTitle());
        destDevelopmentProposal.setSponsorCode(srcDevelopmentProposal.getSponsorCode());
        destDevelopmentProposal.setRequestedStartDateInitial(srcDevelopmentProposal.getRequestedStartDateInitial());
        destDevelopmentProposal.setRequestedEndDateInitial(srcDevelopmentProposal.getRequestedEndDateInitial());
        destDevelopmentProposal.getApplicantOrganization().setLocationName(srcDevelopmentProposal.getApplicantOrganization().getLocationName());
        destDevelopmentProposal.getApplicantOrganization().setSiteNumber(srcDevelopmentProposal.getApplicantOrganization().getSiteNumber());
        destDevelopmentProposal.getPerformingOrganization().setLocationName(srcDevelopmentProposal.getPerformingOrganization().getLocationName());
        destDevelopmentProposal.getPerformingOrganization().setSiteNumber(srcDevelopmentProposal.getPerformingOrganization().getSiteNumber());
        if (this.isProposalTypeRenewalRevisionContinuation(srcDevelopmentProposal.getProposalTypeCode())) {
            destDevelopmentProposal.setSponsorProposalNumber(srcDevelopmentProposal.getSponsorProposalNumber());
        }
        this.copyCustomDataFromDocument(oldDoc, newDoc);
    }

    private void addCreateDetails(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        proposalDevelopmentDocument.getDevelopmentProposal().setCreateTimestamp(new Timestamp(System.currentTimeMillis()));
        proposalDevelopmentDocument.getDevelopmentProposal().setCreateUser(this.getGlobalVariableService().getUserSession().getLoggedInUserPrincipalName());
    }

    protected void copyCustomDataFromDocument(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest) {
        for (Map.Entry<String, CustomAttributeDocument> entry : src.getCustomAttributeDocuments().entrySet()) {
            CustomAttributeDocument customAttributeDocument = entry.getValue();
            if (!customAttributeDocument.isActive()) continue;
            HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
            primaryKeys.put("documentNumber", src.getDocumentNumber());
            primaryKeys.put("id", customAttributeDocument.getId());
            List customAttributeDocValues = this.getDataObjectService().findMatching(CustomAttributeDocValue.class, QueryByCriteria.Builder.andAttributes(primaryKeys).build()).getResults();
            if (CollectionUtils.isEmpty((Collection)customAttributeDocValues)) continue;
            CustomAttributeDocValue customAttributeDocValue = (CustomAttributeDocValue)customAttributeDocValues.get(0);
            CustomAttributeDocValue newDocValue = new CustomAttributeDocValue();
            newDocValue.setDocumentNumber(dest.getDocumentNumber());
            newDocValue.setId(customAttributeDocument.getId());
            dest.getCustomDataList().add(newDocValue);
            newDocValue.setValue(customAttributeDocValue == null ? customAttributeDocument.getCustomAttribute().getDefaultValue() : customAttributeDocValue.getValue());
        }
    }

    protected void fixS2sUserAttachedForms(ProposalDevelopmentDocument newDoc) {
        DevelopmentProposal developmentProposal = newDoc.getDevelopmentProposal();
        ArrayList<S2sUserAttachedForm> newList = new ArrayList<S2sUserAttachedForm>();
        List<S2sUserAttachedForm> userAttachedForms = developmentProposal.getS2sUserAttachedForms();
        for (S2sUserAttachedForm s2sUserAttachedForm : userAttachedForms) {
            S2sUserAttachedForm copiedForm;
            if (s2sUserAttachedForm == null) continue;
            try {
                this.refreshUserAttachedFormAttachments(s2sUserAttachedForm.getS2sUserAttachedFormFileList());
                copiedForm = this.deepCopy(s2sUserAttachedForm);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while copying user attached form ", e);
            }
            copiedForm.setProposalNumber(newDoc.getDevelopmentProposal().getProposalNumber());
            copiedForm.setDevelopmentProposal(developmentProposal);
            List<S2sUserAttachedFormAtt> attachments = copiedForm.getS2sUserAttachedFormAtts();
            for (S2sUserAttachedFormAtt s2sUserAttachedFormAtt : attachments) {
                s2sUserAttachedFormAtt.setProposalNumber(newDoc.getDevelopmentProposal().getProposalNumber());
            }
            newList.add(copiedForm);
        }
        developmentProposal.setS2sUserAttachedForms(newList);
    }

    protected void refreshUserAttachedFormAttachments(List<S2sUserAttachedFormFile> s2sUserAttachedFormFileList) {
        s2sUserAttachedFormFileList.forEach(S2sUserAttachedFormFile::getFormFile);
    }

    protected void copyProposal(ProposalDevelopmentDocument oldDoc, ProposalDevelopmentDocument newDoc) {
        this.fixNextValues(oldDoc, newDoc);
        S2sOverride s2sOverride = oldDoc.getDevelopmentProposal().getS2sOverride();
        if (s2sOverride != null) {
            oldDoc.getDevelopmentProposal().setS2sOverride(null);
        }
        DevelopmentProposal copy = this.deepCopy(oldDoc.getDevelopmentProposal());
        if (s2sOverride != null) {
            copy.setS2sOverride(this.deepCopy(s2sOverride));
            oldDoc.getDevelopmentProposal().setS2sOverride(s2sOverride);
        }
        this.removeBioAttachments(copy);
        copy.getBudgets().clear();
        copy.setFinalBudget(null);
        newDoc.setDevelopmentProposal(copy);
        copy.setProposalDocument(newDoc);
    }

    private void removeBioAttachments(DevelopmentProposal copy) {
        for (ProposalPersonBiography bio : copy.getPropPersonBios()) {
            bio.setPersonnelAttachment(null);
        }
    }

    protected <T> T deepCopy(T src) {
        return (T)this.getDataObjectService().copyInstance(src, new CopyOption[]{CopyOption.RESET_PK_FIELDS, CopyOption.RESET_VERSION_NUMBER, CopyOption.RESET_OBJECT_ID});
    }

    protected void fixNextValues(ProposalDevelopmentDocument oldDoc, ProposalDevelopmentDocument newDoc) {
        ArrayList<DocumentNextvalue> newNextValues = new ArrayList<DocumentNextvalue>();
        List<DocumentNextvalue> oldNextValues = oldDoc.getDocumentNextvalues();
        for (DocumentNextvalue oldNextValue : oldNextValues) {
            DocumentNextvalue newNextValue = new DocumentNextvalue();
            newNextValue.setPropertyName(oldNextValue.getPropertyName());
            newNextValue.setNextValue(oldNextValue.getNextValue());
            newNextValue.setDocumentKey(newDoc.getDocumentNumber());
            newNextValues.add(newNextValue);
        }
        newDoc.setDocumentNextvalues(newNextValues);
    }

    protected void copyOverviewProperties(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest) {
        DocumentHeader srcHdr = src.getDocumentHeader();
        DocumentHeader destHdr = dest.getDocumentHeader();
        destHdr.setDocumentDescription(srcHdr.getDocumentDescription());
        destHdr.setExplanation(srcHdr.getExplanation());
        destHdr.setOrganizationDocumentNumber(srcHdr.getOrganizationDocumentNumber());
    }

    protected void setLeadUnit(ProposalDevelopmentDocument doc, String newLeadUnitNumber) {
        Unit newLeadUnit = this.getUnitService().getUnit(newLeadUnitNumber);
        doc.getDevelopmentProposal().setOwnedByUnitNumber(newLeadUnitNumber);
        doc.getDevelopmentProposal().setOwnedByUnit(newLeadUnit);
    }

    protected void modifyNewProposal(ProposalDevelopmentDocument srcDoc, ProposalDevelopmentDocument newDoc, ProposalCopyCriteria criteria) {
        newDoc.setDefaultDocumentDescription();
        newDoc.getDevelopmentProposal().setApproverId(null);
        newDoc.getDevelopmentProposal().setApproverId(null);
        this.cleanupHierarchy(newDoc);
        this.changeKeyPersonnelUnits(newDoc, srcDoc.getDevelopmentProposal().getOwnedByUnitNumber(), criteria.getLeadUnitNumber());
        this.changeOrganizationAndLocations(newDoc);
        this.setPreviousGrantsGovTrackingId(srcDoc.getDevelopmentProposal().getProposalNumber(), newDoc);
        this.setPkAndNewUpdateTimestampOnAbstracts(newDoc);
        if (!criteria.getIncludeAttachments()) {
            this.removeAttachments(newDoc);
        } else {
            this.modifyNarrativesStatus(srcDoc.getDevelopmentProposal(), newDoc.getDevelopmentProposal());
            this.modifyAttachmentPermissions(srcDoc.getDevelopmentProposal(), newDoc.getDevelopmentProposal());
            this.copyAttachmentFiles(srcDoc.getDevelopmentProposal(), newDoc.getDevelopmentProposal());
        }
        if (criteria.getIncludeQuestionnaire()) {
            this.copyQuestionnaire(srcDoc, newDoc);
        }
        if (criteria.getIncludeBudget()) {
            this.modifyBudgetModular(newDoc);
        }
        this.copyOpportunity(newDoc, srcDoc);
        this.fixS2sUserAttachedForms(newDoc);
    }

    private void modifyBudgetModular(ProposalDevelopmentDocument newDoc) {
        for (Budget budget : newDoc.getDevelopmentProposal().getBudgets()) {
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetModular() == null) continue;
                budgetPeriod.getBudgetModular().setBudgetId(budget.getBudgetId());
            }
        }
    }

    protected void copyOpportunity(ProposalDevelopmentDocument newDoc, ProposalDevelopmentDocument srcDoc) {
        if (srcDoc.getDevelopmentProposal().hasS2sOpportunity()) {
            S2sOpportunity opportunity = this.deepCopy(srcDoc.getDevelopmentProposal().getS2sOpportunity());
            opportunity.setDevelopmentProposal(newDoc.getDevelopmentProposal());
            newDoc.getDevelopmentProposal().setS2sOpportunity(opportunity);
            for (S2sOppForms form : opportunity.getS2sOppForms()) {
                form.getS2sOppFormsId().setProposalNumber(newDoc.getDevelopmentProposal().getProposalNumber());
            }
        }
    }

    protected void fixS2sOverride(ProposalDevelopmentDocument newDoc) {
        S2sOverride s2sOverride = newDoc.getDevelopmentProposal().getS2sOverride();
        if (s2sOverride != null) {
            s2sOverride.setActive(false);
            s2sOverride.setUpdateUser(null);
            s2sOverride.setUpdateTimestamp(null);
            this.resetS2sOverrideAppData(s2sOverride.getApplication());
            this.resetS2sOverrideAppData(s2sOverride.getApplicationOverride());
            s2sOverride.setDevelopmentProposal(newDoc.getDevelopmentProposal());
        }
    }

    private void resetS2sOverrideAppData(S2sOverrideApplicationData application) {
        if (application != null) {
            application.setUpdateUser(null);
            application.setUpdateTimestamp(null);
            if (application.getAttachments() != null) {
                application.getAttachments().forEach(a -> {
                    a.setUpdateUser(null);
                    a.setUpdateTimestamp(null);
                    a.setUploadUser(null);
                    a.setUploadTimestamp(null);
                });
            }
        }
    }

    protected void modifyAttachmentPermissions(DevelopmentProposal oldProposal, DevelopmentProposal copiedProposal) {
        int narrativeNumber;
        List<Narrative> narratives = copiedProposal.getNarratives();
        List<Narrative> oldNarratives = oldProposal.getNarratives();
        for (narrativeNumber = 0; narrativeNumber < narratives.size(); ++narrativeNumber) {
            this.setPersonNarrativePermission(this.globalVariableService.getUserSession().getPrincipalId(), narratives.get(narrativeNumber), oldNarratives.get(narrativeNumber), copiedProposal.getProposalNumber());
        }
        for (narrativeNumber = 0; narrativeNumber < narratives.size(); ++narrativeNumber) {
            this.setPersonNarrativePermission(this.globalVariableService.getUserSession().getPrincipalId(), narratives.get(narrativeNumber), oldNarratives.get(narrativeNumber), copiedProposal.getProposalNumber());
        }
    }

    protected void modifyNarrativesStatus(DevelopmentProposal oldProposal, DevelopmentProposal copiedProposal) {
        List<Narrative> narratives = copiedProposal.getNarratives();
        for (Narrative narrative : narratives) {
            if (StringUtils.equals((CharSequence)narrative.getNarrativeType().getNarrativeTypeGroup(), (CharSequence)"P")) {
                narrative.setModuleStatusCode("I");
                continue;
            }
            narrative.setModuleStatusCode("C");
        }
    }

    protected void setPersonNarrativePermission(String personId, Narrative narrative, Narrative oldNarrative, String newProposalNumber) {
        List<NarrativeUserRights> newRights = narrative.getNarrativeUserRights();
        List<NarrativeUserRights> oldRights = oldNarrative.getNarrativeUserRights();
        for (int rightsNumber = 0; rightsNumber < newRights.size(); ++rightsNumber) {
            if (oldRights.get(rightsNumber).getUserId().equals(personId)) continue;
            newRights.get(rightsNumber).setModuleNumber(oldRights.get(rightsNumber).getModuleNumber());
            newRights.get(rightsNumber).setPersonName(oldRights.get(rightsNumber).getPersonName());
            newRights.get(rightsNumber).setUserId(oldRights.get(rightsNumber).getUserId());
            newRights.get(rightsNumber).setProposalNumber(newProposalNumber);
        }
    }

    protected void setPkAndNewUpdateTimestampOnAbstracts(ProposalDevelopmentDocument newDoc) {
        for (ProposalAbstract curAbstract : newDoc.getDevelopmentProposal().getProposalAbstracts()) {
            curAbstract.setTimestampDisplay(new Timestamp(new Date().getTime()));
            curAbstract.setAbstractTypeCode(curAbstract.getAbstractType().getCode());
            curAbstract.setProposalNumber(newDoc.getDevelopmentProposal().getProposalNumber());
        }
    }

    protected void copyAttachmentFiles(DevelopmentProposal oldProposal, DevelopmentProposal newProposal) {
        this.copyNarrativeAttachments(oldProposal.getNarratives(), newProposal.getNarratives());
        this.copyNarrativeAttachments(oldProposal.getInstituteAttachments(), newProposal.getInstituteAttachments());
        this.copyPropPersonBiosAttachments(oldProposal.getPropPersonBios(), newProposal.getPropPersonBios());
    }

    protected void copyProposalSpecialReviewAttachments(List<ProposalSpecialReview> newReviews) {
        if (newReviews != null) {
            newReviews.stream().filter(review -> review.getSpecialReviewAttachment() != null).forEach(review -> {
                ProposalSpecialReviewAttachment attachment = new ProposalSpecialReviewAttachment();
                attachment.setFileDataId(review.getSpecialReviewAttachment().getFileDataId());
                attachment.setName(review.getSpecialReviewAttachment().getName());
                attachment.setType(review.getSpecialReviewAttachment().getType());
                attachment.setUploadUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
                attachment.setUploadTimestamp(new Timestamp(new Date().getTime()));
                attachment.setClinicalTrial(review.getSpecialReviewAttachment().getClinicalTrial());
                attachment.setIsAttachmentDelayedOnset(review.getSpecialReviewAttachment().getIsAttachmentDelayedOnset());
                attachment.setStudyTitle(review.getSpecialReviewAttachment().getStudyTitle());
                review.setSpecialReviewAttachment(attachment);
            });
        }
    }

    protected void copyPropPersonBiosAttachments(List<ProposalPersonBiography> oldBiographies, List<ProposalPersonBiography> newBiographies) {
        for (ProposalPersonBiography oldBiography : oldBiographies) {
            for (ProposalPersonBiography newBiography : newBiographies) {
                if (!oldBiography.getProposalPersonNumber().equals(newBiography.getProposalPersonNumber()) || !oldBiography.getBiographyNumber().equals(newBiography.getBiographyNumber()) || oldBiography.getPersonnelAttachment() == null) continue;
                ProposalPersonBiographyAttachment newBiographyAttachment = new ProposalPersonBiographyAttachment();
                newBiographyAttachment.setProposalPersonBiography(newBiography);
                newBiographyAttachment.setProposalPersonNumber(oldBiography.getProposalPersonNumber());
                newBiographyAttachment.setBiographyNumber(oldBiography.getBiographyNumber());
                newBiographyAttachment.setData(oldBiography.getPersonnelAttachment().getData());
                newBiographyAttachment.setName(oldBiography.getPersonnelAttachment().getName());
                newBiographyAttachment.setType(oldBiography.getPersonnelAttachment().getType());
                newBiography.setPersonnelAttachment(newBiographyAttachment);
            }
        }
    }

    protected void copyNarrativeAttachments(List<Narrative> oldNarratives, List<Narrative> newNarratives) {
        for (Narrative oldNarrative : oldNarratives) {
            for (Narrative newNarrative : newNarratives) {
                if (!oldNarrative.getModuleNumber().equals(newNarrative.getModuleNumber()) || oldNarrative.getNarrativeAttachment() == null) continue;
                NarrativeAttachment newNarrativeAttachment = new NarrativeAttachment();
                newNarrativeAttachment.setNarrative(newNarrative);
                newNarrativeAttachment.setModuleNumber(oldNarrative.getModuleNumber());
                newNarrativeAttachment.setData(oldNarrative.getNarrativeAttachment().getData());
                newNarrativeAttachment.setName(oldNarrative.getNarrativeAttachment().getName());
                newNarrativeAttachment.setType(oldNarrative.getNarrativeAttachment().getType());
                newNarrative.setNarrativeAttachment(newNarrativeAttachment);
            }
        }
    }

    protected void setPreviousGrantsGovTrackingId(String oldProposalNumber, ProposalDevelopmentDocument newDoc) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put(PROPOSAL_NUMBER, oldProposalNumber);
        List s2sAppSubmissionProposalList = this.getDataObjectService().findMatching(S2sAppSubmission.class, QueryByCriteria.Builder.andAttributes(keyMap).build()).getResults();
        newDoc.getDevelopmentProposal().setS2sAppSubmission(new ArrayList<S2sAppSubmission>());
        for (S2sAppSubmission s2sAppSubmissionListValue : s2sAppSubmissionProposalList) {
            newDoc.getDevelopmentProposal().setPrevGrantsGovTrackingID(s2sAppSubmissionListValue.getGgTrackingId());
        }
    }

    protected void cleanupHierarchy(ProposalDevelopmentDocument newDoc) {
        newDoc.getDevelopmentProposal().setHierarchyStatus(HierarchyStatusConstants.None.code());
        newDoc.getDevelopmentProposal().setHierarchyParentProposalNumber(null);
        newDoc.getDevelopmentProposal().setHierarchyLastSyncHashCode(null);
    }

    protected void changeOrganizationAndLocations(ProposalDevelopmentDocument doc) {
        DevelopmentProposal developmentProposal = doc.getDevelopmentProposal();
        Unit ownedByUnit = developmentProposal.getOwnedByUnit();
        if (ownedByUnit != null) {
            String unitOrganizationId = ownedByUnit.getOrganizationId();
            for (ProposalSite proposalSite : developmentProposal.getProposalSites()) {
                if (!proposalSite.getLocationTypeCode().equals(1) && !proposalSite.getLocationTypeCode().equals(2)) continue;
                proposalSite.setOrganizationId(unitOrganizationId);
                proposalSite.initializeDefaultCongressionalDistrict();
            }
        }
    }

    protected void setBudgetVersionsToIncomplete(ProposalDevelopmentDocument doc) {
        if (doc.getDevelopmentProposal().getBudgets().size() > 0) {
            String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(Budget.class, "budgetStatusIncompleteCode");
            for (ProposalDevelopmentBudgetExt budget : doc.getDevelopmentProposal().getBudgets()) {
                budget.setBudgetStatus(budgetStatusIncompleteCode);
            }
        }
    }

    protected void changeKeyPersonnelUnits(ProposalDevelopmentDocument doc, String oldLeadUnitNumber, String newLeadUnitNumber) {
        List<ProposalPerson> persons = doc.getDevelopmentProposal().getProposalPersons();
        for (ProposalPerson person : persons) {
            PropAwardPersonRole role = person.getRole();
            String roleId = role.getCode();
            if (StringUtils.equals((CharSequence)roleId, (CharSequence)"PI")) {
                ProposalPersonUnit unit;
                List<ProposalPersonUnit> proposalPersonUnits = person.getUnits();
                boolean doesNewLeadUnitExist = false;
                Iterator<ProposalPersonUnit> iterator = proposalPersonUnits.iterator();
                while (iterator.hasNext()) {
                    ProposalPersonUnit oldUnit = iterator.next();
                    String oldUnitNumber = oldUnit.getUnitNumber();
                    if (StringUtils.equals((CharSequence)oldUnitNumber, (CharSequence)newLeadUnitNumber)) {
                        doesNewLeadUnitExist = true;
                        oldUnit.setLeadUnit(true);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)newLeadUnitNumber, (CharSequence)oldUnitNumber) && !StringUtils.equals((CharSequence)oldLeadUnitNumber, (CharSequence)oldUnitNumber)) {
                        oldUnit.setLeadUnit(false);
                        continue;
                    }
                    iterator.remove();
                }
                if (!doesNewLeadUnitExist && (unit = this.createProposalPersonUnit(person, newLeadUnitNumber, true, false, proposalPersonUnits)) != null) {
                    person.getUnits().add(unit);
                }
            }
            for (ProposalPersonYnq ynq : person.getProposalPersonYnqs()) {
                ynq.setAnswer(null);
            }
        }
        this.getKeyPersonnelService().populateCreditSplit(doc);
    }

    protected ProposalPersonUnit createProposalPersonUnit(ProposalPerson person, String unitNumber, boolean isLeadUnit, boolean isDeletable, List<ProposalPersonUnit> oldProposalPersonUnits) {
        ProposalPersonUnit proposalPersonUnit = this.getKeyPersonnelService().createProposalPersonUnit(unitNumber, person);
        if (proposalPersonUnit.getUnitNumber() == null) {
            return null;
        }
        proposalPersonUnit.setLeadUnit(isLeadUnit);
        proposalPersonUnit.setDelete(isDeletable);
        proposalPersonUnit.setVersionNumber(null);
        ProposalPersonUnit oldProposalPersonUnit = this.findProposalPersonUnit(unitNumber, oldProposalPersonUnits);
        if (oldProposalPersonUnit != null) {
            ArrayList<ProposalUnitCreditSplit> newUnitCreditSplits = new ArrayList<ProposalUnitCreditSplit>();
            List<ProposalUnitCreditSplit> oldUnitCreditSplits = oldProposalPersonUnit.getCreditSplits();
            for (ProposalUnitCreditSplit oldUnitCreditSplit : oldUnitCreditSplits) {
                ProposalUnitCreditSplit newUnitCreditSplit = (ProposalUnitCreditSplit)this.getDataObjectService().copyInstance((Object)oldUnitCreditSplit, new CopyOption[]{CopyOption.RESET_OBJECT_ID, CopyOption.RESET_PK_FIELDS, CopyOption.RESET_VERSION_NUMBER});
                newUnitCreditSplits.add(newUnitCreditSplit);
            }
            proposalPersonUnit.setCreditSplits(newUnitCreditSplits);
        }
        proposalPersonUnit.setProposalPerson(person);
        return proposalPersonUnit;
    }

    protected ProposalPersonUnit createProposalPersonUnit(ProposalPerson newProposalPerson, ProposalPersonUnit oldProposalPersonUnit) {
        ProposalPerson oldProposalPerson = oldProposalPersonUnit.getProposalPerson();
        DevelopmentProposal newParentProposal = newProposalPerson.getDevelopmentProposal();
        return this.createProposalPersonUnit(newProposalPerson, oldProposalPersonUnit.getUnitNumber(), newParentProposal.getOwnedByUnitNumber().equals(oldProposalPersonUnit.getUnitNumber()), false, oldProposalPerson.getUnits());
    }

    protected ProposalPersonUnit findProposalPersonUnit(String unitNumber, List<ProposalPersonUnit> proposalPersonUnits) {
        for (ProposalPersonUnit proposalPersonUnit : proposalPersonUnits) {
            if (!StringUtils.equals((CharSequence)unitNumber, (CharSequence)proposalPersonUnit.getUnitNumber())) continue;
            return proposalPersonUnit;
        }
        return null;
    }

    protected void initializeAuthorization(ProposalDevelopmentDocument doc) {
        String userId = this.globalVariableService.getUserSession().getPrincipalId();
        if (!this.getKcAuthorizationService().hasDocumentLevelRole(userId, "Aggregator", doc)) {
            this.getKcAuthorizationService().addDocumentLevelRole(userId, "Aggregator", doc);
        }
        this.getProposalRoleTemplateService().addUsers(doc);
    }

    protected void copyBudgets(ProposalDevelopmentDocument src, ProposalDevelopmentDocument dest, String budgetVersions) {
        dest.getDevelopmentProposal().getBudgets().clear();
        ProposalDevelopmentBudgetExt finalBudgetVersion = src.getDevelopmentProposal().getFinalBudget();
        if (budgetVersions.equals("FINAL") && finalBudgetVersion != null) {
            ProposalDevelopmentBudgetExt budgetCopy = this.getProposalBudgetService().copyBudgetVersion(finalBudgetVersion, false, dest.getDevelopmentProposal(), false);
            dest.getDevelopmentProposal().getBudgets().add(budgetCopy);
        } else {
            for (ProposalDevelopmentBudgetExt budget : src.getDevelopmentProposal().getBudgets()) {
                ProposalDevelopmentBudgetExt budgetCopy = this.getProposalBudgetService().copyBudgetVersion(budget, false, dest.getDevelopmentProposal(), false);
                dest.getDevelopmentProposal().getBudgets().add(budgetCopy);
            }
        }
    }

    private void clearProposalPersonNotificationDetails(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ArrayList<ProposalPerson> proposalPersons = new ArrayList<ProposalPerson>();
        for (ProposalPerson proposalPerson : proposalDevelopmentDocument.getDevelopmentProposal().getProposalPersons()) {
            proposalPerson.setLastNotification(null);
            if (proposalPerson.getCertificationDetails() != null) {
                proposalPerson.getCertificationDetails().setCertifiedBy(null);
                proposalPerson.getCertificationDetails().setCertifiedTime(null);
            }
            proposalPersons.add(proposalPerson);
        }
        proposalDevelopmentDocument.getDevelopmentProposal().setProposalPersons(proposalPersons);
    }

    @Override
    public ProposalDevelopmentDocument copyProposalHierarchy(ProposalDevelopmentDocument doc, ProposalCopyCriteria criteria) {
        DevelopmentProposal developmentProposal = doc.getDevelopmentProposal();
        if (!developmentProposal.isInHierarchy()) {
            throw new IllegalStateException("The given ProposalDevelopmentDocument doesn't belong to a Proposal Hierarchy.");
        }
        DevelopmentProposal oldParentProposal = developmentProposal.isParent() ? developmentProposal : developmentProposal.getParent();
        List<DevelopmentProposal> children = this.getProposalHierarchyService().getHierarchyChildren(oldParentProposal.getProposalNumber());
        String oldHierarchyOriginatingChildProposalNumber = oldParentProposal.getHierarchyOriginatingChildProposalNumber();
        DevelopmentProposal oldOriginatingChildProposal = children.stream().filter(proposal -> proposal.getProposalNumber().equals(oldHierarchyOriginatingChildProposalNumber)).findFirst().get();
        List otherChildren = children.stream().filter(proposal -> !proposal.getProposalNumber().equals(oldHierarchyOriginatingChildProposalNumber)).collect(Collectors.toList());
        try {
            HashMap<String, String> childrenNumbersMap = new HashMap<String, String>();
            ProposalDevelopmentDocument newOriginatingChildProposalDocument = this.copyProposal(oldOriginatingChildProposal.getProposalDocument(), criteria);
            childrenNumbersMap.put(oldOriginatingChildProposal.getProposalNumber(), newOriginatingChildProposalDocument.getDevelopmentProposal().getProposalNumber());
            String userId = this.getGlobalVariableService().getUserSession().getPrincipalId();
            DevelopmentProposal newParentProposal = this.getProposalHierarchyService().createHierarchy(newOriginatingChildProposalDocument.getDevelopmentProposal(), userId);
            LOG.debug("New Parent Proposal Number: " + newParentProposal.getProposalNumber());
            otherChildren.stream().forEach(otherChild -> {
                ProposalDevelopmentDocument newChildProposalDocument = this.copyProposal(otherChild.getProposalDocument(), criteria);
                childrenNumbersMap.put(otherChild.getProposalNumber(), newChildProposalDocument.getDevelopmentProposal().getProposalNumber());
                this.getProposalHierarchyService().linkToHierarchy(newParentProposal, newChildProposalDocument.getDevelopmentProposal(), DEFAULT_HIERARCHY_BUDGET_TYPE_CODE);
            });
            ProposalDevelopmentDocument newParentProposalDocument = newParentProposal.getProposalDocument();
            ProposalDevelopmentDocument oldParentProposalDocument = oldParentProposal.getProposalDocument();
            newParentProposal.setTitle(oldParentProposal.getTitle());
            newParentProposal.setProposalPersons(new ArrayList<ProposalPerson>());
            this.fixNextValues(oldParentProposalDocument, newParentProposalDocument);
            newParentProposalDocument = (ProposalDevelopmentDocument)this.getDocumentService().saveDocument((Document)newParentProposalDocument);
            oldParentProposal.getProposalPersons().forEach(oldProposalPerson -> {
                ProposalPerson newProposalPerson = this.deepCopy(oldProposalPerson);
                newProposalPerson.setDevelopmentProposal(newParentProposal);
                newParentProposal.getProposalPersons().add(newProposalPerson);
            });
            if (criteria.getIncludeQuestionnaire()) {
                this.copyQuestionnaire(oldParentProposalDocument, newParentProposalDocument);
            }
            this.removeAttachments(newParentProposalDocument);
            oldParentProposal.getS2sUserAttachedForms().stream().forEach(s2sUserAttachedForm -> newParentProposal.getS2sUserAttachedForms().add(this.deepCopy(s2sUserAttachedForm)));
            if (oldParentProposal.getS2sOverride() != null) {
                newParentProposal.setS2sOverride(this.deepCopy(oldParentProposal.getS2sOverride()));
            }
            this.fixS2sOverride(newParentProposalDocument);
            this.copyOpportunity(newParentProposalDocument, oldParentProposalDocument);
            this.fixS2sUserAttachedForms(newParentProposalDocument);
            newParentProposal.setOpportunityIdForGG(oldParentProposal.getOpportunityIdForGG());
            newParentProposal.setProgramAnnouncementNumber(oldParentProposal.getProgramAnnouncementNumber());
            newParentProposal.setProgramAnnouncementTitle(oldParentProposal.getProgramAnnouncementTitle());
            oldParentProposal.getProposalCfdas().stream().filter(existingCfda -> !newParentProposal.getProposalCfdas().stream().anyMatch(cfda -> cfda.getCfdaNumber().equals(existingCfda.getCfdaNumber()))).forEach(proposalCfda -> newParentProposal.getProposalCfdas().add(this.deepCopy(proposalCfda)));
            this.copyCustomDataFromDocument(oldParentProposalDocument, newParentProposalDocument);
            newParentProposalDocument = (ProposalDevelopmentDocument)this.getDocumentService().saveDocument((Document)newParentProposalDocument);
            List<ProposalAbstract> abstracts = this.copyAbstracts(oldParentProposalDocument, newParentProposalDocument);
            this.addAbstracts(abstracts, newParentProposalDocument);
            if (criteria.getIncludeAttachments()) {
                this.directCopyNarrativeAttachments(oldParentProposal.getNarratives(), newParentProposal.getNarratives(), newParentProposal, childrenNumbersMap);
                this.directCopyNarrativeAttachments(oldParentProposal.getInstituteAttachments(), newParentProposal.getInstituteAttachments(), newParentProposal, childrenNumbersMap);
                this.directCopyPropPersonBios(oldParentProposal.getPropPersonBios(), newParentProposal.getPropPersonBios(), newParentProposal);
            }
            return newParentProposalDocument;
        }
        catch (WorkflowException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void createBudgetStubs(ProposalDevelopmentDocument oldProposalDocument, ProposalDevelopmentDocument newProposalDocument) {
        newProposalDocument.getDevelopmentProposal().setBudgets(new ArrayList<ProposalDevelopmentBudgetExt>());
        oldProposalDocument.getDevelopmentProposal().getBudgets().stream().forEach(oldBudget -> this.getProposalBudgetService().addBudgetVersion(newProposalDocument, oldBudget.getName(), null));
    }

    protected void directCopyNarrativeAttachments(List<Narrative> oldNarratives, List<Narrative> newNarratives, DevelopmentProposal proposal, Map<String, String> childrenNumbersMap) {
        oldNarratives.stream().filter(oldNarrative -> oldNarrative.getNarrativeAttachment() != null).forEach(oldNarrative -> {
            Narrative newNarrative = this.deepCopy(oldNarrative);
            NarrativeAttachment newNarrativeAttachment = new NarrativeAttachment();
            newNarrativeAttachment.setNarrative(newNarrative);
            newNarrativeAttachment.setModuleNumber(oldNarrative.getModuleNumber());
            newNarrativeAttachment.setData(oldNarrative.getNarrativeAttachment().getData());
            newNarrativeAttachment.setName(oldNarrative.getNarrativeAttachment().getName());
            newNarrativeAttachment.setType(oldNarrative.getNarrativeAttachment().getType());
            if (newNarrative.getHierarchyProposalNumber() != null) {
                newNarrative.setHierarchyProposalNumber((String)childrenNumbersMap.get(newNarrative.getHierarchyProposalNumber()));
            }
            newNarrative.setNarrativeUserRights(new ArrayList<NarrativeUserRights>());
            newNarrative.setDevelopmentProposal(proposal);
            newNarrative.setNarrativeAttachment(newNarrativeAttachment);
            newNarratives.add(newNarrative);
        });
    }

    protected void directCopyPropPersonBios(List<ProposalPersonBiography> oldPropPersonBios, List<ProposalPersonBiography> newPropPersonBios, DevelopmentProposal proposal) {
        oldPropPersonBios.stream().filter(oldPropPersonBio -> oldPropPersonBio.getPersonnelAttachment() != null).forEach(oldPropPersonBio -> {
            ProposalPersonBiography newPropPersonBio = this.deepCopy(oldPropPersonBio);
            ProposalPersonBiographyAttachment newBiographyAttachment = new ProposalPersonBiographyAttachment();
            newBiographyAttachment.setProposalPersonBiography(newPropPersonBio);
            newBiographyAttachment.setProposalPersonNumber(oldPropPersonBio.getProposalPersonNumber());
            newBiographyAttachment.setBiographyNumber(oldPropPersonBio.getBiographyNumber());
            newBiographyAttachment.setData(oldPropPersonBio.getPersonnelAttachment().getData());
            newBiographyAttachment.setName(oldPropPersonBio.getPersonnelAttachment().getName());
            newBiographyAttachment.setType(oldPropPersonBio.getPersonnelAttachment().getType());
            newPropPersonBio.setDevelopmentProposal(proposal);
            newPropPersonBio.setPersonnelAttachment(newBiographyAttachment);
            newPropPersonBios.add(newPropPersonBio);
        });
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected KeyPersonnelService getKeyPersonnelService() {
        return this.keyPersonnelService;
    }

    public void setKeyPersonnelService(KeyPersonnelService keyPersonnelService) {
        this.keyPersonnelService = keyPersonnelService;
    }

    protected KcAuthorizationService getKcAuthorizationService() {
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }

    protected KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    protected UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    protected boolean isProposalTypeRenewalRevisionContinuation(String proposalTypeCode) {
        return this.getProposalTypeService().isProposalTypeRenewalRevisionContinuation(proposalTypeCode);
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ProposalRoleTemplateService getProposalRoleTemplateService() {
        return this.proposalRoleTemplateService;
    }

    public void setProposalRoleTemplateService(ProposalRoleTemplateService proposalRoleTemplateService) {
        this.proposalRoleTemplateService = proposalRoleTemplateService;
    }

    public ProposalTypeService getProposalTypeService() {
        return this.proposalTypeService;
    }

    public ProposalBudgetService getProposalBudgetService() {
        return this.proposalBudgetService;
    }

    public void setProposalBudgetService(ProposalBudgetService proposalBudgetService) {
        this.proposalBudgetService = proposalBudgetService;
    }

    public ProposalHierarchyService getProposalHierarchyService() {
        return this.proposalHierarchyService;
    }

    public void setProposalHierarchyService(ProposalHierarchyService proposalHierarchyService) {
        this.proposalHierarchyService = proposalHierarchyService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

