/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.keyvalue;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class ConditionValuesFinder<T extends PersistableBusinessObject>
extends UifKeyValuesFinderBase {
    private KeyValuesService service;
    private Class<T> clazz;
    private Map<String, Object> conditions;
    private String key;
    private String value;

    public List<KeyValue> getKeyValues() {
        this.validateRequiredProperties();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        Collection bos = this.getKeyValuesService().findMatching(this.clazz, this.conditions);
        for (PersistableBusinessObject o : bos) {
            keyValues.add((KeyValue)new ConcreteKeyValue(this.getPropery(o, this.key), this.getPropery(o, this.value)));
        }
        return keyValues;
    }

    private String getPropery(T o, String name) {
        assert (o != null) : "o is null";
        assert (!StringUtils.isBlank((CharSequence)name)) : "name is blank";
        try {
            Object property = PropertyUtils.getNestedProperty(o, (String)name);
            if (property == null) {
                throw new PropertyException("property " + name + " is null.");
            }
            return property.toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new PropertyException(e);
        }
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Map<String, Object> getConditions() {
        return new HashMap<String, Object>(this.conditions);
    }

    public void setConditions(Map<String, Object> conditions) {
        this.conditions = new HashMap<String, Object>(conditions);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private void validateRequiredProperties() {
        if (this.clazz == null) {
            throw new IllegalStateException("the clazz has not been set to a non-null value");
        }
        if (this.conditions == null) {
            throw new IllegalStateException("the conditions has not been set to a non-null value");
        }
        if (StringUtils.isBlank((CharSequence)this.key)) {
            throw new IllegalStateException("the key has not been set to a non-blank value");
        }
        if (StringUtils.isBlank((CharSequence)this.value)) {
            throw new IllegalStateException("the value has not been set to a non-blank value");
        }
    }

    public KeyValuesService getKeyValuesService() {
        if (this.service == null) {
            this.service = KcServiceLocator.getService(KeyValuesService.class);
        }
        return this.service;
    }

    public void setKeyValuesService(KeyValuesService service) {
        this.service = service;
    }

    public static class PropertyException
    extends RuntimeException
    implements Serializable {
        private static final long serialVersionUID = 4479172838906429551L;

        public PropertyException(Throwable t) {
            super(t);
        }

        public PropertyException(String message) {
            super(message);
        }
    }
}

