/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.summary;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.kra.protocol.summary.ProtocolSummary;

public class OrganizationSummary
implements Serializable {
    private static final long serialVersionUID = -774036516393407380L;
    private String id;
    private String organizationId;
    private String name;
    private String type;
    private Integer contactId;
    private String contact;
    private String fwaNumber;
    private boolean idChanged;
    private boolean nameChanged;
    private boolean typeChanged;
    private boolean contactChanged;
    private boolean fwaNumberChanged;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getContactId() {
        return this.contactId;
    }

    public void setContactId(Integer contactId) {
        this.contactId = contactId;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(Rolodex rolodex) {
        StringBuffer buf = new StringBuffer();
        if (rolodex != null) {
            if (this.append(buf, null, rolodex.getLastName(), null)) {
                this.append(buf, ", ", rolodex.getFirstName(), null);
                buf.append(" : ");
            }
            if (this.append(buf, null, rolodex.getAddressLine1(), null)) {
                if (this.append(buf, ", ", rolodex.getAddressLine2(), null)) {
                    this.append(buf, ", ", rolodex.getAddressLine3(), null);
                }
                buf.append(", ");
            }
            this.append(buf, null, rolodex.getCity(), ", ");
            if (this.append(buf, null, rolodex.getState(), null)) {
                this.append(buf, " ", rolodex.getPostalCode(), null);
            }
        }
        this.contact = buf.toString();
    }

    private boolean append(StringBuffer buf, String prefix, String text, String suffix) {
        if (text == null) {
            return false;
        }
        if (prefix != null) {
            buf.append(prefix);
        }
        buf.append(text);
        if (suffix != null) {
            buf.append(suffix);
        }
        return true;
    }

    public String getFwaNumber() {
        return this.fwaNumber;
    }

    public void setFwaNumber(String fwaNumber) {
        this.fwaNumber = fwaNumber;
    }

    public void compare(ProtocolSummary other) {
        OrganizationSummary otherOrganization = other.findOrganization(this.organizationId);
        if (otherOrganization == null) {
            this.idChanged = true;
            this.nameChanged = true;
            this.typeChanged = true;
            this.contactChanged = true;
            this.fwaNumberChanged = true;
        } else {
            this.idChanged = !StringUtils.equals((CharSequence)this.id, (CharSequence)otherOrganization.id);
            this.nameChanged = !StringUtils.equals((CharSequence)this.name, (CharSequence)otherOrganization.name);
            this.typeChanged = !StringUtils.equals((CharSequence)this.type, (CharSequence)otherOrganization.type);
            this.contactChanged = !StringUtils.equals((CharSequence)this.contact, (CharSequence)otherOrganization.contact);
            this.fwaNumberChanged = !StringUtils.equals((CharSequence)this.fwaNumber, (CharSequence)otherOrganization.fwaNumber);
        }
    }

    public boolean isIdChanged() {
        return this.idChanged;
    }

    public boolean isNameChanged() {
        return this.nameChanged;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public boolean isContactChanged() {
        return this.contactChanged;
    }

    public boolean isFwaNumberChanged() {
        return this.fwaNumberChanged;
    }
}

