/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.s3.api;

import co.kuali.coeus.s3.api.S3FileService;
import co.kuali.coeus.s3.impl.S3FileServiceimpl;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

public class EncryptedS3FileServiceFactoryBean
implements FactoryBean<S3FileService>,
InitializingBean {
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private String bucketName;
    private boolean replicationBucket = true;
    private String region;
    private String accessKey;
    private String secretKey;
    private Resource encryptionKey;
    private boolean singleton = true;

    public S3FileService getObject() {
        AmazonS3 s3;
        InstanceProfileCredentialsProvider creds;
        boolean awsCredsProvided = this.accessKey != null && !"".equals(this.accessKey.trim()) && this.secretKey != null && !"".equals(this.secretKey);
        Object object = creds = awsCredsProvided ? new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey)) : InstanceProfileCredentialsProvider.getInstance();
        if (this.encryptionKey != null && this.encryptionKey.exists()) {
            SecretKey symmetricKey = this.loadSymmetricAESKey();
            EncryptionMaterials encryptionMaterials = new EncryptionMaterials(symmetricKey);
            s3 = (AmazonS3)((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClientBuilder.standard().withCredentials((AWSCredentialsProvider)creds)).withEncryptionMaterials((EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials)).withRegion(this.getRegion())).build();
        } else {
            s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)creds)).withRegion(Regions.fromName((String)this.getRegion()))).build();
        }
        S3FileServiceimpl s3FileService = new S3FileServiceimpl();
        s3FileService.setAmazonS3(s3);
        s3FileService.setBucketName(this.bucketName);
        if (this.replicationBucket) {
            s3FileService.setReplicationBucketName(this.toReplicationBucket(this.bucketName));
        }
        return s3FileService;
    }

    protected SecretKey loadSymmetricAESKey() {
        try {
            return new SecretKeySpec(StreamUtils.copyToByteArray((InputStream)this.encryptionKey.getInputStream()), ENCRYPTION_ALGORITHM);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getObjectType() {
        return S3FileService.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @Required
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Resource getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(Resource encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public String getRegion() {
        return this.region;
    }

    @Required
    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isReplicationBucket() {
        return this.replicationBucket;
    }

    public void setReplicationBucket(boolean replicationBucket) {
        this.replicationBucket = replicationBucket;
    }

    private String toReplicationBucket(String bucketName) {
        return bucketName + "-r";
    }

    public void afterPropertiesSet() throws Exception {
        if (!BucketNameUtils.isValidV2BucketName((String)this.bucketName)) {
            throw new IllegalStateException("bucket name: " + this.bucketName + " does not conform to proper S3 naming conventions");
        }
        if (this.replicationBucket && !BucketNameUtils.isValidV2BucketName((String)this.toReplicationBucket(this.bucketName))) {
            throw new IllegalStateException("replication bucket name: " + this.toReplicationBucket(this.bucketName) + " does not conform to proper S3 naming conventions");
        }
    }
}

