/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.bo.ScheduleStatus;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleAttachmentsBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeScheduleServiceBase;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.DailyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.ScheduleData;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.StyleKey;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.scheduling.ScheduleService;
import org.kuali.coeus.sys.framework.scheduling.seq.DefaultScheduleSequence;
import org.kuali.coeus.sys.framework.scheduling.seq.ScheduleSequence;
import org.kuali.coeus.sys.framework.scheduling.seq.TrimDatesScheduleSequenceDecorator;
import org.kuali.coeus.sys.framework.scheduling.seq.WeekScheduleSequenceDecorator;
import org.kuali.coeus.sys.framework.scheduling.util.CronSpecialChars;
import org.kuali.coeus.sys.framework.scheduling.util.Time24HrFmt;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class CommitteeScheduleServiceImplBase<CS extends CommitteeScheduleBase<CS, CMT, ?, CSM>, CMT extends CommitteeBase<CMT, ?, CS>, CSM extends CommitteeScheduleMinuteBase<CSM, CS>>
implements CommitteeScheduleServiceBase<CS, CMT, CSM> {
    private static final Logger LOG = LogManager.getLogger(CommitteeScheduleServiceImplBase.class);
    private static final String COLON = ":";
    private static final String DESCRIPTION = "description";
    private static final String SCHEDULED = "Scheduled";
    private static final String PROTOCOL_ID_FIELD = "protocolIdFk";
    private static final String ENTRY_NUMBER_FIELD = "entryNumber";
    private BusinessObjectService businessObjectService;
    private ScheduleService scheduleService;
    private ReviewCommentsService<?> reviewCommentsService;

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setScheduleService(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }

    public void setReviewCommentsService(ReviewCommentsService<?> reviewCommentsService) {
        this.reviewCommentsService = reviewCommentsService;
    }

    @Override
    public Boolean isCommitteeScheduleDeletable(CS committeeSchedule) {
        boolean retVal = false;
        retVal = this.isProtocolAssignedToScheduleDate(committeeSchedule) == false;
        return retVal;
    }

    protected Boolean isProtocolAssignedToScheduleDate(CS committeeSchedule) {
        boolean retVal = true;
        List<ProtocolBase> list = ((CommitteeScheduleBase)committeeSchedule).getProtocols();
        if (null == list || list.size() == 0) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public void addSchedule(ScheduleData scheduleData, CMT committee) throws ParseException {
        List<java.util.Date> dates = null;
        Date dtEnd = null;
        int frequency = 0;
        int day = 0;
        CronSpecialChars[] weekdays = null;
        CronSpecialChars weekOfMonth = null;
        CronSpecialChars dayOfWeek = null;
        CronSpecialChars month = null;
        Time24HrFmt time = this.getTime24hFmt(scheduleData.getScheduleStartDate(), scheduleData.getTime().findMinutes());
        Date dt = scheduleData.getScheduleStartDate();
        StyleKey key = StyleKey.valueOf(scheduleData.getRecurrenceType());
        block0 : switch (key) {
            case NEVER: {
                dates = this.scheduleService.getScheduledDates(dt, dt, time, null);
                break;
            }
            case DAILY: {
                DailyScheduleDetails.optionValues dailyoption = DailyScheduleDetails.optionValues.valueOf(scheduleData.getDailySchedule().getDayOption());
                switch (dailyoption) {
                    case XDAY: {
                        dtEnd = scheduleData.getDailySchedule().getScheduleEndDate();
                        day = scheduleData.getDailySchedule().getDay();
                        dates = this.scheduleService.getIntervalInDaysScheduledDates(dt, dtEnd, time, day);
                        break;
                    }
                    case WEEKDAY: {
                        dtEnd = scheduleData.getDailySchedule().getScheduleEndDate();
                        weekdays = ScheduleData.convertToWeekdays(scheduleData.getDailySchedule().getDaysOfWeek());
                        WeekScheduleSequenceDecorator scheduleSequence = new WeekScheduleSequenceDecorator(new TrimDatesScheduleSequenceDecorator(new DefaultScheduleSequence()), 1, weekdays.length);
                        dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, weekdays, (ScheduleSequence)scheduleSequence);
                    }
                }
                break;
            }
            case WEEKLY: {
                dtEnd = scheduleData.getWeeklySchedule().getScheduleEndDate();
                if (CollectionUtils.isNotEmpty(scheduleData.getWeeklySchedule().getDaysOfWeek())) {
                    weekdays = ScheduleData.convertToWeekdays(scheduleData.getWeeklySchedule().getDaysOfWeek().toArray(new String[scheduleData.getWeeklySchedule().getDaysOfWeek().size()]));
                }
                WeekScheduleSequenceDecorator scheduleSequence = new WeekScheduleSequenceDecorator(new TrimDatesScheduleSequenceDecorator(new DefaultScheduleSequence()), scheduleData.getWeeklySchedule().getWeek(), weekdays.length);
                dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, weekdays, (ScheduleSequence)scheduleSequence);
                break;
            }
            case MONTHLY: {
                MonthlyScheduleDetails.optionValues monthOption = MonthlyScheduleDetails.optionValues.valueOf(scheduleData.getMonthlySchedule().getMonthOption());
                switch (monthOption) {
                    case XDAYANDXMONTH: {
                        dtEnd = scheduleData.getMonthlySchedule().getScheduleEndDate();
                        day = scheduleData.getMonthlySchedule().getDay();
                        frequency = scheduleData.getMonthlySchedule().getOption1Month();
                        dates = this.scheduleService.getScheduledDates(dt, dtEnd, time, day, frequency, null);
                        break;
                    }
                    case XDAYOFWEEKANDXMONTH: {
                        dtEnd = scheduleData.getMonthlySchedule().getScheduleEndDate();
                        weekOfMonth = ScheduleData.getWeekOfMonth(scheduleData.getMonthlySchedule().getSelectedMonthsWeek());
                        dayOfWeek = ScheduleData.getDayOfWeek(scheduleData.getMonthlySchedule().getSelectedDayOfWeek());
                        frequency = scheduleData.getMonthlySchedule().getOption2Month();
                        dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, dayOfWeek, weekOfMonth, (Integer)frequency, null);
                    }
                }
                break;
            }
            case YEARLY: {
                YearlyScheduleDetails.yearOptionValues yearOption = YearlyScheduleDetails.yearOptionValues.valueOf(scheduleData.getYearlySchedule().getYearOption());
                switch (yearOption) {
                    case XDAY: {
                        dtEnd = scheduleData.getYearlySchedule().getScheduleEndDate();
                        month = ScheduleData.getMonthOfWeek(scheduleData.getYearlySchedule().getSelectedOption1Month());
                        day = scheduleData.getYearlySchedule().getDay();
                        frequency = scheduleData.getYearlySchedule().getOption1Year();
                        dates = this.scheduleService.getScheduledDates((java.util.Date)dt, (java.util.Date)dtEnd, time, month, day, (Integer)frequency, null);
                        break block0;
                    }
                    case CMPLX: {
                        dtEnd = scheduleData.getYearlySchedule().getScheduleEndDate();
                        weekOfMonth = ScheduleData.getWeekOfMonth(scheduleData.getYearlySchedule().getSelectedMonthsWeek());
                        dayOfWeek = ScheduleData.getDayOfWeek(scheduleData.getYearlySchedule().getSelectedDayOfWeek());
                        month = ScheduleData.getMonthOfWeek(scheduleData.getYearlySchedule().getSelectedOption2Month());
                        frequency = scheduleData.getYearlySchedule().getOption2Year();
                        dates = this.scheduleService.getScheduledDates(dt, dtEnd, time, weekOfMonth, dayOfWeek, month, frequency, null);
                    }
                }
            }
        }
        ArrayList<Date> skippedDates = new ArrayList<Date>();
        scheduleData.setDatesInConflict(skippedDates);
        this.addScheduleDatesToCommittee(dates, committee, scheduleData.getPlace(), skippedDates);
    }

    protected Time24HrFmt getTime24hFmt(java.util.Date date, int min) throws ParseException {
        java.util.Date dt = DateUtils.round((java.util.Date)date, (int)5);
        dt = DateUtils.addMinutes((java.util.Date)dt, (int)min);
        GregorianCalendar cl = new GregorianCalendar();
        cl.setTime(dt);
        StringBuffer sb = new StringBuffer();
        String str = sb.append(cl.get(11)).append(COLON).append(cl.get(12)).toString();
        return new Time24HrFmt(str);
    }

    protected void addScheduleDatesToCommittee(List<java.util.Date> dates, CMT committee, String location, List<Date> skippedDates) {
        for (java.util.Date date : dates) {
            Date sqldate = new Date(date.getTime());
            if (!this.isDateAvailable(((CommitteeBase)committee).getCommitteeSchedules(), sqldate).booleanValue()) {
                skippedDates.add(sqldate);
                continue;
            }
            CS committeeSchedule = this.getNewCommiteeScheduleInstanceHook();
            ((CommitteeScheduleBase)committeeSchedule).setScheduledDate(sqldate);
            ((CommitteeScheduleBase)committeeSchedule).setPlace(location);
            ((CommitteeScheduleBase)committeeSchedule).setTime(new Timestamp(date.getTime()));
            int daysToAdd = ((CommitteeBase)committee).getAdvancedSubmissionDaysRequired();
            Date sqlDate = this.calculateAdvancedSubmissionDays(date, daysToAdd);
            ((CommitteeScheduleBase)committeeSchedule).setProtocolSubDeadline(sqlDate);
            ((CommitteeScheduleBase)committeeSchedule).setCommittee(committee);
            ScheduleStatus defaultStatus = this.getDefaultScheduleStatus();
            ((CommitteeScheduleBase)committeeSchedule).setScheduleStatusCode(defaultStatus.getScheduleStatusCode());
            ((CommitteeScheduleBase)committeeSchedule).setScheduleStatus(defaultStatus);
            ((CommitteeBase)committee).getCommitteeSchedules().add(committeeSchedule);
        }
    }

    protected abstract CS getNewCommiteeScheduleInstanceHook();

    protected Boolean isDateAvailable(List<CS> committeeSchedules, Date date) {
        boolean retVal = true;
        for (CommitteeScheduleBase committeeSchedule : committeeSchedules) {
            Date scheduledDate = committeeSchedule.getScheduledDate();
            if (scheduledDate == null || !DateUtils.isSameDay((java.util.Date)scheduledDate, (java.util.Date)date)) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    protected Date calculateAdvancedSubmissionDays(java.util.Date startDate, Integer days) {
        java.util.Date deadlineDate = DateUtils.addDays((java.util.Date)startDate, (int)(-days.intValue()));
        return new Date(deadlineDate.getTime());
    }

    protected ScheduleStatus getDefaultScheduleStatus() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(DESCRIPTION, SCHEDULED);
        List scheduleStatuses = (List)this.businessObjectService.findMatching(ScheduleStatus.class, fieldValues);
        return (ScheduleStatus)scheduleStatuses.get(0);
    }

    @Override
    public List<CSM> getMinutesByProtocol(Long protocolId) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put(PROTOCOL_ID_FIELD, protocolId);
        List minutes = (List)this.businessObjectService.findMatchingOrderBy(this.getCommitteeScheduleMinuteBOClassHook(), fieldValues, ENTRY_NUMBER_FIELD, true);
        ArrayList<CommitteeScheduleMinuteBase> permittedMinutes = new ArrayList<CommitteeScheduleMinuteBase>();
        for (CommitteeScheduleMinuteBase minute : minutes) {
            if (!this.reviewCommentsService.getReviewerCommentsView(minute)) continue;
            permittedMinutes.add(minute);
        }
        return permittedMinutes;
    }

    protected abstract Class<CSM> getCommitteeScheduleMinuteBOClassHook();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadAttachment(KcPersistableBusinessObjectBase attachmentDataSource, HttpServletResponse response) throws Exception {
        CommitteeScheduleAttachmentsBase committeScheduleAttachments = this.getNewCommitteeScheduleAttachmentsInstanceHook();
        byte[] data = null;
        String contentType = null;
        String fileName = null;
        if (attachmentDataSource.getClass().isInstance(committeScheduleAttachments)) {
            committeScheduleAttachments = (CommitteeScheduleAttachmentsBase)attachmentDataSource;
            data = committeScheduleAttachments.getData();
            contentType = committeScheduleAttachments.getContentType();
            fileName = committeScheduleAttachments.getFileName();
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(data.length);
            baos.write(data);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)contentType, (ByteArrayOutputStream)baos, (String)fileName);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected abstract CommitteeScheduleAttachmentsBase getNewCommitteeScheduleAttachmentsInstanceHook();
}

