/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.auth;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.auth.IacucProtocolAuthorizer;
import org.kuali.kra.iacuc.auth.IacucProtocolTask;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class CreateProposalDevelopmentIacucProtocolAuthorizer
extends IacucProtocolAuthorizer {
    @Override
    public boolean isAuthorized(String userId, IacucProtocolTask task) {
        IacucProtocol protocol = task.getProtocol();
        return this.canCreateProposal() && this.hasProposalRequiredFields(protocol);
    }

    private boolean canCreateProposal() {
        return this.hasUnitPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-PD", "Create ProposalDevelopmentDocument");
    }

    private boolean hasProposalRequiredFields(ProtocolBase protocol) {
        boolean validProposalRequiredFields = true;
        if (StringUtils.isEmpty((CharSequence)protocol.getTitle())) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((CharSequence)protocol.getLeadUnitNumber())) {
            validProposalRequiredFields = false;
        }
        if (StringUtils.isEmpty((CharSequence)protocol.getPrincipalInvestigatorId())) {
            validProposalRequiredFields = false;
        }
        List<ProtocolFundingSourceBase> protocolFundingSources = protocol.getProtocolFundingSources();
        ProtocolFundingSourceBase sponsorProtocolFundingSource = null;
        for (ProtocolFundingSourceBase protocolFundingSource : protocolFundingSources) {
            if (!protocolFundingSource.isSponsorFunding()) continue;
            sponsorProtocolFundingSource = protocolFundingSource;
            break;
        }
        if (sponsorProtocolFundingSource == null) {
            validProposalRequiredFields = false;
        }
        return validProposalRequiredFields;
    }
}

