/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplitRule;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplitRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCreditSplitAuditError;

public class InstitutionalProposalPersonUnitCreditSplitRuleImpl
extends KcTransactionalDocumentRuleBase
implements InstitutionalProposalPersonUnitCreditSplitRule {
    private static final ScaleTwoDecimal MAX_TOTAL_VALUE = new ScaleTwoDecimal(100.0);

    @Override
    public boolean checkInstitutionalProposalPersonUnitCreditSplitTotals(InstitutionalProposalPersonUnitCreditSplitRuleEvent event) {
        int errorCount = 0;
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            ScaleTwoDecimal value = event.getTotalsByCreditSplitType().get(creditType.getCode());
            if (value == null) break;
            if (((ScaleTwoDecimal)MAX_TOTAL_VALUE.subtract((AbstractDecimal)value)).isZero()) continue;
            InstitutionalProposalCreditSplitAuditError.addAuditError("error.award.person.unit.credit.split.error", creditType.getDescription());
            ++errorCount;
        }
        return errorCount == 0;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }
}

