/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.protocol.ProtocolEventBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceRuleBase;
import org.kuali.rice.krad.document.Document;

public abstract class AddProtocolFundingSourceEventBase
extends ProtocolEventBase<ProtocolFundingSourceRuleBase> {
    private static final Logger LOG = LogManager.getLogger(AddProtocolFundingSourceEventBase.class);
    private static final String MSG = "adding a funding source to a ProtocolBase document ";
    private ProtocolFundingSourceBase fundingSource;
    private List<ProtocolFundingSourceBase> protocolFundingSources;

    protected AddProtocolFundingSourceEventBase(String description, String errorPathPrefix, Document document) {
        super(MSG + AddProtocolFundingSourceEventBase.getDocumentId((Document)document), errorPathPrefix, document, ProtocolEventBase.ErrorType.HARDERROR);
    }

    public AddProtocolFundingSourceEventBase(String description, Document document, ProtocolFundingSourceBase fundingSource, List<ProtocolFundingSourceBase> protocolFundingSources) {
        super(description + ": adding a funding source to a ProtocolBase document " + AddProtocolFundingSourceEventBase.getDocumentId((Document)document), "", document, ProtocolEventBase.ErrorType.HARDERROR);
        this.protocolFundingSources = protocolFundingSources;
        this.fundingSource = fundingSource;
    }

    @Override
    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)((Object)((Object)this)).getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.document == null) {
            logMessage.append("null protocolDocument");
        } else {
            logMessage.append(this.document.toString());
        }
        LOG.debug((CharSequence)logMessage);
    }

    public ProtocolFundingSourceBase getFundingSource() {
        return this.fundingSource;
    }

    @Override
    public abstract ProtocolFundingSourceRuleBase getRule();

    public List<ProtocolFundingSourceBase> getProtocolFundingSources() {
        return this.protocolFundingSources;
    }

    public void setProtocolFundingSources(List<ProtocolFundingSourceBase> protocolFundingSources) {
        this.protocolFundingSources = protocolFundingSources;
    }
}

