/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.cache.TemplateCache;
import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core.Expression;
import freemarker.core.NonBooleanException;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.StringLiteral;
import freemarker.core.TemplateElement;
import freemarker.core._DelayedGetMessage;
import freemarker.core._DelayedJQuote;
import freemarker.core._MiscTemplateException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;

final class Include
extends TemplateElement {
    private Expression templateName;
    private Expression encodingExp;
    private Expression parseExp;
    private String encoding;
    private boolean parse;
    private final String templatePath;

    Include(Template template, Expression includedTemplateName, Expression encodingExp, Expression parseExp) throws ParseException {
        int lastSlash;
        String templatePath1 = template.getName();
        if (templatePath1 == null) {
            templatePath1 = "";
        }
        this.templatePath = (lastSlash = templatePath1.lastIndexOf(47)) == -1 ? "" : templatePath1.substring(0, lastSlash + 1);
        this.templateName = includedTemplateName;
        if (encodingExp instanceof StringLiteral) {
            this.encoding = encodingExp.toString();
            this.encoding = this.encoding.substring(1, this.encoding.length() - 1);
        } else {
            this.encodingExp = encodingExp;
        }
        if (parseExp == null) {
            this.parse = true;
        } else if (parseExp.isLiteral()) {
            try {
                if (parseExp instanceof StringLiteral) {
                    this.parse = StringUtil.getYesNo(parseExp.evalAndCoerceToString(null));
                }
                try {
                    this.parse = parseExp.evalToBoolean(null);
                }
                catch (NonBooleanException e) {
                    throw new ParseException("Expected a boolean or string as the value of the parse attribute", parseExp);
                }
            }
            catch (TemplateException e) {
                throw new UndeclaredThrowableException(e);
            }
        } else {
            this.parseExp = parseExp;
        }
    }

    void accept(Environment env) throws TemplateException, IOException {
        Template includedTemplate;
        String templateNameString = this.templateName.evalAndCoerceToString(env);
        String enc = this.encoding;
        if (this.encoding == null && this.encodingExp != null) {
            enc = this.encodingExp.evalAndCoerceToString(env);
        }
        boolean parse = this.parse;
        if (this.parseExp != null) {
            TemplateModel tm = this.parseExp.eval(env);
            if (tm == null) {
                if (env.isClassicCompatible()) {
                    parse = false;
                } else {
                    this.parseExp.assertNonNull(tm, env);
                }
            }
            parse = tm instanceof TemplateScalarModel ? this.getYesNo(EvalUtil.modelToString((TemplateScalarModel)tm, this.parseExp, env)) : this.parseExp.evalToBoolean(env);
        }
        try {
            templateNameString = TemplateCache.getFullTemplatePath(env, this.templatePath, templateNameString);
            includedTemplate = env.getTemplateForInclusion(templateNameString, enc, parse);
        }
        catch (ParseException pe) {
            throw new _MiscTemplateException((Throwable)pe, env, new Object[]{"Error parsing included template ", new _DelayedJQuote(templateNameString), ":\n", new _DelayedGetMessage(pe)});
        }
        catch (IOException ioe) {
            throw new _MiscTemplateException((Throwable)ioe, env, new Object[]{"Error reading included file ", new _DelayedJQuote(templateNameString), ":\n", new _DelayedGetMessage(ioe)});
        }
        env.include(includedTemplate);
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        buf.append(this.templateName.getCanonicalForm());
        if (this.encoding != null) {
            buf.append(" encoding=\"");
            buf.append(this.encodingExp.getCanonicalForm());
            buf.append('\"');
        }
        if (this.parseExp != null) {
            buf.append(" parse=" + this.parseExp.getCanonicalForm());
        } else if (!this.parse) {
            buf.append(" parse=false");
        }
        if (canonical) {
            buf.append("/>");
        }
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "#include";
    }

    private boolean getYesNo(String s) throws TemplateException {
        try {
            return StringUtil.getYesNo(s);
        }
        catch (IllegalArgumentException iae) {
            throw new _MiscTemplateException(this.parseExp, new Object[]{"Value of include parse parameter must be boolean (or one of these strings: \"n\", \"no\", \"f\", \"false\", \"y\", \"yes\", \"t\", \"true\"), but it was ", new _DelayedJQuote(s), "."});
        }
    }

    int getParameterCount() {
        return 3;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.templateName;
            }
            case 1: {
                return new Boolean(this.parse);
            }
            case 2: {
                return this.encoding;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.TEMPLATE_NAME;
            }
            case 1: {
                return ParameterRole.PARSE_PARAMETER;
            }
            case 2: {
                return ParameterRole.ENCODING_PARAMETER;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

