/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.sponsor;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.api.sponsor.SponsorService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="sponsorService")
public class SponsorServiceImpl
implements SponsorService {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public SponsorContract getSponsor(String sponsorCode) {
        if (StringUtils.isBlank((CharSequence)sponsorCode)) {
            throw new IllegalArgumentException("sponsorCode is blank");
        }
        return (SponsorContract)this.dataObjectService.find(Sponsor.class, (Object)sponsorCode);
    }

    public String getSponsorName(String sponsorCode) {
        SponsorContract sponsor = this.getSponsor(sponsorCode);
        return sponsor != null ? sponsor.getSponsorName() : null;
    }

    public boolean isValidSponsor(SponsorContract sponsor) {
        return sponsor != null && sponsor.isActive();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

