/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ValidRates;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.infrastructure.AwardTaskNames;
import org.kuali.kra.award.notification.AwardNoticeNotificationRenderer;
import org.kuali.kra.award.notification.AwardNoticePrintout;
import org.kuali.kra.award.notification.AwardNotification;
import org.kuali.kra.award.notification.AwardNotificationContext;
import org.kuali.kra.award.printing.AwardPrintNotice;
import org.kuali.kra.award.printing.AwardPrintParameters;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.service.AwardPrintingService;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.kra.external.award.AccountCreationClient;
import org.kuali.kra.external.award.AwardAccountValidationService;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardActionsAction
extends AwardAction
implements AuditModeAction {
    private static final String ZERO = "0";
    private static final String NEW_CHILD_SELECTED_AWARD_OPTION = "c";
    private static final String NEW_CHILD_COPY_FROM_PARENT_OPTION = "b";
    private static final String ERROR_CANCEL_PENDING_PROPOSALS = "error.cancel.fundingproposal.pendingVersion";
    private static final String ACCOUNT_ALREADY_CREATED = "error.award.createAccount.account.already.created";
    private static final String NO_PERMISSION_TO_CREATE_ACCOUNT = "error.award.createAccount.noPermission";
    private static final String CONTACTS_AUDIT_ERRORS = "contactsAuditErrors";
    private static final String AWARD_NOTICE_ID = "awardNoticeId";
    private static final String NEW_CHILD_NEW_OPTION = "a";
    private static final String AWARD_COPY_NEW_OPTION = "a";
    private static final String AWARD_COPY_CHILD_OF_OPTION = "d";
    private static final String AWARD_NOTICE_ACTION_CODE = "556";
    private static final String AWARD_NOTICE = "Award Notice";
    private static final String PRINT = "print";
    private static final String AWARD_NOTICE_REPORT = "_Award_Notice_Report";
    private static final String NOTIFICATION_EDITOR = "notificationEditor";
    private transient DataObjectService dataObjectService;
    private transient GlobalVariableService globalVariableService;
    private transient KcNotificationService notificationService;
    private transient AwardPrintingService awardPrintingService;
    private transient TaskAuthorizationService taskAuthorizationService;

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String command = request.getParameter("command");
        ActionForward forward = mapping.findForward("basic");
        if (StringUtils.isNotEmpty((CharSequence)command) && "displayDocSearchView".equals(command)) {
            this.loadDocumentInForm(request, awardForm);
            WorkflowDocument workflowDoc = awardForm.getAwardDocument().getDocumentHeader().getWorkflowDocument();
            if (workflowDoc != null) {
                awardForm.setDocTypeName(workflowDoc.getDocumentTypeName());
            }
            request.setAttribute("selectedAwardNumber", (Object)awardForm.getAwardDocument().getAward().getAwardNumber());
        } else {
            forward = super.docHandler(mapping, (ActionForm)awardForm, request, response);
        }
        return forward;
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        String command = request.getParameter("command");
        String awardDocumentNumber = request.getParameter("awardDocumentNumber");
        String awardNumber = request.getParameter("awardNumber");
        if (StringUtils.isNotBlank((CharSequence)command) && "redirectAwardHierarchyFullViewForPopup".equals(command)) {
            forward = this.redirectAwardHierarchyFullViewForPopup(mapping, form, request, response, awardDocumentNumber, awardNumber);
        }
        return forward;
    }

    private ActionForward redirectAwardHierarchyFullViewForPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String awardDocumentNumber, String awardNumber) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        response.sendRedirect("awardHierarchyFullView.do?methodToCall=openWindow&awardDocumentNumber=" + awardDocumentNumber + "&awardNumber=" + awardNumber + "&docTypeName=" + awardForm.getDocTypeName());
        return null;
    }

    protected void validateLookupInquiryFullParameter(HttpServletRequest request, ActionForm form, String fullParameter) {
        if (fullParameter.startsWith("methodToCall.performLookup.(!!" + Award.class.getName() + "!!).(((awardNumber:awardHierarchyTempObject")) {
            return;
        }
        super.validateLookupInquiryFullParameter(request, form, fullParameter);
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.setUnitRulesMessages(this.getUnitRulesMessages(awardForm.getAwardDocument()));
        return KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (AwardForm)form, true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).clearUnitRulesMessages();
        return KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (AwardForm)form, false);
    }

    public ActionForward copyAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String awardNumber = this.getAwardNumber(request);
        int index = Integer.parseInt(StringUtils.split((String)awardNumber, (String)"-")[1]);
        ActionForward forward = null;
        AwardHierarchy newRootNode = null;
        if (!StringUtils.isEmpty((CharSequence)awardForm.getAwardHierarchyTempObjects().get(index).getCopyAwardRadio())) {
            String radio = awardForm.getAwardHierarchyTempObjects().get(index).getCopyAwardRadio();
            Boolean copyDescendants = awardForm.getAwardHierarchyTempObjects().get(index).getCopyDescendants();
            AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
            if (StringUtils.equalsIgnoreCase((CharSequence)radio, (CharSequence)"a")) {
                if (copyDescendants != null && copyDescendants.booleanValue()) {
                    newRootNode = awardForm.getAwardHierarchyBean().copyAwardAndAllDescendantsAsNewHierarchy(targetNode.getAwardNumber());
                    forward = this.prepareToForwardToNewFinalChildAward(mapping, awardForm, request, response, targetNode, newRootNode);
                } else {
                    newRootNode = awardForm.getAwardHierarchyBean().copyAwardAsNewHierarchy(targetNode.getAwardNumber());
                    forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newRootNode);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)radio, (CharSequence)AWARD_COPY_CHILD_OF_OPTION)) {
                String awardNumberOfNodeToBeParent = awardForm.getAwardHierarchyTempObjects().get(index).getCopyAwardPanelTargetAward();
                if (!StringUtils.isEmpty((CharSequence)awardNumberOfNodeToBeParent) && !StringUtils.equalsIgnoreCase((CharSequence)awardNumberOfNodeToBeParent, (CharSequence)ZERO)) {
                    if (copyDescendants != null && copyDescendants.booleanValue()) {
                        if (!StringUtils.isEmpty((CharSequence)awardNumberOfNodeToBeParent)) {
                            newRootNode = awardForm.getAwardHierarchyBean().copyAwardAndDescendantsAsChildOfAnotherAward(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
                            forward = this.prepareToForwardToNewFinalChildAward(mapping, awardForm, request, response, targetNode, newRootNode);
                        }
                    } else {
                        newRootNode = awardForm.getAwardHierarchyBean().copyAwardAsChildOfAnotherAward(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
                        forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newRootNode);
                    }
                } else {
                    GlobalVariables.getMessageMap().putError("awardHierarchyTempObject[" + index + "].copyAwardPanelTargetAward", "error.copy.award.childOf.award.not.selected", new String[]{awardNumber});
                    awardForm.getFundingProposalBean().setAllAwardsForAwardNumber(null);
                    forward = mapping.findForward("basic");
                }
            }
        } else {
            GlobalVariables.getMessageMap().putError("awardHierarchyTempObject[" + index + "].copyAwardPanelTargetAward", "error.copy.award.no.option.selected", new String[]{awardNumber});
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String awardNumber = this.getAwardNumber(request);
        int index = Integer.parseInt(StringUtils.split((String)awardNumber, (String)"-")[1]);
        ActionForward forward = null;
        if (awardForm.getAwardHierarchyTempObjects().get(index).getCreateNewChildRadio() != null) {
            AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
            String radio = awardForm.getAwardHierarchyTempObjects().get(index).getCreateNewChildRadio();
            if (StringUtils.equalsIgnoreCase((CharSequence)radio, (CharSequence)"a")) {
                AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewChildAward(targetNode.getAwardNumber());
                forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)radio, (CharSequence)NEW_CHILD_COPY_FROM_PARENT_OPTION)) {
                AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewAwardBasedOnParent(targetNode.getAwardNumber());
                forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)radio, (CharSequence)NEW_CHILD_SELECTED_AWARD_OPTION)) {
                String awardNumberOfNodeToCopyFrom = awardForm.getAwardHierarchyTempObjects().get(index).getNewChildPanelTargetAward();
                if (StringUtils.isEmpty((CharSequence)awardNumberOfNodeToCopyFrom) || StringUtils.equalsIgnoreCase((CharSequence)awardNumberOfNodeToCopyFrom, (CharSequence)ZERO)) {
                    GlobalVariables.getMessageMap().putError("awardHierarchyTempObject[" + index + "].newChildPanelTargetAward", "error.create.new.child.other.award.not.selected", new String[]{awardNumber});
                    forward = mapping.findForward("basic");
                } else {
                    AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewChildAwardBasedOnAnotherAwardInHierarchy(awardNumberOfNodeToCopyFrom, targetNode.getAwardNumber());
                    forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
                }
            }
        } else {
            GlobalVariables.getMessageMap().putError("awardHierarchyTempObject[" + index + "].newChildPanelTargetAward", "error.create.new.child.no.option.selected", new String[]{awardNumber});
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward createANewChildAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewChildAward(targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
    }

    public ActionForward createANewChildAwardBasedOnParent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewAwardBasedOnParent(targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
    }

    public ActionForward createANewChildAwardBasedOnAnotherAwardInHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String awardNumberOfNodeToCopyFrom = this.getHierarchyTargetAwardNumber(request);
        if (StringUtils.isEmpty((CharSequence)awardNumberOfNodeToCopyFrom)) {
            return mapping.findForward("basic");
        }
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewChildAwardBasedOnAnotherAwardInHierarchy(awardNumberOfNodeToCopyFrom, targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
    }

    public ActionForward copyAwardAsANewHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newRootNode = awardForm.getAwardHierarchyBean().copyAwardAsNewHierarchy(targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newRootNode);
    }

    public ActionForward copyAwardAsANewHierarchyWithDescendants(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newRootNode = awardForm.getAwardHierarchyBean().copyAwardAndAllDescendantsAsNewHierarchy(targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newRootNode);
    }

    public ActionForward copyAwardAsChildOfAnotherAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        awardForm.getAwardHierarchyBean().copyAwardAsChildOfAnotherAward(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        this.populateAwardHierarchy((ActionForm)awardForm);
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAndDescendantsAsChildOfAnotherAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        if (!StringUtils.isEmpty((CharSequence)awardNumberOfNodeToBeParent)) {
            awardForm.getAwardHierarchyBean().copyAwardAndDescendantsAsChildOfAnotherAward(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        }
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAsAChildInCurrentHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        awardForm.getAwardHierarchyBean().copyAwardAsChildOfAnAwardInCurrentHierarchy(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        this.populateAwardHierarchy((ActionForm)awardForm);
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAsAChildInCurrentHierarchyWithDescendants(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        awardForm.getAwardHierarchyBean().copyAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        this.populateAwardHierarchy((ActionForm)awardForm);
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAsAChildOfAwardInAnotherHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        awardForm.getAwardHierarchyBean().copyAwardAsChildOfAnAwardInAnotherHierarchy(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAsAChildOfAwardInAnotherHierarchyWithDescendants(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        if (!StringUtils.isEmpty((CharSequence)awardNumberOfNodeToBeParent)) {
            awardForm.getAwardHierarchyBean().copyAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectAllAwardPrintNoticeItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardPrintNotice().selectAllItems();
        return mapping.findForward("basic");
    }

    public ActionForward deselectAllAwardPrintNoticeItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardPrintNotice().deselectAllItems();
        return mapping.findForward("basic");
    }

    protected boolean auditErrorExists(String key) {
        if (key == null) {
            return false;
        }
        for (AuditError error : ((AuditCluster)GlobalVariables.getAuditErrorMap().get(CONTACTS_AUDIT_ERRORS)).getAuditErrorList()) {
            if (!(key + ".auditErrors").equalsIgnoreCase(error.getErrorKey())) continue;
            return true;
        }
        return false;
    }

    public ActionForward printNotice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AttachmentDataSource dataStream = this.getAwardPrintingService().printAwardReport(awardForm.getAwardDocument().getAward(), AwardPrintType.AWARD_NOTICE_REPORT, this.populateResponseParametersForNotice(awardForm.getAwardPrintNotice()));
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printNoticeFromNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String awardNoticeId = request.getParameter(AWARD_NOTICE_ID);
        AwardNoticePrintout printout = this.getAwardNoticePrintout(awardNoticeId);
        Award award = this.getAwardService().getAward(printout.getAwardId());
        AwardTask viewTask = new AwardTask(AwardTaskNames.VIEW_AWARD.getAwardTaskName(), award);
        if (!this.getTaskAuthorizationService().isAuthorized(this.getGlobalVariableService().getUserSession().getPrincipalId(), viewTask)) {
            String principalName = this.getGlobalVariableService().getUserSession().getPerson().getPrincipalName();
            String authMessage = String.format("User '%s' is not authorized to print Award Notice for Award %s", principalName, award.getAwardNumber());
            throw new AuthorizationException(principalName, PRINT, AWARD_NOTICE, authMessage, new HashMap());
        }
        try (ByteArrayOutputStream noticeOutputStream = new ByteArrayOutputStream();){
            noticeOutputStream.write(printout.getPdfContent());
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)noticeOutputStream, (String)(printout.getAwardNumber() + "_Award_Notice_Report.pdf"));
        }
        return null;
    }

    protected AwardNoticePrintout getAwardNoticePrintout(String awardNoticeId) {
        HashMap<String, Long> printoutKeyMap = new HashMap<String, Long>();
        printoutKeyMap.put(AWARD_NOTICE_ID, Long.valueOf(awardNoticeId));
        AwardNoticePrintout printout = (AwardNoticePrintout)this.getBusinessObjectService().findByPrimaryKey(AwardNoticePrintout.class, printoutKeyMap);
        if (printout == null) {
            String authMessage = String.format("No Award Notice with an ID of %s exists", awardNoticeId);
            throw new AuthorizationException(this.getGlobalVariableService().getUserSession().getPerson().getPrincipalName(), PRINT, AWARD_NOTICE, authMessage, new HashMap());
        }
        return printout;
    }

    protected GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        if (this.taskAuthorizationService == null) {
            this.taskAuthorizationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        }
        return this.taskAuthorizationService;
    }

    public ActionForward sendNotice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        if (!awardForm.getEditingMode().containsKey("sendAwardNotice")) {
            GlobalVariables.getMessageMap().putError("error.award.sendNotice.noPermission", "error.award.sendNotice.noPermission", new String[0]);
            return mapping.findForward("basic");
        }
        AwardNoticePrintout awardPrintout = this.createAwardNoticePrintout(award, awardForm.getAwardPrintNotice());
        AwardNoticeNotificationRenderer noticeRenderer = new AwardNoticeNotificationRenderer(awardPrintout.getAwardNoticeId(), award);
        AwardNotificationContext noticeContext = new AwardNotificationContext(award, AWARD_NOTICE_ACTION_CODE, AWARD_NOTICE, noticeRenderer, "awardActions");
        awardForm.getNotificationHelper().initializeDefaultValues(noticeContext);
        if (awardForm.getNotificationHelper().getPromptUserForNotificationEditor(noticeContext)) {
            return mapping.findForward(NOTIFICATION_EDITOR);
        }
        this.getNotificationService().sendNotificationAndPersist(noticeContext, new AwardNotification(), award);
        return mapping.findForward("basic");
    }

    protected AwardNoticePrintout createAwardNoticePrintout(Award award, AwardPrintNotice awardPrintNotice) {
        AttachmentDataSource dataStream = this.getAwardPrintingService().printAwardReport(award, AwardPrintType.AWARD_NOTICE_REPORT, this.populateResponseParametersForNotice(awardPrintNotice));
        AwardNoticePrintout awardPrintout = new AwardNoticePrintout(award.getAwardId(), award.getAwardNumber(), award.getUnitNumber());
        awardPrintout.setPdfContent(dataStream.getData());
        return (AwardNoticePrintout)this.getBusinessObjectService().save((PersistableBusinessObject)awardPrintout);
    }

    protected Map<String, Object> populateResponseParametersForNotice(AwardPrintNotice awardPrintNotice) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put(AwardPrintParameters.ADDRESS_LIST.getAwardPrintParameter(), awardPrintNotice.getSponsorContacts());
        reportParameters.put(AwardPrintParameters.FOREIGN_TRAVEL.getAwardPrintParameter(), awardPrintNotice.getForeignTravel());
        reportParameters.put(AwardPrintParameters.REPORTING.getAwardPrintParameter(), awardPrintNotice.getReports());
        reportParameters.put(AwardPrintParameters.CLOSEOUT.getAwardPrintParameter(), awardPrintNotice.getCloseout());
        reportParameters.put(AwardPrintParameters.FUNDING_SUMMARY.getAwardPrintParameter(), awardPrintNotice.getFundingSummary());
        reportParameters.put(AwardPrintParameters.SPECIAL_REVIEW.getAwardPrintParameter(), awardPrintNotice.getSpecialReview());
        reportParameters.put(AwardPrintParameters.COMMENTS.getAwardPrintParameter(), awardPrintNotice.getComments());
        reportParameters.put(AwardPrintParameters.HIERARCHY_INFO.getAwardPrintParameter(), awardPrintNotice.getHierarchy());
        reportParameters.put(AwardPrintParameters.SUBCONTRACT.getAwardPrintParameter(), awardPrintNotice.getSubAward());
        reportParameters.put(AwardPrintParameters.COST_SHARING.getAwardPrintParameter(), awardPrintNotice.getCostShare());
        reportParameters.put(AwardPrintParameters.KEYWORDS.getAwardPrintParameter(), awardPrintNotice.getKeywords());
        reportParameters.put(AwardPrintParameters.TECHNICAL_REPORTING.getAwardPrintParameter(), awardPrintNotice.getTechnicalReports());
        reportParameters.put(AwardPrintParameters.EQUIPMENT.getAwardPrintParameter(), awardPrintNotice.getEquipment());
        reportParameters.put(AwardPrintParameters.OTHER_DATA.getAwardPrintParameter(), awardPrintNotice.getOtherData());
        reportParameters.put(AwardPrintParameters.TERMS.getAwardPrintParameter(), awardPrintNotice.getTerms());
        reportParameters.put(AwardPrintParameters.FA_COST.getAwardPrintParameter(), awardPrintNotice.getFaRates());
        reportParameters.put(AwardPrintParameters.PAYMENT.getAwardPrintParameter(), awardPrintNotice.getPayment());
        reportParameters.put(AwardPrintParameters.FLOW_THRU.getAwardPrintParameter(), awardPrintNotice.getFlowThru());
        reportParameters.put(AwardPrintParameters.PROPOSAL_DUE.getAwardPrintParameter(), false);
        reportParameters.put(AwardPrintParameters.SIGNATURE_REQUIRED.getAwardPrintParameter(), awardPrintNotice.getRequireSignature());
        return reportParameters;
    }

    @Override
    protected KcNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = KcServiceLocator.getService(KcNotificationService.class);
        }
        return this.notificationService;
    }

    public ActionForward printChangeReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put(AwardPrintParameters.SIGNATURE_REQUIRED.getAwardPrintParameter(), awardForm.getAwardPrintChangeReport().getRequireSignature());
        reportParameters.put(AwardPrintParameters.SEQUENCE_NUMBER.getAwardPrintParameter(), awardForm.getAwardPrintChangeReport().getAwardVersion());
        reportParameters.put(AwardPrintParameters.TRANSACTION_ID_INDEX.getAwardPrintParameter(), awardForm.getAwardPrintChangeReport().getAmountInfoIndex());
        AttachmentDataSource dataStream = this.getAwardPrintingService().printAwardReport(awardForm.getAwardDocument().getAward(), AwardPrintType.AWARD_DELTA_REPORT, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        AttachmentDataSource dataStream = this.getAwardPrintingService().printAwardReport(awardForm.getAwardDocument().getAward(), AwardPrintType.AWARD_BUDGET_HIERARCHY, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printHierarchyModification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        return mapping.findForward("basic");
    }

    public ActionForward printBudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward printTimeMoneyHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        AttachmentDataSource dataStream = this.getAwardPrintingService().printAwardReport(awardForm.getAwardDocument().getAward(), AwardPrintType.MONEY_AND_END_DATES_HISTORY, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printTransactionDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        if (awardForm.getAwardTimeAndMoneyTransactionReport().getAmountInfoIndex() == null) {
            GlobalVariables.getMessageMap().putError("awardTimeAndMoneyTransactionReport.amountInfoIndex", "error.award.print.transactionId.required", new String[0]);
            return mapping.findForward("basic");
        }
        reportParameters.put(AwardPrintParameters.SEQUENCE_NUMBER.getAwardPrintParameter(), awardForm.getAwardTimeAndMoneyTransactionReport().getAwardVersion());
        reportParameters.put(AwardPrintParameters.TRANSACTION_ID_INDEX.getAwardPrintParameter(), awardForm.getAwardTimeAndMoneyTransactionReport().getAmountInfoIndex());
        AttachmentDataSource dataStream = this.getAwardPrintingService().printAwardReport(awardForm.getAwardDocument().getAward(), AwardPrintType.AWARD_BUDGET_HISTORY_TRANSACTION, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    protected AwardPrintingService getAwardPrintingService() {
        if (this.awardPrintingService == null) {
            this.awardPrintingService = KcServiceLocator.getService(AwardPrintingService.class);
        }
        return this.awardPrintingService;
    }

    @Override
    public AwardNumberService getAwardNumberService() {
        return KcServiceLocator.getService(AwardNumberService.class);
    }

    protected String getAwardNumber(HttpServletRequest request) {
        String awardNumber = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            awardNumber = StringUtils.substringBetween((String)parameterName, (String)".awardNumber", (String)".");
        }
        return awardNumber;
    }

    private int getActiveHierarchyObjectIndex(HttpServletRequest request) throws Exception {
        Enumeration lookupParameters = request.getParameterNames();
        int index = -1;
        while (lookupParameters.hasMoreElements()) {
            String temp = (String)lookupParameters.nextElement();
            if (!temp.startsWith("awardHierarchyTempObject[")) continue;
            index = temp.indexOf("awardHierarchyTempObject[") + 25;
            temp = temp.substring(index, index + 1);
            index = Integer.parseInt(temp);
            break;
        }
        return index;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        Award currentAward = awardDocument.getAward();
        this.buildAwardHierarchySourceAndTargetList(awardForm, currentAward);
        return super.refresh(mapping, form, request, response);
    }

    private AwardHierarchy findTargetNode(HttpServletRequest request, AwardForm awardForm) {
        return awardForm.getAwardHierarchyBean().getRootNode().findNodeInHierarchy(this.getAwardNumber(request));
    }

    private ActionForward prepareToForwardToNewChildAward(ActionMapping mapping, AwardForm awardForm, AwardHierarchy targetNode, AwardHierarchy newNodeToView) throws WorkflowException {
        ActionForward forward;
        if (newNodeToView != null) {
            awardForm.setCommand("initiate");
            this.createDocument((KualiDocumentFormBase)awardForm);
            Award newChildAward = newNodeToView.getAward();
            if (!newNodeToView.isRootNode()) {
                this.setMultipleNodeHierarchyOnAwardFormTrue(newChildAward);
            }
            awardForm.getAwardDocument().setAward(newChildAward);
            awardForm.getAwardHierarchyBean().recordTargetNodeState(targetNode);
            awardForm.getFundingProposalBean().setAllAwardsForAwardNumber(null);
            forward = mapping.findForward("home");
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    private ActionForward prepareToForwardToNewFinalChildAward(ActionMapping mapping, AwardForm awardForm, HttpServletRequest request, HttpServletResponse response, AwardHierarchy targetNode, AwardHierarchy newNodeToView) throws Exception {
        ActionForward forward;
        if (newNodeToView != null) {
            awardForm.setCommand("initiate");
            this.createDocument((KualiDocumentFormBase)awardForm);
            Award newChildAward = newNodeToView.getAward();
            if (!newNodeToView.isRootNode()) {
                this.setMultipleNodeHierarchyOnAwardFormTrue(newChildAward);
            }
            awardForm.getAwardDocument().setAward(newChildAward);
            awardForm.getAwardDocument().getDocumentHeader().setDocumentDescription("Copied Hierarchy");
            awardForm.getAwardHierarchyBean().recordTargetNodeState(targetNode);
            awardForm.getFundingProposalBean().setAllAwardsForAwardNumber(null);
            super.save(mapping, (ActionForm)awardForm, request, response);
            super.submitAward(mapping, (ActionForm)awardForm, request, response);
            forward = mapping.findForward("home");
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    private void setMultipleNodeHierarchyOnAwardFormTrue(Award award) {
        award.setAwardInMultipleNodeHierarchy(true);
    }

    private String getHierarchyTargetAwardNumber(HttpServletRequest request) {
        return request.getParameter("awardNumberInputTemp");
    }

    public ActionForward createAccount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        Award award = awardDocument.getAward();
        if (awardForm.getEditingMode().get("createAwardAccount").equals("true")) {
            AwardAccountValidationService accountValidationService = this.getAwardAccountValidationService();
            boolean rulePassed = accountValidationService.validateAwardAccountDetails(award);
            if (rulePassed) {
                if (this.isFinancialSystemIntegrationParameterOn()) {
                    if (!this.createAccount(awardForm, award)) {
                        return mapping.findForward("icrRateCodePrompt");
                    }
                } else if (this.getAwardAccountService().isFinancialRestApiEnabled()) {
                    this.getAwardService().addPostEntry(award.getAwardId(), award.getAccountNumber(), award.getAwardNumber(), awardDocument.getDocumentNumber(), Boolean.FALSE);
                    this.getAwardService().addAccountInformation(award.getAwardId(), award.getAccountNumber());
                    this.getDocumentService().saveDocument((Document)awardDocument);
                }
            }
        } else {
            GlobalVariables.getMessageMap().putError(NO_PERMISSION_TO_CREATE_ACCOUNT, NO_PERMISSION_TO_CREATE_ACCOUNT, new String[0]);
        }
        ActionForward forward = mapping.findForward("awardActions");
        return forward;
    }

    protected boolean createAccount(AwardForm awardForm, Award award) throws DatatypeConfigurationException, WorkflowException {
        AccountCreationClient client = this.getAccountCreationClient();
        if (award.getFinancialAccountDocumentNumber() == null) {
            if (this.determineIndirectCostRateCode(awardForm, award)) {
                return false;
            }
            client.createAwardAccount(award);
        } else {
            GlobalVariables.getMessageMap().putError(ACCOUNT_ALREADY_CREATED, ACCOUNT_ALREADY_CREATED, new String[0]);
        }
        return true;
    }

    protected boolean isFinancialSystemIntegrationParameterOn() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "FIN_SYSTEM_INTEGRATION_ON");
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    protected boolean determineIndirectCostRateCode(AwardForm awardForm, Award award) {
        if (StringUtils.isBlank((CharSequence)award.getIcrRateCode())) {
            List<ValidRates> validRates = awardForm.getAccountCreationHelper().getMatchingValidRates(award.getCurrentFandaRate());
            if (validRates.size() > 1) {
                awardForm.getAccountCreationHelper().setValidRateCandidates(validRates);
                return true;
            }
            if (validRates.size() == 1) {
                award.setIcrRateCode(validRates.get(0).getIcrRateCode());
            } else {
                award.setIcrRateCode("ICRNONE");
            }
        }
        return false;
    }

    protected AccountCreationClient getAccountCreationClient() {
        return (AccountCreationClient)KcServiceLocator.getService("accountCreationClient");
    }

    protected AwardAccountValidationService getAwardAccountValidationService() {
        return (AwardAccountValidationService)KcServiceLocator.getService("awardAccountValidationService");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        Set<String> linkedPendingProposals = this.getLinkedPendingProposals(award);
        if (!linkedPendingProposals.isEmpty()) {
            String proposalNumbers = StringUtils.join(linkedPendingProposals, (String)", ");
            GlobalVariables.getMessageMap().putError("noKey", ERROR_CANCEL_PENDING_PROPOSALS, new String[]{proposalNumbers});
            return mapping.findForward("basic");
        }
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, "DocCancel", this.getKualiConfigurationService().getPropertyValueAsString("document.question.cancel.text"), "confirmationQuestion", "cancel", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("DocCancel".equals(question) && "1".equals(buttonClicked)) {
            return mapping.findForward("basic");
        }
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost((KualiForm)kualiDocumentFormBase, request);
        if (award.getSequenceNumber() == 1) {
            AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchy(award.getAwardNumber());
            hierarchy.setActive(false);
            this.getBusinessObjectService().save((PersistableBusinessObject)hierarchy);
        }
        this.getDocumentService().cancelDocument(kualiDocumentFormBase.getDocument(), kualiDocumentFormBase.getAnnotation());
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    private Set<String> getLinkedPendingProposals(Award award) {
        HashSet<String> linkedPendingProposals = new HashSet<String>();
        for (AwardFundingProposal awardFundingProposal : award.getFundingProposals()) {
            String proposalNumber = awardFundingProposal.getProposal().getProposalNumber();
            InstitutionalProposal pendingVersion = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(proposalNumber);
            if (pendingVersion == null || !pendingVersion.isFundedByAward(award.getAwardNumber(), award.getSequenceNumber())) continue;
            linkedPendingProposals.add(proposalNumber);
        }
        return linkedPendingProposals;
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        return KcServiceLocator.getService(InstitutionalProposalService.class);
    }

    @Override
    protected VersionHistoryService getVersionHistoryService() {
        return KcServiceLocator.getService(VersionHistoryService.class);
    }

    public ActionForward syncSponsor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        this.getAwardSyncCreationService().addAwardSyncChange(award, new AwardSyncPendingChangeBean(AwardSyncType.ADD_SYNC, award, "sponsorCode", "sponsorCode"));
        return mapping.findForward("basic");
    }

    public ActionForward syncStatusCode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        this.getAwardSyncCreationService().addAwardSyncChange(award, new AwardSyncPendingChangeBean(AwardSyncType.ADD_SYNC, award, "statusCode", "statusCode"));
        return mapping.findForward("basic");
    }

    public ActionForward deleteChanges(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        ListIterator<AwardSyncChange> iter = award.getSyncChanges().listIterator();
        while (iter.hasNext()) {
            AwardSyncChange change = iter.next();
            if (!change.isDelete()) continue;
            this.getBusinessObjectService().delete((Object)change);
            iter.remove();
        }
        return mapping.findForward("basic");
    }

    public ActionForward activateSyncMode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.setSyncMode(true);
        return mapping.findForward("basic");
    }

    public ActionForward deactivateSyncMode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.setSyncMode(false);
        return mapping.findForward("basic");
    }

    public ActionForward clearSyncSelections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        for (AwardSyncChange change : awardForm.getAwardDocument().getAward().getSyncChanges()) {
            change.setSyncDescendants(null);
            change.setSyncFabricated(false);
            change.setSyncCostSharing(false);
        }
        return mapping.findForward("basic");
    }

    public ActionForward rerunValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardSyncBean().getParentAwardStatus().setStatus("Validation In Progress");
        this.getBusinessObjectService().save((PersistableBusinessObject)awardForm.getAwardSyncBean().getParentAwardStatus());
        awardForm.getAwardDocument().getDocumentHeader().getWorkflowDocument().returnToPreviousNode("Re-run Hierarchy Sync Validation", "hasSync");
        return mapping.findForward("basic");
    }

    public ActionForward postAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        this.getAwardService().addPostEntry(award.getAwardId(), award.getAccountNumber(), award.getAwardNumber(), awardForm.getAwardDocument().getDocumentNumber(), Boolean.TRUE);
        this.getGlobalVariableService().getMessageMap().putInfo("info.award.information.posted", "info.award.information.posted", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardNotificationContext context = new AwardNotificationContext(award, "999", "Ad-Hoc Notification", "awardActions");
        awardForm.getNotificationHelper().initializeDefaultValues(context);
        return mapping.findForward(NOTIFICATION_EDITOR);
    }
}

