/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocValue;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.bo.KcNotification;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.ProtocolVersionService;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolSubmissionBuilder;
import org.kuali.kra.irb.actions.ProtocolSubmissionDoc;
import org.kuali.kra.irb.actions.notification.ProtocolDisapprovedNotificationRenderer;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondence;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.protocol.location.ProtocolLocationService;
import org.kuali.kra.irb.protocol.research.ProtocolResearchAreaService;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolSpecialVersion;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krms.api.engine.Facts;

@ParameterConstants.NAMESPACE(namespace="KC-PROTOCOL")
@ParameterConstants.COMPONENT(component="Document")
public class ProtocolDocument
extends ProtocolDocumentBase {
    private static final long serialVersionUID = 803158468103165087L;
    private static final Logger LOG = LogManager.getLogger(ProtocolDocument.class);
    public static final String DOCUMENT_TYPE_CODE = "PROT";
    private static final String listOfStatiiEligibleForMerging = "101 102 103 104 105 106 302 303 304";
    private static final String DISAPPROVED_CONTEXT_NAME = "Disapproved";
    private List<CustomAttributeDocValue> customDataList = new ArrayList<CustomAttributeDocValue>();
    private transient ProjectRetrievalService projectRetrievalService;

    @Override
    public Protocol getProtocol() {
        return (Protocol)super.getProtocol();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    @Override
    protected void mergeProtocolAmendment() {
        if (this.isAmendment()) {
            this.mergeAmendment("400", ProtocolSpecialVersion.AMENDMENT.getDescription());
        } else if (this.isRenewal()) {
            this.mergeAmendment("401", ProtocolSpecialVersion.RENEWAL.getDescription());
        } else if (this.isFYI()) {
            this.mergeAmendment("901", ProtocolSpecialVersion.FYI.getDescription());
            this.mergeFyiAttachments();
        }
    }

    protected void mergeFyiAttachments() {
        ProtocolSubmission fyiSubmission = null;
        ProtocolActionBase fyiApprovedAction = null;
        String fyiNumber = this.getProtocol().getProtocolNumber().substring(this.getProtocol().getProtocolNumber().indexOf(ProtocolSpecialVersion.FYI.getCode()) + 1);
        Protocol originalProtocol = this.getProtocolFinder().findCurrentProtocolByNumber(this.getOriginalProtocolNumber());
        for (ProtocolActionBase originalAction : originalProtocol.getProtocolActions()) {
            if (originalAction.getComments() == null || !originalAction.getComments().contains(ProtocolSpecialVersion.FYI.getDescription() + "-" + fyiNumber + ": Created")) continue;
            fyiApprovedAction = originalAction;
            break;
        }
        if (fyiApprovedAction != null) {
            fyiSubmission = originalProtocol.getProtocolSubmission();
            if (fyiApprovedAction.getSubmissionIdFk() == null) {
                fyiApprovedAction.setProtocolSubmission(fyiSubmission);
                fyiApprovedAction.setSubmissionIdFk(fyiSubmission.getSubmissionId());
                fyiApprovedAction.setSubmissionNumber(fyiSubmission.getSubmissionNumber());
                this.getBusinessObjectService().save((PersistableBusinessObject)fyiApprovedAction);
            }
        }
        if (fyiSubmission != null) {
            ArrayList<ProtocolSubmissionDoc> mergedAttachments = new ArrayList<ProtocolSubmissionDoc>();
            for (ProtocolAttachmentProtocolBase attachment : this.getProtocol().getActiveAttachmentProtocols()) {
                ProtocolSubmissionDoc fyiAttachment = ProtocolSubmissionBuilder.createProtocolSubmissionDoc(fyiSubmission, attachment.getFile().getName(), attachment.getFile().getType(), attachment.getFile().getData(), attachment.getDescription());
                fyiAttachment.setProtocolNumber(fyiApprovedAction.getProtocolNumber());
                fyiAttachment.setProtocolId(fyiApprovedAction.getProtocolId());
                fyiAttachment.setProtocol(originalProtocol);
                mergedAttachments.add(fyiAttachment);
            }
            this.getBusinessObjectService().save(mergedAttachments);
        } else {
            LOG.error("Couldn't merge FYI attachments into parent protocol-- no submission found for FYI #" + this.getProtocol().getProtocolNumber());
        }
    }

    protected void mergeAmendment(String protocolStatusCode, String type) {
        ProtocolDocument newProtocolDocument;
        Timestamp approvalActionDate = this.getProtocol().getLastProtocolAction().getActionDate();
        Protocol currentProtocol = this.getProtocolFinder().findCurrentProtocolByNumber(this.getOriginalProtocolNumber());
        try {
            currentProtocol.setProtocolDocument((ProtocolDocument)this.getDocumentService().getByDocumentHeaderId(currentProtocol.getProtocolDocument().getDocumentNumber()));
            currentProtocol.setMergeAmendment(true);
            newProtocolDocument = (ProtocolDocument)this.getProtocolVersionService().versionProtocolDocument(currentProtocol.getProtocolDocument());
        }
        catch (Exception e) {
            throw new ProtocolDocumentBase.ProtocolMergeException(e);
        }
        newProtocolDocument.getProtocol().merge(this.getProtocol());
        this.getProtocol().setProtocolStatusCode(protocolStatusCode);
        ProtocolActionBase lastApprovalAction = this.getLastApprovalAction();
        List<ProtocolSubmissionBase> protocolSubmissions = newProtocolDocument.getProtocol().getProtocolSubmissions();
        ProtocolSubmission mergedSubmission = (ProtocolSubmission)(protocolSubmissions == null || protocolSubmissions.size() == 0 ? null : protocolSubmissions.get(protocolSubmissions.size() - 1));
        ProtocolAction action = new ProtocolAction(newProtocolDocument.getProtocol(), mergedSubmission, lastApprovalAction.getProtocolActionTypeCode());
        action.setComments(type + "-" + this.getProtocolNumberIndex() + ": Approved");
        action.setActionDate(approvalActionDate);
        newProtocolDocument.setProtocolWorkflowType(ProtocolDocumentBase.ProtocolWorkflowType.APPROVED);
        newProtocolDocument.getProtocol().getProtocolActions().add(action);
        if (this.isProtocolExpiredAndForRenewal(currentProtocol) || this.isProtocolSuspendedAndForAmendmentOrRenewal(currentProtocol)) {
            newProtocolDocument.getProtocol().setProtocolStatusCode("200");
        }
        try {
            this.getDocumentService().saveDocument((Document)newProtocolDocument);
            this.setProtocolDocumentToApproveByDefault();
            newProtocolDocument.getDocumentHeader().getWorkflowDocument().route(type + "-" + this.getProtocolNumberIndex() + ": merged");
        }
        catch (WorkflowException e) {
            throw new ProtocolDocumentBase.ProtocolMergeException(e);
        }
        newProtocolDocument.getProtocol().reconcileActionsWithSubmissions();
        this.getBusinessObjectService().save(newProtocolDocument.getProtocol().getProtocolActions());
        this.getProtocol().setActive(false);
        for (ProtocolBase otherProtocol : this.getProtocolFinder().findProtocols(this.getOriginalProtocolNumber())) {
            String status = otherProtocol.getProtocolStatus().getProtocolStatusCode();
            if (!this.isEligibleForMerging(status, (Protocol)otherProtocol)) continue;
            LOG.info("Merging amendment " + this.getProtocol().getProtocolNumber() + " into editable protocol " + otherProtocol.getProtocolNumber());
            otherProtocol.merge((ProtocolBase)this.getProtocol(), false);
            String protocolType = protocolStatusCode.equals("400") ? "103" : "102";
            action = new ProtocolAction((Protocol)otherProtocol, null, protocolType);
            action.setComments(type + "-" + this.getProtocolNumberIndex() + ": Merged");
            otherProtocol.getProtocolActions().add(action);
            this.getBusinessObjectService().save((PersistableBusinessObject)otherProtocol);
        }
        this.finalizeAttachmentProtocol(this.getProtocol());
        this.getBusinessObjectService().save((PersistableBusinessObject)this);
        this.mergeProtocolCorrespondenceAndNotification(newProtocolDocument, this.getLastApprovalAction().getProtocolActionType().getProtocolActionTypeCode());
    }

    private boolean isProtocolExpiredAndForRenewal(Protocol currentProtocol) {
        return currentProtocol.getProtocolStatusCode().equals("305") && this.isRenewal();
    }

    private boolean isProtocolSuspendedAndForAmendmentOrRenewal(Protocol currentProtocol) {
        String currentProtocolStatus = currentProtocol.getProtocolStatusCode();
        return !(!currentProtocolStatus.equals("311") && !currentProtocolStatus.equals("308") && !currentProtocolStatus.equals("302") || !this.isRenewal() && !this.isAmendment() && !this.isRenewalWithAmendment());
    }

    protected void mergeProtocolCorrespondenceAndNotification(ProtocolDocument newProtocolDocument, String protocolActionType) {
        KcPersistableBusinessObjectBase getProtocolPaToUse = null;
        for (ProtocolActionBase pa : this.getProtocol().getProtocolActions()) {
            if (!StringUtils.equals((CharSequence)protocolActionType, (CharSequence)pa.getProtocolActionTypeCode()) || getProtocolPaToUse != null && !getProtocolPaToUse.getUpdateTimestamp().before(pa.getUpdateTimestamp())) continue;
            getProtocolPaToUse = (ProtocolAction)pa;
        }
        KcPersistableBusinessObjectBase newDocPaToUse = null;
        for (ProtocolActionBase pa2 : newProtocolDocument.getProtocol().getProtocolActions()) {
            if (!this.isProtocolApproved(pa2.getProtocolActionTypeCode()) || newDocPaToUse != null && !newDocPaToUse.getUpdateTimestamp().before(pa2.getUpdateTimestamp())) continue;
            newDocPaToUse = (ProtocolAction)pa2;
        }
        if (newDocPaToUse != null && getProtocolPaToUse != null) {
            for (org.kuali.kra.protocol.correspondence.ProtocolCorrespondence pc : ((ProtocolActionBase)getProtocolPaToUse).getProtocolCorrespondences()) {
                ProtocolCorrespondence newPc = new ProtocolCorrespondence();
                newPc.setActionId(pc.getActionId());
                newPc.setActionIdFk(((ProtocolActionBase)newDocPaToUse).getProtocolActionId());
                newPc.setCorrespondence(pc.getCorrespondence());
                newPc.setCreateTimestamp(pc.getCreateTimestamp());
                newPc.setCreateUser(pc.getCreateUser());
                newPc.setExtension(pc.getExtension());
                newPc.setFinalFlag(pc.getFinalFlag());
                newPc.setFinalFlagTimestamp(pc.getFinalFlagTimestamp());
                newPc.setForwardName(pc.getForwardName());
                newPc.setHoldingPage(pc.isHoldingPage());
                newPc.setNewCollectionRecord(pc.isNewCollectionRecord());
                newPc.setNotificationRequestBean(pc.getNotificationRequestBean());
                newPc.setProtocol(((ProtocolAssociateBase)newDocPaToUse).getProtocol());
                newPc.setProtocolAction((ProtocolActionBase)newDocPaToUse);
                newPc.setProtocolCorrespondenceType(pc.getProtocolCorrespondenceType());
                newPc.setProtocolId(((ProtocolAssociateBase)newDocPaToUse).getProtocolId());
                newPc.setProtocolNumber(((ProtocolAssociateBase)newDocPaToUse).getProtocolNumber());
                newPc.setProtoCorrespTypeCode(pc.getProtoCorrespTypeCode());
                newPc.setRegenerateFlag(pc.isRegenerateFlag());
                newPc.setSequenceNumber(pc.getSequenceNumber());
                if (((ProtocolActionBase)newDocPaToUse).getProtocolCorrespondences() == null) {
                    ((ProtocolActionBase)newDocPaToUse).setProtocolCorrespondences(new ArrayList<org.kuali.kra.protocol.correspondence.ProtocolCorrespondence>());
                }
                ((ProtocolActionBase)newDocPaToUse).getProtocolCorrespondences().add(newPc);
                this.getBusinessObjectService().save((PersistableBusinessObject)newPc);
            }
            for (KcNotification notification : ((ProtocolActionBase)getProtocolPaToUse).getProtocolNotifications()) {
                IRBProtocolNotification newNotification = IRBProtocolNotification.copy(notification);
                newNotification.resetPersistenceState();
                newNotification.persistOwningObject(newProtocolDocument.getProtocol());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)newDocPaToUse);
        }
    }

    private boolean isProtocolApproved(String protocolActionTypeCode) {
        return StringUtils.equals((CharSequence)"204", (CharSequence)protocolActionTypeCode) || StringUtils.equals((CharSequence)"205", (CharSequence)protocolActionTypeCode) || StringUtils.equals((CharSequence)"208", (CharSequence)protocolActionTypeCode);
    }

    private boolean isEligibleForMerging(String status, Protocol otherProtocol) {
        return listOfStatiiEligibleForMerging.contains(status) && !StringUtils.equals((CharSequence)this.getProtocol().getProtocolNumber(), (CharSequence)otherProtocol.getProtocolNumber());
    }

    private void finalizeAttachmentProtocol(Protocol protocol) {
        for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
            attachment.setProtocol(protocol);
            if (!attachment.isDraft()) continue;
            attachment.setDocumentStatusCode("2");
        }
    }

    private ProtocolVersionService getProtocolVersionService() {
        return KcServiceLocator.getService(ProtocolVersionService.class);
    }

    private ProtocolFinderDao getProtocolFinder() {
        return KcServiceLocator.getService(ProtocolFinderDao.class);
    }

    private ProtocolActionBase getLastApprovalAction() {
        ProtocolActionBase result = null;
        for (ProtocolActionBase action : this.getProtocol().getProtocolActions()) {
            if (!"204".equals(action.getProtocolActionTypeCode()) && !"205".equals(action.getProtocolActionTypeCode()) && !"206".equals(action.getProtocolActionTypeCode()) && !"208".equals(action.getProtocolActionTypeCode())) continue;
            result = action;
        }
        return result;
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = true;
        if (this.getProtocol().getProtocolStatusCode().equals("101")) {
            if (this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("Initiated")) {
                isComplete = false;
            }
            this.getProtocol().getProtocolSubmission().refreshReferenceObject("submissionStatus");
            String status = this.getProtocol().getProtocolSubmission().getSubmissionStatusCode();
            if (!this.isNormal() && status.equals("203") && this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("IRBReview")) {
                isComplete = false;
            }
        } else {
            if (this.getProtocol().getProtocolStatusCode().equals("400") || this.getProtocol().getProtocolStatusCode().equals("401") || this.getProtocol().getProtocolStatusCode().equals("901")) {
                String protocolId = this.getNewProtocolDocId();
                if (ObjectUtils.isNull((Object)protocolId)) {
                    isComplete = false;
                } else {
                    String oldLocation = (String)GlobalVariables.getUserSession().retrieveObject("holdingPageReturnLocation");
                    String oldDocNbr = this.getProtocol().getProtocolDocument().getDocumentNumber();
                    String returnLocation = oldLocation.replaceFirst(oldDocNbr, protocolId);
                    GlobalVariables.getUserSession().addObject("holdingPageReturnLocation", (Object)returnLocation);
                }
            }
            if (!this.getDocumentHeader().getWorkflowDocument().isFinal()) {
                isComplete = false;
            }
        }
        return isComplete;
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("namespaceCode", "KC-PROTOCOL");
        qualifiers.put("name", "KC Protocol Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        KcKrmsFactBuilderServiceHelper fbService = (KcKrmsFactBuilderServiceHelper)KcServiceLocator.getService("irbProtocolFactBuilderService");
        fbService.addFacts(factsBuilder, this);
    }

    @Override
    protected Protocol createNewProtocolInstanceHook() {
        return new Protocol();
    }

    @Override
    protected Class<? extends org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaService> getProtocolResearchAreaServiceClassHook() {
        return ProtocolResearchAreaService.class;
    }

    @Override
    protected Class<? extends ResearchAreaBase> getResearchAreaBoClassHook() {
        return ResearchArea.class;
    }

    @Override
    protected ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase protocol, ProtocolSubmissionBase protocolSubmission, String actionTypeCode) {
        return new ProtocolAction((Protocol)protocol, (ProtocolSubmission)protocolSubmission, actionTypeCode);
    }

    @Override
    protected Class<? extends org.kuali.kra.protocol.actions.submit.ProtocolActionService> getProtocolActionServiceClassHook() {
        return ProtocolActionService.class;
    }

    @Override
    protected Class<? extends org.kuali.kra.protocol.protocol.location.ProtocolLocationService> getProtocolLocationServiceClassHook() {
        return ProtocolLocationService.class;
    }

    @Override
    protected Class<? extends ProtocolBase> getProtocolBOClassHook() {
        return Protocol.class;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getCustomDataList();
    }

    public List<CustomAttributeDocValue> getCustomDataList() {
        return this.customDataList;
    }

    public void setCustomDataList(List<CustomAttributeDocValue> customDataList) {
        this.customDataList = customDataList;
    }

    @Override
    protected Class<? extends ProtocolGenericActionService> getProtocolGenericActionServiceClassHook() {
        return ProtocolGenericActionService.class;
    }

    @Override
    protected ProtocolNotification getNewProtocolNotificationInstanceHook() {
        return new IRBProtocolNotification();
    }

    @Override
    protected ProtocolNotificationContextBase getDisapproveNotificationContextHook(ProtocolBase protocol) {
        return new IRBNotificationContext((Protocol)protocol, "304", DISAPPROVED_CONTEXT_NAME, (NotificationRenderer)new ProtocolDisapprovedNotificationRenderer((Protocol)protocol));
    }

    @Override
    protected String getCommitteeDisapprovedStatusCodeHook() {
        return "306";
    }

    @Override
    public ProjectRetrievalService getProjectRetrievalService() {
        if (this.projectRetrievalService == null) {
            this.projectRetrievalService = (ProjectRetrievalService)KcServiceLocator.getService("irbProjectRetrievalService");
        }
        return this.projectRetrievalService;
    }

    @Override
    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }
}

