/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.meeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleMinuteDocBase;
import org.kuali.coeus.common.committee.impl.meeting.CommonMeetingService;
import org.kuali.coeus.common.committee.impl.meeting.MeetingActionsActionBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingControllerService;
import org.kuali.coeus.common.committee.impl.meeting.ScheduleAgendaBase;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.questionnaire.framework.print.CorrespondencePrintingService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteePrintingService;
import org.kuali.kra.committee.service.ScheduleCorrespondencePrint;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.correspondence.AbstractProtocolActionsCorrespondence;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericCorrespondence;
import org.kuali.kra.irb.actions.grantexemption.GrantExemptionCorrespondence;
import org.kuali.kra.irb.actions.withdraw.WithdrawCorrespondence;
import org.kuali.kra.meeting.CommScheduleMinuteDoc;
import org.kuali.kra.meeting.MeetingForm;
import org.kuali.kra.meeting.MeetingHelper;
import org.kuali.kra.meeting.MeetingService;
import org.kuali.kra.meeting.ScheduleAgenda;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionLiteBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.util.GlobalVariables;

public class MeetingActionsAction
extends MeetingActionsActionBase {
    private static final String AGENDA_TYPE = "9";
    private static final String MEETING_MINUTE_TYPE = "10";
    private static final List GENERIC_TYPE_CORRESPONDENCE;
    private static final Map<String, String> CORR_TYPE_TO_ACTION_TYPE_MAP;

    @Override
    protected CommitteePrintingService getCommitteePrintingService() {
        return KcServiceLocator.getService(CommitteePrintingService.class);
    }

    @Override
    public ActionForward regenerateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MeetingHelper meetingHelper = (MeetingHelper)((MeetingForm)form).getMeetingHelper();
        meetingHelper.setRegeneratedCorrespondences(new ArrayList<ProtocolCorrespondence>());
        for (ProtocolCorrespondence protocolCorrespondence : meetingHelper.getCorrespondences()) {
            if (!protocolCorrespondence.isRegenerateFlag()) continue;
            Protocol protocol = (Protocol)protocolCorrespondence.getProtocol();
            AttachmentDataSource dataSource = this.generateCorrespondenceDocumentAndAttach(protocol, protocolCorrespondence.getProtoCorrespTypeCode());
            MeetingActionsActionBase.PrintableAttachment source = new MeetingActionsActionBase.PrintableAttachment(this);
            if (dataSource != null) {
                protocolCorrespondence.setCorrespondence(dataSource.getData());
                protocolCorrespondence.setFinalFlag(false);
                protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
                protocolCorrespondence.setCreateTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            }
            meetingHelper.getRegeneratedCorrespondences().add(protocolCorrespondence);
        }
        this.getBusinessObjectService().save(meetingHelper.getRegeneratedCorrespondences());
        return mapping.findForward("correspondence");
    }

    protected AttachmentDataSource generateCorrespondenceDocumentAndAttach(Protocol protocol, String correspondenceType) throws PrintingException {
        AbstractProtocolActionsCorrespondence correspondence = null;
        if (StringUtils.equals((CharSequence)"16", (CharSequence)correspondenceType)) {
            correspondence = new WithdrawCorrespondence();
        } else if (GENERIC_TYPE_CORRESPONDENCE.contains(correspondenceType)) {
            correspondence = new ProtocolGenericCorrespondence(CORR_TYPE_TO_ACTION_TYPE_MAP.get(correspondenceType));
        } else if (StringUtils.equals((CharSequence)"17", (CharSequence)correspondenceType)) {
            correspondence = new GrantExemptionCorrespondence();
        }
        correspondence.setProtocol(protocol);
        return this.getProtocolActionCorrespondenceGenerationService().reGenerateCorrespondenceDocument(correspondence);
    }

    protected ProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return KcServiceLocator.getService(ProtocolActionCorrespondenceGenerationService.class);
    }

    @Override
    protected ScheduleAgendaBase getNewScheduleAgendaInstanceHook() {
        return new ScheduleAgenda();
    }

    @Override
    protected String getProtocolCorrespondenceAgendaTypeCodeHook() {
        return AGENDA_TYPE;
    }

    @Override
    protected CommScheduleMinuteDocBase getNewCommScheduleMinuteDocInstanceHook() {
        return new CommScheduleMinuteDoc();
    }

    @Override
    protected String getProtocolCorrespondenceMinutesTypeCodeHook() {
        return MEETING_MINUTE_TYPE;
    }

    @Override
    protected Class<? extends CommitteeScheduleBase> getCommitteeScheduleBOClass() {
        return CommitteeSchedule.class;
    }

    @Override
    protected String getDocumentNumber(ProtocolSubmissionLiteBase protocolSubmission) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("protocolId", protocolSubmission.getProtocolId().toString());
        Protocol protocol = (Protocol)this.getBusinessObjectService().findByPrimaryKey(Protocol.class, criteria);
        return protocol.getProtocolDocument().getDocumentNumber();
    }

    @Override
    protected String getActionIdHook() {
        return "protocolProtocolActions";
    }

    @Override
    protected CommonMeetingService getMeetingService() {
        return KcServiceLocator.getService(MeetingService.class);
    }

    @Override
    protected ReviewCommentsService<?> getReviewerCommentsService() {
        return KcServiceLocator.getService(org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsService.class);
    }

    @Override
    protected CorrespondencePrintingService getCorrespondencePrintingService() {
        return KcServiceLocator.getService(ScheduleCorrespondencePrint.class);
    }

    @Override
    protected MeetingControllerService getMeetingControllerService() {
        return (MeetingControllerService)KcServiceLocator.getService("meetingControllerService");
    }

    static {
        ArrayList<String> correspondenceTypes = new ArrayList<String>();
        correspondenceTypes.add("28");
        correspondenceTypes.add("1");
        correspondenceTypes.add("26");
        correspondenceTypes.add("5");
        correspondenceTypes.add("3");
        correspondenceTypes.add("6");
        correspondenceTypes.add("4");
        correspondenceTypes.add("7");
        correspondenceTypes.add("8");
        GENERIC_TYPE_CORRESPONDENCE = correspondenceTypes;
        CORR_TYPE_TO_ACTION_TYPE_MAP = new HashMap<String, String>();
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("28", "119");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("1", "204");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("26", "300");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("5", "205");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("3", "201");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("6", "203");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("4", "202");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("7", "302");
        CORR_TYPE_TO_ACTION_TYPE_MAP.put("8", "301");
    }
}

