/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardSubawardAuditRule
implements DocumentAuditRule {
    private static final String SUBAWARD_AUDIT_ERRORS = "subawardAuditErrors";
    private static final String SUBAWARD_AUDIT_WARNINGS = "subawardAuditWarnings";
    private static final String ORGANIZATION = "Organization";
    List<AwardApprovedSubaward> awardApprovedSubawards;
    private List<AuditError> auditErrors;
    private List<AuditError> auditWarnings;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)document;
        this.auditErrors = new ArrayList<AuditError>();
        this.auditWarnings = new ArrayList<AuditError>();
        Award award = awardDocument.getAward();
        this.awardApprovedSubawards = award.getAwardApprovedSubawards();
        if (!this.validateApprovedSubawardDuplicateOrganization(this.awardApprovedSubawards)) {
            valid = false;
            this.auditWarnings.add(new AuditError("document.subawardAuditRules", "error.awardApprovedSubaward.duplicate.organization.name", "home.Subaward", new String[]{ORGANIZATION}));
        }
        for (int i = 0; i < this.awardApprovedSubawards.size(); ++i) {
            AwardApprovedSubaward subAward = this.awardApprovedSubawards.get(i);
            ScaleTwoDecimal amount = subAward.getAmount();
            if (amount == null) {
                valid = false;
                continue;
            }
            if (amount.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) continue;
            valid = false;
            this.auditWarnings.add(new AuditError("document.awardList[0].awardApprovedSubawards[" + i + "].amount", "error.awardApprovedSubaward.Amount.equals.zero", "home.Subaward", null));
        }
        this.reportAndCreateAuditCluster();
        return valid;
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(SUBAWARD_AUDIT_ERRORS, new AuditCluster("Subaward", this.auditErrors, "Error"));
        }
        if (this.auditWarnings.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(SUBAWARD_AUDIT_WARNINGS, new AuditCluster("Subaward", this.auditWarnings, "Warnings"));
        }
    }

    protected boolean validateApprovedSubawardDuplicateOrganization(List<AwardApprovedSubaward> awardApprovedSubawards) {
        boolean valid = true;
        int index = 0;
        block0: for (AwardApprovedSubaward loopAwardApprovedSubaward : awardApprovedSubawards) {
            int innerIndex = 0;
            for (AwardApprovedSubaward testAwardApprovedSubaward : awardApprovedSubawards) {
                if (innerIndex == index) continue;
                if (testAwardApprovedSubaward.getOrganizationName().equals(loopAwardApprovedSubaward.getOrganizationName())) {
                    valid = false;
                    break block0;
                }
                ++innerIndex;
            }
            ++index;
        }
        return valid;
    }
}

