/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.personnel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolAction;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentPersonnel;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.irb.personnel.AddProtocolAttachmentPersonnelEvent;
import org.kuali.kra.irb.personnel.AddProtocolPersonnelEvent;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.personnel.AddProtocolUnitEvent;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;

public class ProtocolPersonnelAction
extends ProtocolAction {
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL = "confirmDeleteAttachmentPersonnel";
    private static final String CONFIRM_NO_DELETE = "";
    private ProtocolAttachmentService protocolAttachmentService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        this.getProtocolPersonnelService().selectProtocolUnit(this.getProtocolPersons(form));
        ((ProtocolForm)form).getPersonnelHelper().prepareView();
        ((ProtocolForm)form).refreshDisclosureProjectStatuses();
        return actionForward;
    }

    public ActionForward addProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolPerson newProtocolPerson = (ProtocolPerson)protocolForm.getPersonnelHelper().getNewProtocolPerson();
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        boolean rulePassed = this.applyRules((DocumentEvent)new AddProtocolPersonnelEvent(CONFIRM_NO_DELETE, protocolForm.getProtocolDocument(), newProtocolPerson));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPerson(protocol, newProtocolPerson);
            if (StringUtils.equals((CharSequence)newProtocolPerson.getProtocolPersonRoleId(), (CharSequence)"PI")) {
                protocolForm.getProtocolHelper().setPersonId(newProtocolPerson.getPersonId());
            }
            protocolForm.getPersonnelHelper().setNewProtocolPerson(new ProtocolPerson());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        this.getProtocolPersonnelService().deleteProtocolPerson(protocolDocument.getProtocol());
        return mapping.findForward("basic");
    }

    public ActionForward clearProtocolPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getPersonnelHelper().setNewProtocolPerson(new ProtocolPerson());
        return mapping.findForward("basic");
    }

    public ActionForward addPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex);
        ProtocolAttachmentPersonnel newAttachmentPersonnel = (ProtocolAttachmentPersonnel)protocolForm.getPersonnelHelper().getNewProtocolAttachmentPersonnels().get(selectedPersonIndex);
        newAttachmentPersonnel.setPersonId(protocolPerson.getProtocolPersonId());
        newAttachmentPersonnel.setProtocolNumber(protocolPerson.getProtocolNumber());
        boolean rulePassed = this.applyRules((DocumentEvent)new AddProtocolAttachmentPersonnelEvent(CONFIRM_NO_DELETE, protocolForm.getProtocolDocument(), newAttachmentPersonnel, selectedPersonIndex));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPersonAttachment(protocolDocument.getProtocol(), newAttachmentPersonnel, selectedPersonIndex);
            protocolForm.getPersonnelHelper().getNewProtocolAttachmentPersonnels().set(selectedPersonIndex, new ProtocolAttachmentPersonnel());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentBase attachment = protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        return this.printAttachmentProtocol(mapping, protocolForm, response, attachment);
    }

    private ActionForward printAttachmentProtocol(ActionMapping mapping, ProtocolForm form, HttpServletResponse response, ProtocolAttachmentBase attachment) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), ProtocolPersonnelAction.getValidHeaderString(file.getName()), ProtocolPersonnelAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deletePersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocument protocolDocument = ((ProtocolForm)form).getProtocolDocument();
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentPersonnel attachment = (ProtocolAttachmentPersonnel)protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL, "document.question.deleteAttachment.text", attachment.getAttachmentDescription(), attachment.getFile().getName());
        return this.confirm(confirm, CONFIRM_YES_DELETE_ATTACHMENT_PERSONNEL, CONFIRM_NO_DELETE);
    }

    public ActionForward confirmDeleteAttachmentPersonnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocument protocolDocument = ((ProtocolForm)form).getProtocolDocument();
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(this.getSelectedPersonIndex(request, protocolDocument));
        ProtocolAttachmentPersonnel attachment = (ProtocolAttachmentPersonnel)protocolPerson.getAttachmentPersonnels().get(this.getSelectedLine(request));
        if (attachment.getFileId() != null && !this.getProtocolAttachmentService().isSharedFile(attachment)) {
            ((ProtocolForm)form).getNotesAttachmentsHelper().getFilesToDelete().add(attachment.getFile());
        }
        protocolPerson.getAttachmentPersonnels().remove(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward addProtocolPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        ProtocolPerson protocolPerson = (ProtocolPerson)protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex);
        ProtocolUnit newProtocolPersonUnit = (ProtocolUnit)protocolForm.getPersonnelHelper().getNewProtocolPersonUnits().get(selectedPersonIndex);
        boolean rulePassed = this.applyRules(new AddProtocolUnitEvent(CONFIRM_NO_DELETE, protocolForm.getProtocolDocument(), (ProtocolUnitBase)newProtocolPersonUnit, selectedPersonIndex));
        if (rulePassed) {
            this.getProtocolPersonnelService().addProtocolPersonUnit(protocolForm.getPersonnelHelper().getNewProtocolPersonUnits(), protocolPerson, selectedPersonIndex);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProtocolPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        this.getProtocolPersonnelService().deleteProtocolPersonUnit(protocolDocument.getProtocol(), selectedPersonIndex, this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward updateProtocolPersonView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, protocolDocument);
        this.getProtocolPersonnelService().switchInvestigatorCoInvestigatorRole(protocolDocument.getProtocol().getProtocolPersons());
        this.getProtocolPersonnelService().syncPersonRoleAndUnit(protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex));
        this.getProtocolPersonnelService().syncPersonRoleAndAffiliation(protocolDocument.getProtocol().getProtocolPerson(selectedPersonIndex));
        return mapping.findForward("basic");
    }

    protected int getSelectedPersonIndex(HttpServletRequest request, ProtocolDocument document) {
        int selectedPersonIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            selectedPersonIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"protocolPersons[", (String)"]."));
        }
        return selectedPersonIndex;
    }

    private List<ProtocolPersonBase> getProtocolPersons(ActionForm form) {
        return ((ProtocolForm)form).getProtocolDocument().getProtocol().getProtocolPersons();
    }

    @Override
    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.preSave(mapping, form, request, response);
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        for (ProtocolPersonBase protocolPerson : protocol.getProtocolPersons()) {
            KcAuthorizationService kraAuthService;
            String personComparator;
            String string = personComparator = protocolPerson.getPersonId() != null ? protocolPerson.getPersonId() : protocolPerson.getRolodexId().toString();
            if (protocolPerson.isPrincipalInvestigator() && !personComparator.equals(protocol.getPrincipalInvestigatorId())) {
                protocol.setPrincipalInvestigatorId(null);
                if (protocolPerson.getPersonId() != null && this.getProtocolPersonnelService().shouldPrincipalInvestigatorBeAddedToWorkflow()) {
                    kraAuthService = KcServiceLocator.getService(KcAuthorizationService.class);
                    kraAuthService.addDocumentLevelRole(protocolPerson.getPersonId(), "ProtocolApprover", protocol);
                    protocolForm.resetUserPermissionStates();
                }
            } else if (!protocolPerson.isPrincipalInvestigator() && !StringUtils.equals((CharSequence)protocolPerson.getPersonId(), (CharSequence)protocol.getPrincipalInvestigatorId()) && protocolPerson.getPersonId() != null) {
                kraAuthService = KcServiceLocator.getService(KcAuthorizationService.class);
                kraAuthService.addDocumentLevelRole(protocolPerson.getPersonId(), "Protocol Viewer", protocol);
                protocolForm.resetUserPermissionStates();
            }
            if (!protocolPerson.isAffiliationTypeCodeChanged()) continue;
            protocolForm.resetUserPermissionStates();
        }
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put("protocolNumber", protocol.getProtocolNumber());
        keyMap.put("sequenceNumber", protocol.getSequenceNumber());
        List attachments = (List)this.getBusinessObjectService().findMatching(ProtocolAttachmentPersonnel.class, keyMap);
        ArrayList<AttachmentFile> filesToDelete = new ArrayList<AttachmentFile>();
        ArrayList<Long> attachmentIds = new ArrayList<Long>();
        for (ProtocolAttachmentPersonnelBase attachment : protocol.getAttachmentPersonnels()) {
            if (attachment.getId() == null) continue;
            attachmentIds.add(attachment.getId());
        }
        for (ProtocolAttachmentPersonnelBase attachment : attachments) {
            if (attachmentIds.contains(attachment.getId()) || this.getProtocolAttachmentService().isSharedFile(attachment)) continue;
            filesToDelete.add(attachment.getFile());
        }
        protocolForm.getNotesAttachmentsHelper().setFilesToDelete(filesToDelete);
    }

    private ProtocolAttachmentService getProtocolAttachmentService() {
        if (this.protocolAttachmentService == null) {
            this.protocolAttachmentService = KcServiceLocator.getService(ProtocolAttachmentService.class);
        }
        return this.protocolAttachmentService;
    }

    @Override
    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        if (!((ProtocolForm)form).getNotesAttachmentsHelper().getFilesToDelete().isEmpty()) {
            this.getBusinessObjectService().delete(((ProtocolForm)form).getNotesAttachmentsHelper().getFilesToDelete());
            ((ProtocolForm)form).getNotesAttachmentsHelper().getFilesToDelete().clear();
        }
    }
}

