/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.document.authorization.CommitteeTaskBase;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public abstract class CommitteeDocumentAuthorizerBase
extends KcTransactionalDocumentAuthorizerBase {
    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        String userId = user.getPrincipalId();
        CommitteeDocumentBase committeeDocument = (CommitteeDocumentBase)document;
        if (((CommitteeBase)committeeDocument.getCommittee()).getCommitteeId() == null) {
            if (this.canCreateCommittee(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else if (this.canExecuteCommitteeTask(userId, committeeDocument, "modifyCommittee")) {
            editModes.add("fullEntry");
        } else if (this.canExecuteCommitteeTask(userId, committeeDocument, "viewCommittee")) {
            editModes.add("viewOnly");
        } else {
            editModes.add("unviewable");
        }
        if (this.canModify(committeeDocument, user)) {
            editModes.add("canModify");
        }
        return editModes;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateCommittee(user);
    }

    public boolean canOpen(Document document, Person user) {
        CommitteeDocumentBase committeeDocument = (CommitteeDocumentBase)document;
        if (((CommitteeBase)committeeDocument.getCommittee()).getCommitteeId() == null) {
            return this.canCreateCommittee(user);
        }
        return this.canExecuteCommitteeTask(user.getPrincipalId(), (CommitteeDocumentBase)document, "viewCommittee");
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return !this.isFinal(document) && this.canExecuteCommitteeTask(user.getPrincipalId(), (CommitteeDocumentBase)document, "modifyCommittee");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return !this.isFinal(document) && super.canRoute(document, user) && !((CommitteeDocumentBase)document).isViewOnly();
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return !this.isFinal(document) && super.canBlanketApprove(document, user) && !((CommitteeDocumentBase)document).isViewOnly();
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return !this.isFinal(document) && super.canCancel(document, user) && !((CommitteeDocumentBase)document).isViewOnly();
    }

    @Override
    public boolean canAcknowledge(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canReload(Document document, Person user) {
        return this.isFinal(document);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    private boolean canCreateCommittee(Person user) {
        ApplicationTask task = new ApplicationTask(this.getAddCommitteeTaskNameHook());
        return this.getTaskAuthorizationService().isAuthorized(user.getPrincipalId(), task);
    }

    protected abstract String getAddCommitteeTaskNameHook();

    private boolean canExecuteCommitteeTask(String userId, CommitteeDocumentBase doc, String taskName) {
        CommitteeTaskBase task = this.getNewCommitteeTaskInstanceHook(taskName, (CommitteeBase)doc.getCommittee());
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    protected abstract CommitteeTaskBase getNewCommitteeTaskInstanceHook(String var1, CommitteeBase var2);

    protected abstract String getPermissionNameForModifyCommitteeHook();

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    public boolean canModify(CommitteeDocumentBase document, Person user) {
        return this.getAuthorizationService().hasPermission(user.getPrincipalId(), (Permissionable)document.getCommittee(), this.getPermissionNameForModifyCommitteeHook());
    }

    protected KcWorkflowService getWorkFlowService() {
        return KcServiceLocator.getService(KcWorkflowService.class);
    }

    protected KcAuthorizationService getAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }
}

