/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.propdev.impl.attachment.ProposalDevelopmentProposalAttachmentsAuditRule;
import org.kuali.coeus.propdev.impl.auth.perm.ProposalDevelopmentPermissionsService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentUtils;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonModuleQuestionnaireBean;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class KeyPersonnelCertificationRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    public static final String KEY_PERSONNEL_AUDIT_CLUSTER_KEY = "keyPersonnelAuditErrors";
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentProposalAttachmentsAuditRule.class);
    private QuestionnaireAnswerService questionnaireAnswerService;
    private ProposalDevelopmentPermissionsService permissionsService;
    private ParameterService parameterService;

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        if (this.questionnaireAnswerService == null) {
            this.questionnaireAnswerService = KcServiceLocator.getService(QuestionnaireAnswerService.class);
        }
        return this.questionnaireAnswerService;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        ProposalDevelopmentDocument pdDoc = (ProposalDevelopmentDocument)document;
        valid &= this.doesNonEmployeeHaveCertification(pdDoc.getDevelopmentProposal().getProposalPersons());
        if (this.getKeyPersonCertDeferralParam().equalsIgnoreCase("BS")) {
            valid &= this.validateAllCertificationsComplete(pdDoc);
        } else if (this.getKeyPersonCertDeferralParam().equalsIgnoreCase("BA")) {
            valid &= this.isRouterPiAndCertified(pdDoc);
        } else {
            LOG.warn("System parameter 'KEY_PERSON_CERTIFICATION_DEFERRAL' should be one of 'BA' or 'BS'.");
            return false;
        }
        return valid;
    }

    public boolean doesNonEmployeeHaveCertification(List<ProposalPerson> proposalPersons) {
        Boolean validationEnabled = this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "ENABLE_KEY_PERSON_VALIDATION_FOR_NON_EMPLOYEE_PERSONNEL");
        int index = 0;
        boolean valid = true;
        if (validationEnabled.booleanValue()) {
            for (ProposalPerson person : proposalPersons) {
                if (!this.doesNonEmployeeHaveCertification(person)) continue;
                this.generateAuditError(index, person.getFullName(), "error.nonemployee.certification.required");
                valid = false;
            }
            ++index;
        }
        return valid;
    }

    public boolean doesNonEmployeeHaveCertification(ProposalPerson person) {
        return person.isNonEmployee() && person.needsCertification() && !this.validKeyPersonCertification(person);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public ProposalDevelopmentPermissionsService getPermissionsService() {
        if (this.permissionsService == null) {
            this.permissionsService = KcServiceLocator.getService(ProposalDevelopmentPermissionsService.class);
        }
        return this.permissionsService;
    }

    protected boolean isRouterPiAndCertified(ProposalDevelopmentDocument pdDoc) {
        String loggedInUser = this.getLoggedInUser();
        for (ProposalPerson person : pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!this.isPersonLoggedInKeyPersonnel(loggedInUser, person) || !person.needsCertification() || this.validKeyPersonCertification(person)) continue;
            this.generateAuditError(0, person.getFullName(), "error.proposalperson.certfication.incomplete");
            return false;
        }
        return true;
    }

    protected String getLoggedInUser() {
        return this.getGlobalVariableService().getUserSession().getPrincipalId();
    }

    private boolean isPersonLoggedInKeyPersonnel(String loggedInUser, ProposalPerson person) {
        return StringUtils.equalsIgnoreCase((CharSequence)person.getPersonId(), (CharSequence)loggedInUser) && (person.isCoInvestigator() || person.isPrincipalInvestigator() || person.isKeyPerson() || person.isMultiplePi());
    }

    public boolean processRouteDocument(Document document) {
        return this.processRunAuditBusinessRules(document);
    }

    public boolean processApproveDocument(ApproveDocumentEvent approveEvent) {
        boolean isValid = true;
        if (this.getKeyPersonCertDeferralParam().equals("BA")) {
            isValid &= this.validateKeyPersonCertification((ProposalDevelopmentDocument)approveEvent.getDocument(), this.getGlobalVariableService().getUserSession().getPerson());
        }
        return isValid;
    }

    protected boolean validateAllCertificationsComplete(ProposalDevelopmentDocument document) {
        boolean retval = true;
        int count = 0;
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            if (person.needsCertification() && !this.validKeyPersonCertification(person)) {
                this.generateAuditError(count, person.getFullName(), "error.proposalperson.certfication.incomplete");
                retval = false;
            }
            ++count;
        }
        return retval;
    }

    protected boolean validateKeyPersonCertification(ProposalDevelopmentDocument document, Person user) {
        boolean retval = true;
        int count = 0;
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            if (StringUtils.equals((CharSequence)user.getPrincipalId(), (CharSequence)person.getPersonId()) && person.needsCertification() && !this.validKeyPersonCertification(person)) {
                this.generateAuditError(count, person.getFullName(), "error.proposalperson.certfication.incomplete");
                return false;
            }
            ++count;
        }
        return retval;
    }

    protected boolean validKeyPersonCertification(ProposalPerson person) {
        return this.validateYesNoQuestions(person);
    }

    protected boolean validateYesNoQuestions(ProposalPerson investigator) {
        boolean retval = true;
        ProposalPersonModuleQuestionnaireBean bean = new ProposalPersonModuleQuestionnaireBean(investigator.getDevelopmentProposal(), investigator);
        List<AnswerHeader> headers = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(bean);
        for (AnswerHeader head : headers) {
            retval &= head.isCompleted();
        }
        return retval;
    }

    protected void generateAuditError(int count, String personFullName, String errorMessage) {
        String errorStarter = "document.developmentProposal.proposalPersons[";
        String errorFinish = "].questionnaireHelper.answerHeaders[0].questions";
        String errorKey = "document.developmentProposal.proposalPersons[" + count + "].questionnaireHelper.answerHeaders[0].questions";
        AuditError error = new AuditError(errorKey, errorMessage, "PropDev-PersonnelPage", new String[]{personFullName});
        this.getAuditErrors().add(error);
    }

    protected List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey(KEY_PERSONNEL_AUDIT_CLUSTER_KEY)) {
            GlobalVariables.getAuditErrorMap().put(KEY_PERSONNEL_AUDIT_CLUSTER_KEY, new AuditCluster("Key Personnel", auditErrors, "Error"));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(KEY_PERSONNEL_AUDIT_CLUSTER_KEY)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected String getKeyPersonCertDeferralParam() {
        return ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter(ProposalDevelopmentUtils.KEY_PERSON_CERTIFICATION_DEFERRAL_PARM);
    }

    public GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }
}

