/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.session.ser;

import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.coeus.sys.impl.session.SessionHoldingListener;
import org.kuali.coeus.sys.impl.session.ser.SerializableSessionAttributeService;
import org.kuali.coeus.sys.impl.session.ser.SerializableUserSessionAttribute;
import org.kuali.coeus.sys.impl.session.ser.SerializableUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.stereotype.Component;

@Component(value="serializableKradFormService")
public class SerializableKradFormServiceImpl
implements SerializableSessionAttributeService {
    private static final String SESSION_FORMS = "sessionForms";

    public List<SerializableUserSessionAttribute> getAttributes() {
        return SessionHoldingListener.getSessions().stream().map(session -> Streams.stream((Iterator)Iterators.forEnumeration((Enumeration)session.getAttributeNames())).map(attrName -> CollectionUtils.entry(attrName, session.getValue(attrName))).filter(attr -> attr.getValue() instanceof UifFormManager).flatMap(attr -> this.getSessionForms((UifFormManager)attr.getValue()).entrySet().stream()).map(attr -> {
            SerializableUtils.SerInfo info = SerializableUtils.getSerializationInfo(attr.getValue());
            return new SerializableUserSessionAttribute(session.getId(), (String)attr.getKey(), ((UifFormBase)attr.getValue()).getClass().getName(), ((UifFormBase)attr.getValue()).toString(), info.isSerializable(), info.getSize(), info.getFailurePath());
        }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Map<String, UifFormBase> getSessionForms(UifFormManager manager) {
        try {
            Field sessionForms = UifFormManager.class.getDeclaredField(SESSION_FORMS);
            sessionForms.setAccessible(true);
            return (Map)sessionForms.get(manager);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

