/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.print;

import edu.mit.coeus.xml.iacuc.CorrespondentType;
import edu.mit.coeus.xml.iacuc.FundingSourceType;
import edu.mit.coeus.xml.iacuc.InvestigatorType;
import edu.mit.coeus.xml.iacuc.KeyStudyPersonType;
import edu.mit.coeus.xml.iacuc.PersonType;
import edu.mit.coeus.xml.iacuc.ProtocolDocument;
import edu.mit.coeus.xml.iacuc.ProtocolMasterDataType;
import edu.mit.coeus.xml.iacuc.ProtocolReviewerType;
import edu.mit.coeus.xml.iacuc.ProtocolType;
import edu.mit.coeus.xml.iacuc.ResearchAreaType;
import edu.mit.coeus.xml.iacuc.SpecialReviewType;
import edu.mit.coeus.xml.iacuc.SubmissionDetailsType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.print.IacucCommitteeXmlStream;
import org.kuali.kra.iacuc.committee.print.IacucScheduleXmlStream;
import org.kuali.kra.iacuc.committee.print.service.IacucPrintXmlUtilService;
import org.kuali.kra.iacuc.personnel.IacucProtocolPersonRolodex;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.print.ProtocolXmlStreamBase;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewBase;

public class IacucProtocolXmlStream
extends ProtocolXmlStreamBase<ProtocolDocument> {
    private IacucPrintXmlUtilService printXmlUtilService;
    private KcPersonService kcPersonService;
    private IacucScheduleXmlStream scheduleXmlStream;
    private IacucCommitteeXmlStream committeeXmlStream;
    protected static final String FLAG_YES = "Yes";
    protected static final String FLAG_NO = "No";

    @Override
    public Class<ProtocolDocument> type() {
        return ProtocolDocument.class;
    }

    @Override
    public Map<String, ProtocolDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        IacucProtocol protocol = (IacucProtocol)printableBusinessObject;
        ProtocolDocument protocolDocumentType = ProtocolDocument.Factory.newInstance();
        protocolDocumentType.setProtocol(this.getProtocol(protocol));
        HashMap<String, ProtocolDocument> xmlObjectMap = new HashMap<String, ProtocolDocument>();
        xmlObjectMap.put("Protocol", protocolDocumentType);
        return xmlObjectMap;
    }

    public ProtocolType getProtocol(IacucProtocol protocolInfoBean, Integer submissionNumber) {
        ProtocolType protocolType = ProtocolType.Factory.newInstance();
        this.setProtocolMasterData(protocolInfoBean, protocolType);
        this.addProtocolPersons(protocolInfoBean, protocolType);
        this.addResearchArea(protocolInfoBean, protocolType);
        this.addFundingSource(protocolInfoBean, protocolType);
        this.addSpecialReview(protocolInfoBean, protocolType);
        this.addSubmissionDetails(protocolInfoBean, protocolType, submissionNumber, FLAG_YES);
        Integer parentSubmissionNumber = this.getParentSubmissionNumber(protocolInfoBean, submissionNumber);
        this.addSubmissionDetails(protocolInfoBean, protocolType, parentSubmissionNumber, FLAG_NO);
        this.addRiskLevels(protocolInfoBean, protocolType);
        return protocolType;
    }

    private Integer getParentSubmissionNumber(ProtocolBase protocolInfoBean, Integer submissionNumber) {
        return 0;
    }

    public ProtocolType getProtocol(IacucProtocol protocol) {
        ProtocolType protocolType = ProtocolType.Factory.newInstance();
        this.setProtocolMasterData(protocol, protocolType);
        this.addProtocolPersons(protocol, protocolType);
        this.addResearchArea(protocol, protocolType);
        this.addFundingSource(protocol, protocolType);
        this.addSpecialReview(protocol, protocolType);
        this.addSubmissionDetails(protocol, protocolType);
        this.addRiskLevels(protocol, protocolType);
        return protocolType;
    }

    private void addRiskLevels(IacucProtocol protocol, ProtocolType protocolType) {
    }

    private void addSubmissionDetails(IacucProtocol protocol, ProtocolType protocolType) {
        this.addSubmissionDetails(protocol, protocolType, null, FLAG_NO);
    }

    private void addSubmissionDetails(IacucProtocol protocol, ProtocolType protocolType, Integer submissionNumber, String currentFlag) {
        IacucProtocolSubmission submissionInfoBean = (IacucProtocolSubmission)(submissionNumber == null ? protocol.getProtocolSubmission() : this.findProtocolSubmission(protocol, submissionNumber));
        if (submissionInfoBean == null || submissionInfoBean.getSubmissionNumber() == null) {
            return;
        }
        submissionInfoBean.refreshNonUpdateableReferences();
        ProtocolType.Submissions submission = protocolType.addNewSubmissions();
        SubmissionDetailsType submissionDetail = submission.addNewSubmissionDetails();
        submissionDetail.setAbstainerCount(BigInteger.valueOf(submissionInfoBean.getAbstainerCount().intValue()));
        if (submissionInfoBean.getNoVoteCount() != null) {
            submissionDetail.setNoVote(BigInteger.valueOf(submissionInfoBean.getNoVoteCount().intValue()));
        }
        submissionDetail.setProtocolNumber(submissionInfoBean.getProtocolNumber());
        if (submissionInfoBean.getProtocolReviewType() != null) {
            submissionDetail.setProtocolReviewTypeCode(new BigInteger(submissionInfoBean.getProtocolReviewTypeCode()));
            submissionDetail.setProtocolReviewTypeDesc(submissionInfoBean.getProtocolReviewType().getDescription());
        }
        List<ProtocolReviewer> vecReviewers = submissionInfoBean.getProtocolReviewers();
        for (ProtocolReviewer protocolReviewer : vecReviewers) {
            protocolReviewer.refreshNonUpdateableReferences();
            ProtocolReviewerType protocolReviewerType = submissionDetail.addNewProtocolReviewer();
            if (protocolReviewer.getProtocolReviewerType() != null) {
                protocolReviewerType.setReviewerTypeDesc(protocolReviewer.getProtocolReviewerType().getDescription());
                protocolReviewerType.setReviewerTypeCode(new BigInteger(String.valueOf(protocolReviewer.getReviewerTypeCode())));
            }
            PersonType personType = protocolReviewerType.addNewPerson();
            boolean isNonEmployee = protocolReviewer.getNonEmployeeFlag();
            if (isNonEmployee) {
                ProtocolPersonRolodexBase rolodex = (ProtocolPersonRolodexBase)this.getBusinessObjectService().findBySinglePrimaryKey(IacucProtocolPersonRolodex.class, (Object)protocolReviewer.getRolodexId());
                this.getPrintXmlUtilService().setPersonXml(rolodex, personType);
                continue;
            }
            KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(protocolReviewer.getPersonId());
            this.getPrintXmlUtilService().setPersonXml(kcPerson, personType);
        }
        submissionDetail.setSubmissionComments(submissionInfoBean.getComments());
        if (submissionInfoBean.getSubmissionDate() != null) {
            submissionDetail.setSubmissionDate(this.getDateTimeService().getCalendar((Date)submissionInfoBean.getSubmissionDate()));
        } else {
            submissionDetail.setSubmissionDate(this.getDateTimeService().getCurrentCalendar());
        }
        submissionDetail.setSubmissionNumber(BigInteger.valueOf(submissionInfoBean.getSubmissionNumber().intValue()));
        if (submissionInfoBean.getSubmissionStatus() != null) {
            submissionDetail.setSubmissionStatusCode(new BigInteger(submissionInfoBean.getSubmissionStatusCode()));
            submissionDetail.setSubmissionStatusDesc(submissionInfoBean.getSubmissionStatus().getDescription());
        }
        if (submissionInfoBean.getProtocolSubmissionType() != null) {
            submissionDetail.setSubmissionTypeCode(new BigInteger(submissionInfoBean.getSubmissionTypeCode()));
            submissionDetail.setSubmissionTypeDesc(submissionInfoBean.getProtocolSubmissionType().getDescription());
        }
        if (submissionInfoBean.getProtocolSubmissionQualifierType() != null) {
            BigInteger typeQual = submissionInfoBean.getSubmissionTypeQualifierCode() == null ? new BigInteger("0") : new BigInteger(submissionInfoBean.getSubmissionTypeQualifierCode());
            submissionDetail.setSubmissionTypeQualifierCode(typeQual);
            submissionDetail.setSubmissionTypeQualifierDesc(submissionInfoBean.getProtocolSubmissionQualifierType().getDescription());
        }
        submissionDetail.setVotingComments(submissionInfoBean.getVotingComments());
        if (submissionInfoBean.getYesVoteCount() != null) {
            submissionDetail.setYesVote(BigInteger.valueOf(submissionInfoBean.getYesVoteCount().intValue()));
        }
        this.getPrintXmlUtilService().setProtocolSubmissionAction(submissionInfoBean, submissionDetail);
        this.getPrintXmlUtilService().setSubmissionCheckListinfo(submissionInfoBean, submissionDetail);
        submission.setCurrentSubmissionFlag(currentFlag);
        this.setMinutes(submissionInfoBean, submission);
    }

    protected void setMinutes(ProtocolSubmissionBase submissionInfoBean, ProtocolType.Submissions submission) {
        CommitteeScheduleBase committeeSchedule = submissionInfoBean.getCommitteeSchedule();
        if (committeeSchedule != null) {
            this.getPrintXmlUtilService().setProtocolReviewMinutes(committeeSchedule, submissionInfoBean, submission);
        }
    }

    private ProtocolSubmissionBase findProtocolSubmission(ProtocolBase protocol, Integer submissionNumber) {
        List<ProtocolSubmissionBase> protocolSubmissions = protocol.getProtocolSubmissions();
        for (ProtocolSubmissionBase protocolSubmission : protocolSubmissions) {
            if (!protocolSubmission.getSubmissionNumber().equals(submissionNumber)) continue;
            return protocolSubmission;
        }
        return null;
    }

    private void addSpecialReview(IacucProtocol protocol, ProtocolType protocolType) {
        List<ProtocolSpecialReviewBase> vecSpecialReview = protocol.getSpecialReviews();
        for (ProtocolSpecialReviewBase specialReviewBean : vecSpecialReview) {
            specialReviewBean.refreshNonUpdateableReferences();
            SpecialReviewType specialReview = protocolType.addNewSpecialReview();
            if (specialReviewBean.getApplicationDate() != null) {
                specialReview.setSpecialReviewApplicationDate(this.getDateTimeService().getCalendar((Date)specialReviewBean.getApplicationDate()));
            } else {
                specialReview.setSpecialReviewApplicationDate(this.getDateTimeService().getCurrentCalendar());
            }
            if (specialReviewBean.getApprovalDate() != null) {
                specialReview.setSpecialReviewApprovalDate(this.getDateTimeService().getCalendar((Date)specialReviewBean.getApprovalDate()));
            } else {
                specialReview.setSpecialReviewApprovalDate(this.getDateTimeService().getCurrentCalendar());
            }
            if (specialReviewBean.getApprovalType() != null) {
                specialReview.setSpecialReviewApprovalTypeCode(new BigInteger(specialReviewBean.getApprovalTypeCode()));
                specialReview.setSpecialReviewApprovalTypeDesc(specialReviewBean.getApprovalType().getDescription());
            }
            specialReview.setSpecialReviewComments(specialReviewBean.getComments());
            if (specialReviewBean.getSpecialReviewNumber() != null) {
                specialReview.setSpecialReviewNumber(BigInteger.valueOf(specialReviewBean.getSpecialReviewNumber().intValue()));
            }
            specialReview.setSpecialReviewProtocolNumber(specialReviewBean.getProtocolNumber());
            if (specialReviewBean.getSpecialReviewType() == null) continue;
            specialReview.setSpecialReviewTypeCode(new BigInteger(specialReviewBean.getSpecialReviewTypeCode()));
            specialReview.setSpecialReviewTypeDesc(specialReviewBean.getSpecialReviewType().getDescription());
        }
    }

    private void addFundingSource(IacucProtocol protocol, ProtocolType protocolType) {
        List<ProtocolFundingSourceBase> vecFundingSource = protocol.getProtocolFundingSources();
        for (ProtocolFundingSourceBase protocolFundingSourceBean : vecFundingSource) {
            FundingSourceType fundingSource = protocolType.addNewFundingSource();
            String fundingSourceCode = protocolFundingSourceBean.getFundingSourceNumber();
            int fundingSourceTypeCode = Integer.valueOf(protocolFundingSourceBean.getFundingSourceTypeCode());
            String fundingSourceName = this.getFundingSourceNameForType(fundingSourceTypeCode, fundingSourceCode);
            fundingSource.setFundingSourceName(fundingSourceName);
            if (protocolFundingSourceBean.getFundingSourceType() == null) continue;
            fundingSource.setTypeOfFundingSource(protocolFundingSourceBean.getFundingSourceType().getDescription());
        }
    }

    private String getFundingSourceNameForType(int sourceType, String sourceCode) {
        String name = null;
        if (sourceType == 1) {
            Sponsor sponsorBean = (Sponsor)this.getBusinessObjectService().findBySinglePrimaryKey(Sponsor.class, (Object)sourceCode);
            if (sponsorBean != null) {
                name = sponsorBean.getSponsorName();
            }
        } else if (sourceType == 2) {
            Unit unitBean = (Unit)this.getBusinessObjectService().findBySinglePrimaryKey(Unit.class, (Object)sourceCode);
            if (unitBean != null) {
                name = unitBean.getUnitName();
            }
        } else {
            name = sourceCode;
        }
        return name;
    }

    private void addResearchArea(IacucProtocol protocol, ProtocolType protocolType) {
        List<ProtocolResearchAreaBase> researchAreas = protocol.getProtocolResearchAreas();
        for (ProtocolResearchAreaBase protocolReasearchAreasBean : researchAreas) {
            protocolReasearchAreasBean.refreshNonUpdateableReferences();
            ResearchAreaType researchArea = protocolType.addNewResearchArea();
            researchArea.setResearchAreaCode(protocolReasearchAreasBean.getResearchAreaCode());
            if (protocolReasearchAreasBean.getResearchAreas() == null) continue;
            researchArea.setResearchAreaDescription(protocolReasearchAreasBean.getResearchAreas().getDescription());
        }
    }

    private void addProtocolPersons(IacucProtocol protocol, ProtocolType protocolType) {
        List<ProtocolPersonBase> vecInvestigator = protocol.getProtocolPersons();
        for (ProtocolPersonBase protocolPerson : vecInvestigator) {
            protocolPerson.refreshNonUpdateableReferences();
            if (protocolPerson.getProtocolPersonRoleId().equals("PI") || protocolPerson.getProtocolPersonRoleId().equals("COI")) {
                InvestigatorType investigator = protocolType.addNewInvestigator();
                if (protocolPerson.getProtocolPersonRoleId().equals("PI")) {
                    investigator.setPIFlag(true);
                    if (protocolPerson.isTrained()) {
                        investigator.setTrainingFlag(FLAG_YES);
                    } else {
                        investigator.setTrainingFlag(FLAG_NO);
                    }
                    if (protocolPerson.getAffiliationType() != null) {
                        investigator.setAffiliationDesc(protocolPerson.getAffiliationType().getDescription());
                    }
                    ArrayList<InvestigatorType.Unit> unitList = new ArrayList<InvestigatorType.Unit>();
                    for (ProtocolUnitBase protocolUnit : protocolPerson.getProtocolUnits()) {
                        InvestigatorType.Unit unit = InvestigatorType.Unit.Factory.newInstance();
                        unit.setUnitName(protocolUnit.getUnitName());
                        unit.setUnitNumber(protocolUnit.getUnitNumber());
                        unitList.add(unit);
                    }
                    investigator.setUnitArray(unitList.toArray(new InvestigatorType.Unit[0]));
                }
                this.getPrintXmlUtilService().setPersonRolodexType(protocolPerson, investigator.addNewPerson());
                continue;
            }
            if (protocolPerson.getProtocolPersonRoleId().equals("SP")) {
                KeyStudyPersonType keyStudyPerson = protocolType.addNewKeyStudyPerson();
                if (protocolPerson.getAffiliationType() != null) {
                    keyStudyPerson.setAffiliation(protocolPerson.getAffiliationType().getDescription());
                }
                if (protocolPerson.getRolodex() != null) {
                    keyStudyPerson.setRole(protocolPerson.getRolodex().getTitle());
                } else if (protocolPerson.getPerson() != null) {
                    keyStudyPerson.setRole(protocolPerson.getPerson().getDirectoryTitle());
                }
                this.getPrintXmlUtilService().setPersonRolodexType(protocolPerson, keyStudyPerson.addNewPerson());
                continue;
            }
            if (!protocolPerson.getProtocolPersonRoleId().equals("CRC") && !protocolPerson.getProtocolPersonRoleId().equals("CA")) continue;
            CorrespondentType correspondent = protocolType.addNewCorrespondent();
            correspondent.setTypeOfCorrespondent(protocolPerson.getProtocolPersonRole().getDescription());
            correspondent.setCorrespondentTypeDesc(protocolPerson.getProtocolPersonRole().getDescription());
            this.getPrintXmlUtilService().setPersonRolodexType(protocolPerson, correspondent.addNewPerson());
        }
    }

    private void setProtocolMasterData(IacucProtocol protocol, ProtocolType protocolType) {
        ProtocolMasterDataType protocolMaster = protocolType.addNewProtocolMasterData();
        if (protocol == null) {
            return;
        }
        protocolMaster.setProtocolNumber(protocol.getProtocolNumber());
        protocolMaster.setSequenceNumber(BigInteger.valueOf(protocol.getSequenceNumber().intValue()));
        protocolMaster.setProtocolTitle(protocol.getTitle());
        if (protocol.getSubmissionDate() != null) {
            protocolMaster.setApplicationDate(this.getDateTimeService().getCalendar((Date)protocol.getSubmissionDate()));
        }
        if (protocol.getProtocolStatus() != null) {
            protocolMaster.setProtocolStatusCode(new BigInteger(protocol.getProtocolStatusCode()));
            protocolMaster.setProtocolStatusDesc(protocol.getProtocolStatus().getDescription());
        }
        if (protocol.getProtocolType() != null) {
            protocolMaster.setProtocolTypeCode(new BigInteger(protocol.getProtocolTypeCode()));
            protocolMaster.setProtocolTypeDesc(protocol.getProtocolType().getDescription());
        }
        if (protocol.getDescription() != null) {
            protocolMaster.setProtocolDescription(protocol.getDescription());
        }
        if (protocol.getApprovalDate() != null) {
            protocolMaster.setApprovalDate(this.getDateTimeService().getCalendar((Date)protocol.getApprovalDate()));
        }
        if (protocol.getLastApprovalDate() != null) {
            protocolMaster.setLastApprovalDate(this.getDateTimeService().getCalendar((Date)protocol.getLastApprovalDate()));
        }
        if (protocol.getExpirationDate() != null) {
            protocolMaster.setExpirationDate(this.getDateTimeService().getCalendar((Date)protocol.getExpirationDate()));
        }
        if (protocol.getProtocolSubmission() != null) {
            protocolMaster.setBillableFlag(protocol.getProtocolSubmission().isBillable());
        }
        if (protocol.getFdaApplicationNumber() != null) {
            protocolMaster.setFdaApplicationNumber(protocol.getFdaApplicationNumber());
        }
        if (protocol.getReferenceNumber1() != null) {
            protocolMaster.setRefNumber1(protocol.getReferenceNumber1());
        }
        if (protocol.getReferenceNumber2() != null) {
            protocolMaster.setRefNumber2(protocol.getReferenceNumber2());
        }
        if (protocol.getInvestigator() != null) {
            protocolMaster.setPrincipleInvestigatorName(protocol.getInvestigator());
        }
    }

    public void setPrintXmlUtilService(IacucPrintXmlUtilService printXmlUtilService) {
        this.printXmlUtilService = printXmlUtilService;
    }

    public IacucPrintXmlUtilService getPrintXmlUtilService() {
        return this.printXmlUtilService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public void setScheduleXmlStream(IacucScheduleXmlStream scheduleXmlStream) {
        this.scheduleXmlStream = scheduleXmlStream;
    }

    public IacucScheduleXmlStream getScheduleXmlStream() {
        return this.scheduleXmlStream;
    }

    public void setCommitteeXmlStream(IacucCommitteeXmlStream comitteeXmlStream) {
        this.committeeXmlStream = comitteeXmlStream;
    }

    public IacucCommitteeXmlStream getCommitteeXmlStream() {
        return this.committeeXmlStream;
    }
}

