/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.onlinereview.authorization;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewAuthorizer;
import org.kuali.kra.iacuc.onlinereview.authorization.IacucProtocolOnlineReviewTask;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class ModifyIacucProtocolOnlineReviewAuthorizer
extends IacucProtocolOnlineReviewAuthorizer {
    private static final Logger LOG = LogManager.getLogger(ModifyIacucProtocolOnlineReviewAuthorizer.class);
    private KcWorkflowService kraWorkflowService;

    @Override
    public boolean isAuthorized(String userId, IacucProtocolOnlineReviewTask task) {
        boolean hasPermission = true;
        ProtocolOnlineReviewBase protocolOnlineReview = task.getProtocolOnlineReview();
        ProtocolOnlineReviewDocumentBase protocolDoc = null;
        try {
            protocolDoc = (ProtocolOnlineReviewDocumentBase)KcServiceLocator.getService(DocumentService.class).getByDocumentHeaderId(protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber());
        }
        catch (WorkflowException e) {
            LOG.error(String.format("Could not find ProtocolOnlineReviewBase, document number %s", protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber()));
            return false;
        }
        if (protocolOnlineReview.getProtocolOnlineReviewId() == null) {
            return false;
        }
        hasPermission = !protocolOnlineReview.getProtocolOnlineReviewDocument().isViewOnly() && (this.hasPermission(userId, protocolOnlineReview, "Maintain IACUC Protocol Online Reviews") && this.kraWorkflowService.isEnRoute((Document)protocolDoc) || this.hasPermission(userId, protocolOnlineReview, "Maintain IACUC Protocol Online Review Comments") && this.kraWorkflowService.isUserApprovalRequested((Document)protocolDoc, userId));
        return hasPermission;
    }

    public KcWorkflowService getKraWorkflowService() {
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KcWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }
}

