--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2016 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

-- the following query produces duplicate question records in our bootstrap data. This reassigns the next available sequence number
-- to these records
-- SELECT QUESTION_ID, SEQUENCE_NUMBER, COUNT(*) FROM QUESTION GROUP BY QUESTION_ID, SEQUENCE_NUMBER HAVING COUNT(*) > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 52) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 52 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 52 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 53) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 53 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 53 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 54) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 54 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 54 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 55) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 55 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 55 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 56) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 56 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 56 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 57) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 57 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 57 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 58) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 58 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 58 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 59) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 59 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 59 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 60) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 60 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 60 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 61) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 61 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 61 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 62) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 62 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 62 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 63) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 63 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 63 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 65) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 65 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 65 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 99) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 99 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 99 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;

UPDATE question T1,
  (SELECT max(SEQUENCE_NUMBER) as MAX_SEQUENCE_NUMBER
   FROM question
   WHERE QUESTION_ID = 100) T2,
  (SELECT max(QUESTION_REF_ID) as MAX_QUESTION_REF_ID
   FROM question
   WHERE QUESTION_ID = 100 and SEQUENCE_NUMBER = 1) T3,
  (select COUNT(*) as DUP_COUNT
   FROM QUESTION
   WHERE QUESTION_ID = 100 and SEQUENCE_NUMBER = 1) T4
SET T1.SEQUENCE_NUMBER=T2.max_sequence_number + 1
WHERE T1.QUESTION_REF_ID = T3.MAX_QUESTION_REF_ID and T4.DUP_COUNT > 1;