/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.submit;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolStatus;
import org.kuali.kra.irb.actions.ProtocolSubmissionBuilder;
import org.kuali.kra.irb.actions.assignreviewers.ProtocolAssignReviewersService;
import org.kuali.kra.irb.actions.submit.ExemptStudiesCheckListItem;
import org.kuali.kra.irb.actions.submit.ExpeditedReviewCheckListItem;
import org.kuali.kra.irb.actions.submit.ProtocolActionService;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionService;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProtocolSubmitActionServiceImpl
implements ProtocolSubmitActionService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMIT_TO_IRB = "Submitted to IRB";
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private BusinessObjectService businessObjectService;
    private ProtocolAssignReviewersService protocolAssignReviewersService;
    private DataObjectService dataObjectService;
    private ProjectRetrievalService projectRetrievalService;
    private ProjectPublisher projectPublisher;

    @Override
    public int getTotalSubmissions(Protocol protocol) {
        int totalSubmissions = 0;
        for (ProtocolSubmission protocolSubmission : this.getProtocolSubmissions(protocol.getProtocolNumber())) {
            int submissionNumber = protocolSubmission.getSubmissionNumber();
            if (submissionNumber <= totalSubmissions || protocolSubmission.getSequenceNumber() > protocol.getSequenceNumber()) continue;
            totalSubmissions = submissionNumber;
        }
        return totalSubmissions;
    }

    protected List<ProtocolSubmission> getProtocolSubmissions(String protocolNumber) {
        Collection submissions = this.businessObjectService.findMatching(ProtocolSubmission.class, Collections.singletonMap(PROTOCOL_NUMBER, protocolNumber));
        return new ArrayList<ProtocolSubmission>(submissions);
    }

    private List<ProtocolSubmission> getProtocolSubmissionsLookupList(String protocolNumber, List<ProtocolSubmission> protocolSubmissionList) {
        ArrayList<ProtocolSubmission> protocolSubmissionLookupDataList = new ArrayList<ProtocolSubmission>();
        for (ProtocolSubmission protocolSubmissionData : protocolSubmissionList) {
            if (!protocolNumber.equals(protocolSubmissionData.getProtocolNumber())) continue;
            protocolSubmissionLookupDataList.add(protocolSubmissionData);
        }
        HashSet<Integer> submissionNumberList = new HashSet<Integer>();
        ArrayList<ProtocolSubmission> protocolSubmissionLookupResult = new ArrayList<ProtocolSubmission>();
        for (ProtocolSubmission protocolSubmissionResult : protocolSubmissionLookupDataList) {
            submissionNumberList.add(protocolSubmissionResult.getSubmissionNumber());
        }
        for (Integer submissionNumber : submissionNumberList) {
            ArrayList<ProtocolSubmission> submissionList = null;
            int submissionSequenceNumber = 0;
            for (ProtocolSubmission protocolsubmissionData : protocolSubmissionLookupDataList) {
                if (!protocolsubmissionData.getSubmissionNumber().equals(submissionNumber) || protocolsubmissionData.getSequenceNumber() < submissionSequenceNumber) continue;
                submissionSequenceNumber = protocolsubmissionData.getSequenceNumber();
                submissionList = new ArrayList<ProtocolSubmission>();
                submissionList.add(protocolsubmissionData);
            }
            if (submissionList == null) continue;
            protocolSubmissionLookupResult.add((ProtocolSubmission)submissionList.get(0));
        }
        return new ArrayList<ProtocolSubmission>(protocolSubmissionLookupResult);
    }

    @Override
    public List<ProtocolSubmission> getProtocolSubmissionsLookupData(List<ProtocolSubmission> protocolSubmissionList) {
        ArrayList<ProtocolSubmission> protocolSubmissionsLookupResult = new ArrayList<ProtocolSubmission>();
        HashSet<String> submissionProtocolNumberList = new HashSet<String>();
        for (ProtocolSubmission protocolSubmissionData : protocolSubmissionList) {
            submissionProtocolNumberList.add(protocolSubmissionData.getProtocolNumber());
        }
        for (String submissionProtocolNumber : submissionProtocolNumberList) {
            List<ProtocolSubmission> protocolSubmissionLookupList = this.getProtocolSubmissionsLookupList(submissionProtocolNumber, protocolSubmissionList);
            if (protocolSubmissionLookupList == null || protocolSubmissionLookupList.size() <= 0) continue;
            protocolSubmissionsLookupResult.addAll(protocolSubmissionLookupList);
        }
        return new ArrayList<ProtocolSubmission>(protocolSubmissionsLookupResult);
    }

    @Override
    public void submitToIrbForReview(ProtocolDocument document, ProtocolSubmitAction submitAction, Timestamp actionDate) {
        ProtocolDocument protocolDocument;
        List locks;
        String prevSubmissionStatus = document.getProtocol().getProtocolSubmission().getSubmissionStatusCode();
        String submissionTypeCode = document.getProtocol().getProtocolSubmission().getSubmissionTypeCode();
        ProtocolSubmission submission = this.createProtocolSubmission(document.getProtocol(), submitAction);
        if (document.getProtocol().getInitialSubmissionDate() == null) {
            document.getProtocol().setInitialSubmissionDate(new Date(submission.getSubmissionDate().getTime()));
        }
        this.protocolAssignReviewersService.assignReviewers(submission, submitAction.getReviewers());
        ProtocolAction protocolAction = new ProtocolAction(document.getProtocol(), submission, "101", actionDate);
        protocolAction.setComments(SUBMIT_TO_IRB);
        protocolAction.setPrevProtocolStatusCode(document.getProtocol().getProtocolStatusCode());
        protocolAction.setPrevSubmissionStatusCode(prevSubmissionStatus);
        protocolAction.setSubmissionTypeCode(submissionTypeCode);
        document.getProtocol().getProtocolActions().add(protocolAction);
        ProtocolStatus protocolStatus = new ProtocolStatus();
        protocolStatus.setProtocolStatusCode("101");
        protocolStatus.setDescription(SUBMIT_TO_IRB);
        document.getProtocol().setProtocolStatus(protocolStatus);
        document.getProtocol().setProtocolStatusCode("101");
        this.protocolActionService.updateProtocolStatus(protocolAction, document.getProtocol());
        if (submission.getScheduleIdFk() != null) {
            this.updateDefaultSchedule(submission);
        }
        if ((locks = document.getPessimisticLocks()) != null) {
            for (PessimisticLock lock : locks) {
                this.dataObjectService.delete((Object)lock);
            }
        }
        document.getPessimisticLocks().clear();
        try {
            protocolDocument = (ProtocolDocument)this.documentService.saveDocument((Document)document);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        document.refresh();
        Project project = this.getProjectRetrievalService().retrieveProject(protocolDocument.getProtocol().getProtocolNumber());
        if (project != null) {
            this.getProjectPublisher().publishProject(project);
        }
    }

    protected void updateDefaultSchedule(ProtocolSubmission submission) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("protocolIdFk", submission.getProtocolId().toString());
        fieldValues.put("scheduleIdFk", CommitteeSchedule.DEFAULT_SCHEDULE_ID.toString());
        List minutes = (List)this.businessObjectService.findMatching(CommitteeScheduleMinute.class, fieldValues);
        if (!minutes.isEmpty()) {
            for (CommitteeScheduleMinute minute : minutes) {
                minute.setScheduleIdFk(submission.getScheduleIdFk());
            }
            this.businessObjectService.save(minutes);
        }
    }

    protected ProtocolSubmission createProtocolSubmission(Protocol protocol, ProtocolSubmitAction submitAction) {
        ProtocolSubmissionBuilder submissionBuilder = new ProtocolSubmissionBuilder(protocol, submitAction.getSubmissionTypeCode());
        submissionBuilder.setSubmissionTypeQualifierCode(submitAction.getSubmissionQualifierTypeCode());
        submissionBuilder.setProtocolReviewTypeCode(submitAction.getProtocolReviewTypeCode());
        this.setSubmissionStatus(submissionBuilder, submitAction);
        this.setCommittee(submissionBuilder, submitAction);
        this.setSchedule(submissionBuilder, submitAction);
        this.addCheckLists(submissionBuilder, submitAction);
        return submissionBuilder.create();
    }

    protected void setSubmissionStatus(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        if (StringUtils.isBlank((CharSequence)submitAction.getNewCommitteeId())) {
            submissionBuilder.setSubmissionStatus("102");
        } else {
            submissionBuilder.setSubmissionStatus("100");
        }
    }

    protected void setCommittee(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        submissionBuilder.setCommittee(submitAction.getNewCommitteeId());
    }

    protected void setSchedule(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        submissionBuilder.setSchedule(submitAction.getNewScheduleId());
    }

    protected void addCheckLists(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        if (this.isProtocolReviewType(submitAction, "3")) {
            this.addExemptStudiesCheckList(submissionBuilder, submitAction);
        } else if (this.isProtocolReviewType(submitAction, "2")) {
            this.addExpeditedReviewCheckList(submissionBuilder, submitAction);
        }
    }

    protected boolean isProtocolReviewType(ProtocolSubmitAction submitAction, String protocolReviewTypeCode) {
        return StringUtils.equals((CharSequence)submitAction.getProtocolReviewTypeCode(), (CharSequence)protocolReviewTypeCode);
    }

    protected void addExemptStudiesCheckList(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction submitAction) {
        for (ExemptStudiesCheckListItem item : submitAction.getExemptStudiesCheckList()) {
            if (!item.getChecked()) continue;
            submissionBuilder.addExemptStudiesCheckListItem(item.getExemptStudiesCheckListCode());
        }
    }

    protected void addExpeditedReviewCheckList(ProtocolSubmissionBuilder submissionBuilder, ProtocolSubmitAction action) {
        for (ExpeditedReviewCheckListItem item : action.getExpeditedReviewCheckList()) {
            if (!item.getChecked()) continue;
            submissionBuilder.addExpeditedReviewCheckListItem(item.getExpeditedReviewCheckListCode());
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ProjectPublisher getProjectPublisher() {
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    public ProjectRetrievalService getProjectRetrievalService() {
        return this.projectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolAssignReviewersService(ProtocolAssignReviewersService protocolAssignReviewersService) {
        this.protocolAssignReviewersService = protocolAssignReviewersService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public ProtocolAssignReviewersService getProtocolAssignReviewersService() {
        return this.protocolAssignReviewersService;
    }
}

