/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.auth;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = -8742664470188406956L;
    public static final String CAN_MODIFY = "canModify";

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        ProtocolDocument protocolDocument = (ProtocolDocument)document;
        String userId = user.getPrincipalId();
        if (protocolDocument.getProtocol().getProtocolId() == null) {
            if (this.canCreateProtocol(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.canExecuteProtocolTask(userId, protocolDocument, "modifyProtocol")) {
                editModes.add("fullEntry");
            } else if (this.canExecuteProtocolTask(userId, protocolDocument, "viewProtocol")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canExecuteProtocolTask(userId, protocolDocument, "maintainProtocolOnlineReviews")) {
                editModes.add("maintainProtocolOnlineReviews");
            }
            if (this.canViewReviewComments((Document)protocolDocument, user)) {
                editModes.add("viewReviewComments");
            }
            if (this.canModify(protocolDocument, user)) {
                editModes.add(CAN_MODIFY);
            }
        }
        return editModes;
    }

    public boolean canViewReviewComments(Document document, Person user) {
        ProtocolDocument protocolDoc = (ProtocolDocument)document;
        List<ProtocolPersonBase> participants = protocolDoc.getProtocol().getProtocolPersons();
        for (ProtocolPersonBase participant : participants) {
            String statusCode;
            if (!StringUtils.equalsIgnoreCase((CharSequence)participant.getPersonId(), (CharSequence)user.getPrincipalId()) || !(statusCode = protocolDoc.getProtocol().getProtocolStatusCode()).equalsIgnoreCase("101")) continue;
            return false;
        }
        return true;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        if (GlobalVariables.getUserSession().getObjectMap().get("onAmendAndRenewAllowNewProtocolDocument") != null) {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
            return true;
        }
        return this.canCreateProtocol(user);
    }

    public boolean canOpen(Document document, Person user) {
        ProtocolDocument protocolDocument = (ProtocolDocument)document;
        if (protocolDocument.getProtocol().getProtocolId() == null) {
            return this.canCreateProtocol(user);
        }
        return this.canExecuteProtocolTask(user.getPrincipalId(), (ProtocolDocument)document, "viewProtocol");
    }

    private boolean canCreateProtocol(Person user) {
        ApplicationTask task = new ApplicationTask("createProtocol");
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), task);
    }

    private boolean canExecuteProtocolTask(String userId, ProtocolDocument doc, String taskName) {
        ProtocolTask task = new ProtocolTask(taskName, doc.getProtocol());
        TaskAuthorizationService taskAuthenticationService = KcServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteProtocolTask(user.getPrincipalId(), (ProtocolDocument)document, "modifyProtocol");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return false;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRecall(Document document, Person user) {
        return this.canExecuteProtocolTask(user.getPrincipalId(), (ProtocolDocument)document, "recallProtocol");
    }

    public boolean canModify(ProtocolDocument document, Person user) {
        Protocol protocol = document.getProtocol();
        return (!this.getWorkFlowService().isInWorkflow((Document)document) || protocol.isCorrectionMode()) && this.getAuthorizationService().hasPermission(user.getPrincipalId(), protocol, "Modify Protocol");
    }

    protected KcWorkflowService getWorkFlowService() {
        return KcServiceLocator.getService(KcWorkflowService.class);
    }

    protected KcAuthorizationService getAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }
}

