/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;

public class ProtocolReviewerBase
extends KcPersistableBusinessObjectBase {
    private Long protocolIdFk;
    private Long submissionIdFk;
    private boolean nonEmployeeFlag;
    private String personId;
    private Integer rolodexId;
    private Rolodex rolodex;
    private ProtocolBase protocol;
    private ProtocolSubmissionBase protocolSubmission;
    private transient KcPersonService kcPersonService;
    private transient KcPerson kcPerson;

    public Long getProtocolIdFk() {
        return this.protocolIdFk;
    }

    public void setProtocolIdFk(Long protocolIdFk) {
        this.protocolIdFk = protocolIdFk;
    }

    public Long getSubmissionIdFk() {
        return this.submissionIdFk;
    }

    public void setSubmissionIdFk(Long submissionIdFk) {
        this.submissionIdFk = submissionIdFk;
    }

    public boolean getNonEmployeeFlag() {
        return this.nonEmployeeFlag;
    }

    public void setNonEmployeeFlag(boolean nonEmployeeFlag) {
        this.nonEmployeeFlag = nonEmployeeFlag;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    public ProtocolSubmissionBase getProtocolSubmission() {
        return this.protocolSubmission;
    }

    public void setProtocolSubmission(ProtocolSubmissionBase protocolSubmission) {
        this.protocolSubmission = protocolSubmission;
    }

    public KcPerson getPerson() {
        if (this.kcPerson == null) {
            this.kcPerson = this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        return this.kcPerson;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public boolean isProtocolReviewerFromCommitteeMembership(CommitteeMembershipBase member) {
        boolean isMatched = false;
        if (!this.getNonEmployeeFlag() && StringUtils.equals((CharSequence)member.getPersonId(), (CharSequence)this.getPersonId())) {
            isMatched = true;
        } else if (this.getNonEmployeeFlag() && Objects.equals(member.getRolodexId(), this.getRolodexId())) {
            isMatched = true;
        }
        return isMatched;
    }

    public boolean isPersonIdProtocolReviewer(String personId, boolean nonEmployeeFlag) {
        boolean result = false;
        if (nonEmployeeFlag == this.getNonEmployeeFlag() && (this.getNonEmployeeFlag() && StringUtils.equals((CharSequence)(this.getRolodexId() == null ? null : this.getRolodexId().toString()), (CharSequence)personId) && this.getNonEmployeeFlag() == nonEmployeeFlag || !this.getNonEmployeeFlag() && StringUtils.equals((CharSequence)personId, (CharSequence)this.personId))) {
            result = true;
        }
        return result;
    }

    public String getFullName() {
        if (this.nonEmployeeFlag && this.rolodexId != null) {
            this.refreshReferenceObject("rolodex");
            return this.getRolodex().getFullName();
        }
        if (this.getPerson() != null) {
            return this.getPerson().getFullName();
        }
        return null;
    }
}

