/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class CommitteeLookupableHelperServiceImplBase<CMT extends CommitteeBase<CMT, ?, ?>>
extends KraLookupableHelperServiceImpl {
    private static final String COMMITTEE_TYPE_CODE_FIELD_NAME = "committeeTypeCode";
    private static final String PERSON_NAME = "personName";
    private static final String RESEARCH_AREA_CODE = "researchAreaCode";
    private static final String COMMITTEE_ID = "committeeId";
    private static final String VIEW_ACTIVE = "view active";
    private static final String RESUME_EDIT = "resume edit";
    private static final String COMMITTEE_MEMBERSHIPS_PERSON_NAME = "committeeMemberships.personName";
    private static final String COMMITTEE_RESEARCH_AREAS_RESEARCH_AREA_CODE = "committeeResearchAreas.researchAreaCode";
    private Map<String, String> latestFinalCommitteeMap = new HashMap<String, String>();
    private transient KcAuthorizationService kcAuthorizationService;

    public List<CMT> getSearchResults(Map<String, String> fieldValues) {
        fieldValues.put(COMMITTEE_TYPE_CODE_FIELD_NAME, this.getCommitteeTypeCodeHook());
        List results = super.getSearchResultsUnbounded(fieldValues);
        CollectionIncomplete activeCommittees = this.getUniqueList(results);
        this.latestFinalCommitteeMap = this.getLatestDocumentNumber(results, "F");
        long matchingResultsCount = activeCommittees.size();
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit(this.getCommitteeBOClassHook());
        return matchingResultsCount <= (long)searchResultsLimit.intValue() ? activeCommittees : new CollectionIncomplete((Collection)activeCommittees.stream().limit(searchResultsLimit.intValue()).collect(Collectors.toList()), Long.valueOf(matchingResultsCount));
    }

    protected abstract String getCommitteeTypeCodeHook();

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals(COMMITTEE_RESEARCH_AREAS_RESEARCH_AREA_CODE)) {
                    super.updateLookupField(field, RESEARCH_AREA_CODE, ResearchArea.class.getName());
                    continue;
                }
                if (!field.getPropertyName().equals(COMMITTEE_MEMBERSHIPS_PERSON_NAME)) continue;
                super.updateLookupField(field, PERSON_NAME, this.getCommitteeMembershipFullyQualifiedClassNameHook());
            }
        }
        return rows;
    }

    protected abstract String getCommitteeMembershipFullyQualifiedClassNameHook();

    protected List<CMT> getUniqueList(List<CMT> committees) {
        ArrayList uniqueResults = new ArrayList();
        ArrayList committeeIds = new ArrayList();
        if (CollectionUtils.isNotEmpty(committees)) {
            Collections.sort(committees, Collections.reverseOrder());
            committees.stream().filter(committee -> !committeeIds.contains(committee.getCommitteeId())).forEach(committee -> {
                committee.getCommitteeChair();
                uniqueResults.add(committee);
                committeeIds.add(committee.getCommitteeId());
            });
        }
        return uniqueResults;
    }

    protected Map<String, String> getLatestDocumentNumber(List<CMT> committees, String routeHeaderCode) {
        return committees.stream().filter(committee -> ((CommitteeDocumentBase)committee.getCommitteeDocument()).getDocStatusCode().equals(routeHeaderCode)).collect(Collectors.groupingBy(committee -> committee.getCommitteeId())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value -> ((List)value.getValue()).stream().max(Comparator.comparingInt(committee -> committee.getSequenceNumber())).get().getCommitteeDocument().getDocumentNumber()));
    }

    @Override
    protected abstract String getHtmlAction();

    @Override
    protected abstract String getDocumentTypeName();

    protected abstract String getCustomResumeEditUrl(String var1);

    @Override
    protected String getKeyFieldName() {
        return COMMITTEE_ID;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        String finalCommitteeDocId;
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.getKraAuthorizationService().hasPermission(this.getUserIdentifier(), (CommitteeBase)businessObject, this.getModifyCommitteePermissionNameHook())) {
            String editCommitteeDocId = this.latestFinalCommitteeMap.get(((CommitteeBase)businessObject).getCommitteeId());
            if (StringUtils.isBlank((CharSequence)editCommitteeDocId) || !editCommitteeDocId.equals(((CommitteeBase)businessObject).getCommitteeDocument().getDocumentNumber()) && !((CommitteeDocumentBase)((CommitteeBase)businessObject).getCommitteeDocument()).getDocStatusCode().equals("X")) {
                HtmlData.AnchorHtmlData resumeEdit = new HtmlData.AnchorHtmlData(this.getCustomResumeEditUrl(((CommitteeBase)businessObject).getCommitteeDocument().getDocumentNumber()), "docHandler", "edit");
                resumeEdit.setDisplayText(RESUME_EDIT);
                htmlDataList.add((HtmlData)resumeEdit);
            } else {
                htmlDataList.add((HtmlData)this.getEditLink(businessObject));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(finalCommitteeDocId = this.latestFinalCommitteeMap.get(((CommitteeBase)businessObject).getCommitteeId()))) && this.getKraAuthorizationService().hasPermission(this.getUserIdentifier(), (CommitteeBase)businessObject, this.getViewCommitteePermissionNameHook())) {
            HtmlData.AnchorHtmlData htmlData = this.getViewLink(finalCommitteeDocId);
            htmlData.setDisplayText(VIEW_ACTIVE);
            htmlDataList.add((HtmlData)htmlData);
        }
        return htmlDataList;
    }

    protected abstract String getViewCommitteePermissionNameHook();

    protected abstract String getModifyCommitteePermissionNameHook();

    protected abstract Class<CMT> getCommitteeBOClassHook();

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected KcAuthorizationService getKraAuthorizationService() {
        if (this.kcAuthorizationService == null) {
            this.kcAuthorizationService = KcServiceLocator.getService(KcAuthorizationService.class);
        }
        return this.kcAuthorizationService;
    }

    public void setKcAuthorizationService(KcAuthorizationService kcAuthorizationService) {
        this.kcAuthorizationService = kcAuthorizationService;
    }
}

