/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kra.protocol.CriteriaFieldHelper;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDao;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.rice.core.framework.persistence.platform.DatabasePlatform;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.dao.LookupDao;
import org.kuali.rice.krad.service.util.OjbCollectionAware;

public abstract class ProtocolDaoOjbBase<GenericProtocol extends ProtocolBase>
extends PlatformAwareDaoBaseOjb
implements OjbCollectionAware,
ProtocolDao<GenericProtocol> {
    private static final Logger LOG = LogManager.getLogger(ProtocolDaoOjbBase.class);
    private static final String LEAD_UNIT = "leadUnit";
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String EXPIRATION_DATE = "expirationDate";
    private static final String PROTOCOL_STATUS_CODE = "protocolStatusCode";
    private static final String SUBMISSION_STATUS_CODE = "submissionStatusCode";
    private static final String PROTOCOL_SUBMISSIONS_COMMITTEE_ID = "protocolSubmissions.committeeId";
    private static final String PROTOCOL_SUBMISSIONS_SUBMISSION_NUMBER = "protocolSubmissions.submissionNumber";
    private static final String ACTUAL_ACTION_DATE = "actualActionDate";
    private static final String PROTOCOL_ACTION_TYPE_CODE = "protocolActionTypeCode";
    private LookupDao lookupDao;
    private DataDictionaryService dataDictionaryService;
    private List<String> investigatorRole = new ArrayList<String>();
    private List<String> personRole = new ArrayList<String>();
    private List<String> excludedFields = new ArrayList<String>();
    protected List<String> collectionFieldNames = new ArrayList<String>();

    public ProtocolDaoOjbBase() {
        this.initialization();
    }

    @Override
    public List<GenericProtocol> getProtocols(Map<String, String> fieldValues) {
        Criteria crit = new Criteria();
        HashMap<String, String> baseLookupFieldValues = new HashMap<String, String>();
        HashMap<String, CriteriaFieldHelper> collectionFieldValues = new HashMap<String, CriteriaFieldHelper>();
        this.setupCritMaps(fieldValues, baseLookupFieldValues, collectionFieldValues);
        if (!baseLookupFieldValues.isEmpty()) {
            try {
                crit = this.getCollectionCriteriaFromMap((PersistableBusinessObject)this.getProtocolBOClassHook().newInstance(), baseLookupFieldValues);
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (!collectionFieldValues.isEmpty()) {
            for (Map.Entry<Object, Object> entry : collectionFieldValues.entrySet()) {
                crit.addExists((Query)this.getCollectionReportQuery((String)entry.getKey(), (CriteriaFieldHelper)entry.getValue()));
            }
        }
        for (Map.Entry<Object, Object> entry : fieldValues.entrySet()) {
            if (!((String)entry.getKey()).startsWith(LEAD_UNIT) || !StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            crit.addExists((Query)this.getUnitReportQuery(entry));
        }
        Long matchingResultsCount = null;
        Integer n = LookupUtils.getSearchResultsLimit(this.getProtocolBOClassHook());
        if (n != null) {
            matchingResultsCount = this.getPersistenceBrokerTemplate().getCount((Query)QueryFactory.newQuery(this.getProtocolBOClassHook(), (Criteria)crit));
            LookupUtils.applySearchResultsLimit(this.getProtocolBOClassHook(), (Criteria)crit, (DatabasePlatform)this.getDbPlatform());
        }
        if (matchingResultsCount == null || matchingResultsCount <= (long)n.intValue()) {
            matchingResultsCount = new Long(0L);
        }
        QueryByCriteria q = QueryFactory.newQuery(this.getProtocolBOClassHook(), (Criteria)crit, (boolean)true);
        ProtocolDaoOjbBase.logQuery((Query)q);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
    }

    @Override
    public <T extends ProtocolAttachmentBase> List<T> retrieveAttachmentVersions(T attachment, Class<T> type) {
        List attachments;
        if (this.validAttachmentForVersionLookup(attachment)) {
            Criteria crit = new Criteria();
            crit.addEqualTo(PROTOCOL_NUMBER, (Object)attachment.getProtocolNumber());
            crit.addEqualTo("typeCode", (Object)attachment.getTypeCode());
            crit.addEqualTo("documentId", (Object)attachment.getDocumentId());
            QueryByCriteria q = QueryFactory.newQuery(type, (Criteria)crit, (boolean)true);
            q.addOrderBy("file.sequenceNumber", false);
            ProtocolDaoOjbBase.logQuery((Query)q);
            attachments = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
        } else {
            attachments = new ArrayList();
        }
        return attachments;
    }

    @Override
    public List<GenericProtocol> getExpiringProtocols(String committeeId, Date startDate, Date endDate) {
        Criteria crit = new Criteria();
        crit.addEqualTo(PROTOCOL_SUBMISSIONS_COMMITTEE_ID, (Object)committeeId);
        if (startDate != null) {
            crit.addGreaterOrEqualThan((Object)EXPIRATION_DATE, (Object)startDate);
        }
        if (endDate != null) {
            crit.addLessOrEqualThan((Object)EXPIRATION_DATE, (Object)this.nextDay(endDate));
        }
        crit.addIn(PROTOCOL_STATUS_CODE, this.getActiveProtocolStatusCodesHook());
        crit.addIn(SUBMISSION_STATUS_CODE, this.getApprovedSubmissionStatusCodesHook());
        crit.addEqualTo(SEQUENCE_NUMBER, (Object)this.getSubQueryMaxSequenceNumber());
        crit.addEqualTo(PROTOCOL_SUBMISSIONS_SUBMISSION_NUMBER, (Object)this.getsubQueryMaxProtocolSubmission());
        QueryByCriteria q = QueryFactory.newQuery(this.getProtocolBOClassHook(), (Criteria)crit, (boolean)true);
        ProtocolDaoOjbBase.logQuery((Query)q);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
    }

    protected abstract Collection<String> getApprovedSubmissionStatusCodesHook();

    protected abstract Collection<String> getActiveProtocolStatusCodesHook();

    @Override
    public List<ProtocolBase> getNotifiedProtocols(String committeeId, Date startDate, Date endDate) {
        Criteria subCritProtocolAction = new Criteria();
        subCritProtocolAction.addEqualToField("protocolId", "parentQuery.protocolId");
        subCritProtocolAction.addIn(PROTOCOL_ACTION_TYPE_CODE, this.getRevisionRequestedProtocolActionTypeCodesHook());
        if (startDate != null) {
            subCritProtocolAction.addGreaterOrEqualThan((Object)ACTUAL_ACTION_DATE, (Object)startDate);
        }
        if (endDate != null) {
            subCritProtocolAction.addLessThan((Object)ACTUAL_ACTION_DATE, (Object)this.nextDay(endDate));
        }
        ReportQueryByCriteria subQueryProtocolAction = QueryFactory.newReportQuery(this.getProtocolActionBOClassHoook(), (Criteria)subCritProtocolAction);
        Criteria crit = new Criteria();
        crit.addIn(PROTOCOL_STATUS_CODE, this.getRevisionRequestedProtocolStatusCodesHook());
        crit.addEqualTo(PROTOCOL_SUBMISSIONS_COMMITTEE_ID, (Object)committeeId);
        crit.addEqualTo(SEQUENCE_NUMBER, (Object)this.getSubQueryMaxSequenceNumber());
        crit.addEqualTo(PROTOCOL_SUBMISSIONS_SUBMISSION_NUMBER, (Object)this.getsubQueryMaxProtocolSubmission());
        crit.addExists((Query)subQueryProtocolAction);
        QueryByCriteria q = QueryFactory.newQuery(this.getProtocolBOClassHook(), (Criteria)crit, (boolean)true);
        ProtocolDaoOjbBase.logQuery((Query)q);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)q);
    }

    protected abstract Collection<String> getRevisionRequestedProtocolActionTypeCodesHook();

    protected abstract Collection<String> getRevisionRequestedProtocolStatusCodesHook();

    protected abstract Class<? extends ProtocolActionBase> getProtocolActionBOClassHoook();

    private ReportQueryByCriteria getSubQueryMaxSequenceNumber() {
        Criteria subCritMaxSequenceNumber = new Criteria();
        subCritMaxSequenceNumber.addEqualToField(PROTOCOL_NUMBER, "parentQuery.protocolNumber");
        ReportQueryByCriteria subQueryMaxSequenceNumber = QueryFactory.newReportQuery(this.getProtocolBOClassHook(), (Criteria)subCritMaxSequenceNumber);
        subQueryMaxSequenceNumber.setAttributes(new String[]{"max(sequence_number)"});
        return subQueryMaxSequenceNumber;
    }

    private ReportQueryByCriteria getsubQueryMaxProtocolSubmission() {
        Criteria subCritMaxSubmissionNumber = new Criteria();
        subCritMaxSubmissionNumber.addEqualToField(PROTOCOL_NUMBER, "parentQuery.protocolNumber");
        ReportQueryByCriteria subQueryMaxProtocolSubmission = QueryFactory.newReportQuery(this.getProtocolSubmissionBOClassHook(), (Criteria)subCritMaxSubmissionNumber);
        subQueryMaxProtocolSubmission.setAttributes(new String[]{"max(submission_number)"});
        return subQueryMaxProtocolSubmission;
    }

    private Date nextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return new Date(calendar.getTimeInMillis());
    }

    private static void logQuery(Query q) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(q.toString());
        }
    }

    private <T extends ProtocolAttachmentBase> boolean validAttachmentForVersionLookup(T attachment) {
        return attachment != null && attachment.getProtocolNumber() != null && attachment.getSequenceNumber() != null && attachment.getProtocolId() != null && attachment.getTypeCode() != null && attachment.getDocumentId() != null;
    }

    private void initialization() {
        this.initExcludedFields();
        this.initCollectionFields();
        this.initRoleLists();
    }

    private void initExcludedFields() {
        this.excludedFields.add("backLocation");
        this.excludedFields.add("docFormKey");
    }

    protected void initCollectionFields() {
        for (CriteriaFieldHelper criteriaHelper : this.getCriteriaFields()) {
            this.collectionFieldNames.add(criteriaHelper.getSearchKey());
        }
    }

    private void initRoleLists() {
        this.initRoleListsHook(this.investigatorRole, this.personRole);
    }

    protected abstract void initRoleListsHook(List<String> var1, List<String> var2);

    protected ReportQueryByCriteria getCollectionReportQuery(String key, CriteriaFieldHelper critField) {
        Criteria crit = new Criteria();
        crit.addEqualToField("protocolId", "parentQuery.protocolId");
        String nameValue = critField.getFieldValue().replace('*', '%');
        String propertyName = this.getDbPlatform().getUpperCaseFunction() + "(" + critField.getCritFieldName() + ")";
        crit.addLike((Object)propertyName, (Object)nameValue.toUpperCase());
        if (this.isProtocolPersonField(key)) {
            this.addPersonRoleId(key, crit);
        } else if (key.equals("performingOrganizationId")) {
            crit.addLike((Object)"protocolOrganizationTypeCode", (Object)"1");
        }
        return QueryFactory.newReportQuery(critField.getClazz(), (Criteria)crit);
    }

    private void addPersonRoleId(String key, Criteria crit) {
        if (key.equals("keyPerson")) {
            crit.addIn("protocolPersonRoleId", this.personRole);
        } else {
            crit.addIn("protocolPersonRoleId", this.investigatorRole);
        }
    }

    private void setupCritMaps(Map<String, String> fieldValues, Map<String, String> baseLookupFieldValues, Map<String, CriteriaFieldHelper> collectionFieldValues) {
        fieldValues.entrySet().stream().filter(entry -> !this.excludedFields.contains(entry.getKey()) && StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).forEach(entry -> {
            if (this.collectionFieldNames.contains(entry.getKey())) {
                collectionFieldValues.put((String)entry.getKey(), this.getCriteria((Map.Entry<String, String>)entry));
            } else if (!((String)entry.getKey()).startsWith(LEAD_UNIT)) {
                baseLookupFieldValues.put((String)entry.getKey(), (String)entry.getValue());
            }
        });
    }

    private CriteriaFieldHelper getCriteria(Map.Entry<String, String> entry) {
        String searchKeyName = entry.getKey();
        CriteriaFieldHelper critFieldHelper = new CriteriaFieldHelper();
        for (CriteriaFieldHelper criteriaField : this.getCriteriaFields()) {
            if (!criteriaField.getSearchKey().equalsIgnoreCase(searchKeyName)) continue;
            criteriaField.setFieldValue(entry.getValue());
            critFieldHelper = criteriaField;
            break;
        }
        return critFieldHelper;
    }

    private boolean isProtocolPersonField(String fieldName) {
        return fieldName.equals("keyPerson") || fieldName.equals("investigator");
    }

    private ReportQueryByCriteria getUnitReportQuery(Map.Entry<String, String> entry) {
        Criteria crit = new Criteria();
        crit.addEqualToField("protocolId", "parentQuery.protocolId");
        Criteria subCrit = new Criteria();
        String nameValue = entry.getValue().replace('*', '%');
        String propertyName = entry.getKey().equals("leadUnitNumber") ? this.getDbPlatform().getUpperCaseFunction() + "(unitNumber)" : this.getDbPlatform().getUpperCaseFunction() + "(unit.unitName)";
        subCrit.addLike((Object)propertyName, (Object)nameValue.toUpperCase());
        subCrit.addEqualToField("protocolPersonId", "parentQuery.protocolPersonId");
        crit.addExists((Query)QueryFactory.newReportQuery(this.getProtocolUnitBOClassHook(), (Criteria)subCrit));
        return QueryFactory.newReportQuery(this.getProtocolPersonBOClassHook(), (Criteria)crit);
    }

    private Criteria getCollectionCriteriaFromMap(PersistableBusinessObject businessObject, Map formProps) {
        Criteria criteria = new Criteria();
        for (Object o : formProps.keySet()) {
            String propertyName = (String)o;
            if (formProps.get(propertyName) instanceof Collection) {
                for (Object o1 : (Collection)formProps.get(propertyName)) {
                    if (this.lookupDao.createCriteria((Object)businessObject, (String)o1, propertyName, this.isCaseSensitive(businessObject, propertyName), false, (Object)criteria)) continue;
                    throw new RuntimeException("Invalid value in Collection");
                }
                continue;
            }
            if (this.lookupDao.createCriteria((Object)businessObject, (String)formProps.get(propertyName), propertyName, this.isCaseSensitive(businessObject, propertyName), false, (Object)criteria)) continue;
        }
        return criteria;
    }

    private boolean isCaseSensitive(PersistableBusinessObject persistBo, String propertyName) {
        boolean caseInsensitive = false;
        if (this.dataDictionaryService.isAttributeDefined(persistBo.getClass(), propertyName).booleanValue()) {
            caseInsensitive = this.dataDictionaryService.getAttributeForceUppercase(persistBo.getClass(), propertyName) == false;
        }
        return caseInsensitive;
    }

    public void setLookupDao(LookupDao lookupDao) {
        this.lookupDao = lookupDao;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    @Override
    public boolean getProtocolSubmissionCountFromProtocol(String protocolNumber) {
        Criteria crit = new Criteria();
        crit.addLike((Object)PROTOCOL_NUMBER, (Object)(protocolNumber + "%"));
        crit.addEqualTo(SEQUENCE_NUMBER, (Object)this.getMaxSequenceNumberQuery());
        crit.addIn(PROTOCOL_STATUS_CODE, this.getPendingAmendmentRenewalsProtocolStatusCodesHook());
        ReportQueryByCriteria query = QueryFactory.newReportQuery(this.getProtocolBOClassHook(), (Criteria)crit);
        ProtocolDaoOjbBase.logQuery((Query)query);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query).isEmpty();
    }

    protected abstract Collection<String> getPendingAmendmentRenewalsProtocolStatusCodesHook();

    private ReportQueryByCriteria getMaxSequenceNumberQuery() {
        Criteria subCrit = new Criteria();
        subCrit.addEqualToField(PROTOCOL_NUMBER, "parentQuery.protocolNumber");
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(this.getProtocolBOClassHook(), (Criteria)subCrit);
        subQuery.setAttributes(new String[]{"max(sequence_number)"});
        return subQuery;
    }

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    protected abstract Class<? extends ProtocolPersonBase> getProtocolPersonBOClassHook();

    protected abstract Class<? extends ProtocolUnitBase> getProtocolUnitBOClassHook();

    protected abstract Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook();

    protected abstract List<CriteriaFieldHelper> getCriteriaFields();
}

