/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="controlBase", parent="Uif-ControlBase")
public abstract class ControlBase
extends ContentElementBase
implements Control {
    private static final long serialVersionUID = -7898244978136312663L;
    private int tabIndex;
    private boolean disabled = false;
    private String disabledExpression;
    private String disabledReason;
    private boolean evaluateDisabledOnKeyUp;
    private String disabledConditionJs;
    private List<String> disabledConditionControlNames;
    private List<String> disabledWhenChangedPropertyNames = new ArrayList<String>();
    private List<String> enabledWhenChangedPropertyNames = new ArrayList<String>();

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        this.disabledExpression = this.getPropertyExpression("disabled");
        if (this.disabledExpression != null) {
            ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
            this.disabledExpression = expressionEvaluator.replaceBindingPrefixes(ViewLifecycle.getView(), this, this.disabledExpression);
            this.disabled = (Boolean)expressionEvaluator.evaluateExpression(this.getContext(), this.disabledExpression);
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        if (StringUtils.isNotEmpty((String)this.disabledExpression) && !this.disabledExpression.equalsIgnoreCase("true") && !this.disabledExpression.equalsIgnoreCase("false")) {
            this.disabledConditionControlNames = new ArrayList<String>();
            this.disabledConditionJs = expressionEvaluator.parseExpression(this.disabledExpression, this.disabledConditionControlNames, this.getContext());
        }
        View view = ViewLifecycle.getView();
        ArrayList<String> adjustedDisablePropertyNames = new ArrayList<String>();
        for (String propertyName : this.disabledWhenChangedPropertyNames) {
            adjustedDisablePropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, propertyName));
        }
        this.disabledWhenChangedPropertyNames = adjustedDisablePropertyNames;
        ArrayList<String> adjustedEnablePropertyNames = new ArrayList<String>();
        for (String propertyName : this.enabledWhenChangedPropertyNames) {
            adjustedEnablePropertyNames.add(expressionEvaluator.replaceBindingPrefixes(view, this, propertyName));
        }
        this.enabledWhenChangedPropertyNames = adjustedEnablePropertyNames;
        this.addDataAttribute("role", "Control");
    }

    @Override
    public final String getComponentTypeName() {
        return "control";
    }

    @Override
    @BeanTagAttribute
    public int getTabIndex() {
        return this.tabIndex;
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    @Override
    @BeanTagAttribute
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    @BeanTagAttribute
    public String getDisabledReason() {
        return this.disabledReason;
    }

    @Override
    public void setDisabledReason(String disabledReason) {
        this.disabledReason = disabledReason;
    }

    @BeanTagAttribute
    public boolean isEvaluateDisabledOnKeyUp() {
        return this.evaluateDisabledOnKeyUp;
    }

    public void setEvaluateDisabledOnKeyUp(boolean evaluateDisabledOnKeyUp) {
        this.evaluateDisabledOnKeyUp = evaluateDisabledOnKeyUp;
    }

    public String getDisabledConditionJs() {
        return this.disabledConditionJs;
    }

    public List<String> getDisabledConditionControlNames() {
        return this.disabledConditionControlNames;
    }

    @BeanTagAttribute
    public List<String> getDisabledWhenChangedPropertyNames() {
        return this.disabledWhenChangedPropertyNames;
    }

    public void setDisabledWhenChangedPropertyNames(List<String> disabledWhenChangedPropertyNames) {
        this.disabledWhenChangedPropertyNames = disabledWhenChangedPropertyNames;
    }

    @BeanTagAttribute
    public List<String> getEnabledWhenChangedPropertyNames() {
        return this.enabledWhenChangedPropertyNames;
    }

    public void setEnabledWhenChangedPropertyNames(List<String> enabledWhenChangedPropertyNames) {
        this.enabledWhenChangedPropertyNames = enabledWhenChangedPropertyNames;
    }

    protected void setDisabledExpression(String disabledExpression) {
        this.disabledExpression = disabledExpression;
    }

    protected void setDisabledConditionJs(String disabledConditionJs) {
        this.disabledConditionJs = disabledConditionJs;
    }

    protected void setDisabledConditionControlNames(List<String> disabledConditionControlNames) {
        this.disabledConditionControlNames = disabledConditionControlNames;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        super.completeValidation(tracer.getCopy());
    }
}

