/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.unit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.location.impl.campus.CampusBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="unitLookupableHelperService")
@Scope(value="prototype")
public class UnitLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = -3661085880649722426L;
    private static final String CAMPUS_CODE_FIELD = "code";
    private static final String CAMPUS_LOOKUPABLE_CLASS_NAME = CampusBo.class.getName();
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="unitAuthorizationService")
    private UnitAuthorizationService unitAuthorizationService;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        String personId = this.getKcPersonService().getKcPersonByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId()).getPersonId();
        boolean hasModifyPermission = this.getUnitAuthorizationService().hasPermission(personId, "KC-UNT", "Modify Unit");
        if (hasModifyPermission) {
            HtmlData.AnchorHtmlData editHtmlData = this.getUrlData(businessObject, "edit", pkNames);
            htmlDataList.add((HtmlData)editHtmlData);
            HtmlData.AnchorHtmlData copyHtmlData = this.getUrlData(businessObject, "copy", pkNames);
            htmlDataList.add((HtmlData)copyHtmlData);
            HtmlData.AnchorHtmlData deleteHtmlData = this.getUrlData(businessObject, "delete", pkNames);
            htmlDataList.add((HtmlData)deleteHtmlData);
        }
        return htmlDataList;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        boolean multiCampusEnabled = this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals(CAMPUS_CODE_FIELD)) continue;
                field.setFieldConversions("code:" + field.getPropertyName());
                field.setLookupParameters(field.getPropertyName() + ":code");
                field.setInquiryParameters(field.getPropertyName() + ":code");
                field.setQuickFinderClassNameImpl(CAMPUS_LOOKUPABLE_CLASS_NAME);
                field.setFieldDirectInquiryEnabled(true);
                if (!multiCampusEnabled || !StringUtils.isBlank((CharSequence)field.getDefaultValue())) continue;
                String campusCode = (String)GlobalVariables.getUserSession().retrieveObject("userCampusCode");
                field.setDefaultValue(campusCode);
                field.setPropertyValue(field.getDefaultValue());
            }
        }
        return rows;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        String campusCode = fieldValues.remove(CAMPUS_CODE_FIELD);
        List searchResults = super.getSearchResults(fieldValues);
        List filteredSearchResults = CollectionUtils.createCorrectImplementationForCollection(searchResults);
        filteredSearchResults.addAll(searchResults.stream().filter(unit -> StringUtils.startsWith((CharSequence)unit.getUnitNumber(), (CharSequence)campusCode)).collect(Collectors.toList()));
        return filteredSearchResults;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }
}

