/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.identity.address;

import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.joda.time.DateTime;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.privacy.EntityPrivacyPreferences;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@MappedSuperclass
public abstract class EntityAddressBase
extends DataObjectBase
implements EntityAddressContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = -7550286656495828391L;
    @Column(name="ENTITY_ID")
    private String entityId;
    @Column(name="ADDR_TYP_CD")
    private String addressTypeCode;
    @Column(name="ENT_TYP_CD")
    private String entityTypeCode;
    @Column(name="CITY")
    private String city;
    @Column(name="STATE_PVC_CD")
    private String stateProvinceCode;
    @Column(name="POSTAL_CD")
    private String postalCode;
    @Column(name="POSTAL_CNTRY_CD")
    private String countryCode;
    @Column(name="ATTN_LINE")
    private String attentionLine;
    @Column(name="ADDR_LINE_1")
    private String line1;
    @Column(name="ADDR_LINE_2")
    private String line2;
    @Column(name="ADDR_LINE_3")
    private String line3;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="DFLT_IND")
    private boolean defaultValue;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="ACTV_IND")
    private boolean active;
    @Column(name="ADDR_FMT")
    private String addressFormat;
    @Column(name="MOD_DT")
    private Timestamp modifiedDate;
    @Column(name="VALID_DT")
    private Timestamp validatedDate;
    @Convert(converter=BooleanYNConverter.class)
    @Column(name="VALID_IND")
    private boolean validated;
    @Column(name="NOTE_MSG")
    private String noteMessage;
    @Transient
    private boolean suppressAddress;

    public EntityAddressBase() {
    }

    public boolean isSuppressAddress() {
        try {
            EntityPrivacyPreferences privacy = KimApiServiceLocator.getIdentityService().getEntityPrivacyPreferences(this.getEntityId());
            this.suppressAddress = privacy != null ? privacy.isSuppressAddress() : false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException c) {
            return false;
        }
        return this.suppressAddress;
    }

    public String getAttentionLine() {
        if (this.isSuppressAddress()) {
            return "Xxxxxx";
        }
        return this._persistence_get_attentionLine();
    }

    public String getLine1() {
        if (this.isSuppressAddress()) {
            return "Xxxxxx";
        }
        return this._persistence_get_line1();
    }

    public String getLine2() {
        if (this.isSuppressAddress()) {
            return "Xxxxxx";
        }
        return this._persistence_get_line2();
    }

    public String getLine3() {
        if (this.isSuppressAddress()) {
            return "Xxxxxx";
        }
        return this._persistence_get_line3();
    }

    public String getCity() {
        if (this.isSuppressAddress()) {
            return "Xxxxxx";
        }
        return this._persistence_get_city();
    }

    public String getStateProvinceCode() {
        if (this.isSuppressAddress()) {
            return "XX";
        }
        return this._persistence_get_stateProvinceCode();
    }

    public String getPostalCode() {
        if (this.isSuppressAddress()) {
            return "00000";
        }
        return this._persistence_get_postalCode();
    }

    public String getCountryCode() {
        if (this.isSuppressAddress()) {
            return "XX";
        }
        return this._persistence_get_countryCode();
    }

    public String getAttentionLineUnmasked() {
        return this._persistence_get_attentionLine();
    }

    public String getLine1Unmasked() {
        return this._persistence_get_line1();
    }

    public String getLine2Unmasked() {
        return this._persistence_get_line2();
    }

    public String getLine3Unmasked() {
        return this._persistence_get_line3();
    }

    public String getCityUnmasked() {
        return this._persistence_get_city();
    }

    public String getStateProvinceCodeUnmasked() {
        return this._persistence_get_stateProvinceCode();
    }

    public String getPostalCodeUnmasked() {
        return this._persistence_get_postalCode();
    }

    public String getCountryCodeUnmasked() {
        return this._persistence_get_countryCode();
    }

    public DateTime getModifiedDate() {
        return this._persistence_get_modifiedDate() != null ? new DateTime(this._persistence_get_modifiedDate().getTime()) : null;
    }

    public Timestamp getModifiedTimestamp() {
        return this._persistence_get_modifiedDate();
    }

    public DateTime getValidatedDate() {
        return this._persistence_get_validatedDate() != null ? new DateTime(this._persistence_get_validatedDate().getTime()) : null;
    }

    public Timestamp getValidatedTimestamp() {
        return this._persistence_get_validatedDate();
    }

    public String getEntityId() {
        return this._persistence_get_entityId();
    }

    public void setEntityId(String entityId) {
        this._persistence_set_entityId(entityId);
    }

    public String getAddressTypeCode() {
        return this._persistence_get_addressTypeCode();
    }

    public void setAddressTypeCode(String addressTypeCode) {
        this._persistence_set_addressTypeCode(addressTypeCode);
    }

    public String getEntityTypeCode() {
        return this._persistence_get_entityTypeCode();
    }

    public void setEntityTypeCode(String entityTypeCode) {
        this._persistence_set_entityTypeCode(entityTypeCode);
    }

    public void setCity(String city) {
        this._persistence_set_city(city);
    }

    public void setStateProvinceCode(String stateProvinceCode) {
        this._persistence_set_stateProvinceCode(stateProvinceCode);
    }

    public void setPostalCode(String postalCode) {
        this._persistence_set_postalCode(postalCode);
    }

    public void setCountryCode(String countryCode) {
        this._persistence_set_countryCode(countryCode);
    }

    public void setAttentionLine(String attentionLine) {
        this._persistence_set_attentionLine(attentionLine);
    }

    public void setLine1(String line1) {
        this._persistence_set_line1(line1);
    }

    public void setLine2(String line2) {
        this._persistence_set_line2(line2);
    }

    public void setLine3(String line3) {
        this._persistence_set_line3(line3);
    }

    public boolean getDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public boolean isDefaultValue() {
        return this._persistence_get_defaultValue();
    }

    public void setDefaultValue(boolean defaultValue) {
        this._persistence_set_defaultValue(defaultValue);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public String getAddressFormat() {
        return this._persistence_get_addressFormat();
    }

    public void setAddressFormat(String addressFormat) {
        this._persistence_set_addressFormat(addressFormat);
    }

    public void setModifiedDate(DateTime modifiedDate) {
        if (modifiedDate != null) {
            this._persistence_set_modifiedDate(new Timestamp(modifiedDate.getMillis()));
        } else {
            this._persistence_set_modifiedDate(null);
        }
    }

    public void setModifiedTimestamp(Timestamp modifiedDate) {
        this._persistence_set_modifiedDate(modifiedDate);
    }

    public void setValidatedDate(DateTime validatedDate) {
        if (validatedDate != null) {
            this._persistence_set_validatedDate(new Timestamp(validatedDate.getMillis()));
        } else {
            this._persistence_set_validatedDate(null);
        }
    }

    public void setValidatedTimestamp(Timestamp validatedDate) {
        this._persistence_set_validatedDate(validatedDate);
    }

    public boolean getValidated() {
        return this._persistence_get_validated();
    }

    public boolean isValidated() {
        return this._persistence_get_validated();
    }

    public void setValidated(boolean validated) {
        this._persistence_set_validated(validated);
    }

    public String getNoteMessage() {
        return this._persistence_get_noteMessage();
    }

    public void setNoteMessage(String noteMessage) {
        this._persistence_set_noteMessage(noteMessage);
    }

    public boolean getSuppressAddress() {
        return this.suppressAddress;
    }

    public void setSuppressAddress(boolean suppressAddress) {
        this.suppressAddress = suppressAddress;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EntityAddressBase(persistenceObject);
    }

    public EntityAddressBase(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "city") {
            return this.city;
        }
        if (string == "defaultValue") {
            return this.defaultValue;
        }
        if (string == "postalCode") {
            return this.postalCode;
        }
        if (string == "addressFormat") {
            return this.addressFormat;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "entityId") {
            return this.entityId;
        }
        if (string == "attentionLine") {
            return this.attentionLine;
        }
        if (string == "noteMessage") {
            return this.noteMessage;
        }
        if (string == "stateProvinceCode") {
            return this.stateProvinceCode;
        }
        if (string == "addressTypeCode") {
            return this.addressTypeCode;
        }
        if (string == "validated") {
            return this.validated;
        }
        if (string == "entityTypeCode") {
            return this.entityTypeCode;
        }
        if (string == "countryCode") {
            return this.countryCode;
        }
        if (string == "validatedDate") {
            return this.validatedDate;
        }
        if (string == "modifiedDate") {
            return this.modifiedDate;
        }
        if (string == "line3") {
            return this.line3;
        }
        if (string == "line2") {
            return this.line2;
        }
        if (string == "line1") {
            return this.line1;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "city") {
            this.city = (String)object;
            return;
        }
        if (string == "defaultValue") {
            this.defaultValue = (Boolean)object;
            return;
        }
        if (string == "postalCode") {
            this.postalCode = (String)object;
            return;
        }
        if (string == "addressFormat") {
            this.addressFormat = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "entityId") {
            this.entityId = (String)object;
            return;
        }
        if (string == "attentionLine") {
            this.attentionLine = (String)object;
            return;
        }
        if (string == "noteMessage") {
            this.noteMessage = (String)object;
            return;
        }
        if (string == "stateProvinceCode") {
            this.stateProvinceCode = (String)object;
            return;
        }
        if (string == "addressTypeCode") {
            this.addressTypeCode = (String)object;
            return;
        }
        if (string == "validated") {
            this.validated = (Boolean)object;
            return;
        }
        if (string == "entityTypeCode") {
            this.entityTypeCode = (String)object;
            return;
        }
        if (string == "countryCode") {
            this.countryCode = (String)object;
            return;
        }
        if (string == "validatedDate") {
            this.validatedDate = (Timestamp)object;
            return;
        }
        if (string == "modifiedDate") {
            this.modifiedDate = (Timestamp)object;
            return;
        }
        if (string == "line3") {
            this.line3 = (String)object;
            return;
        }
        if (string == "line2") {
            this.line2 = (String)object;
            return;
        }
        if (string == "line1") {
            this.line1 = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_city() {
        this._persistence_checkFetched("city");
        return this.city;
    }

    public void _persistence_set_city(String string) {
        this._persistence_checkFetchedForSet("city");
        this._persistence_propertyChange("city", this.city, string);
        this.city = string;
    }

    public boolean _persistence_get_defaultValue() {
        this._persistence_checkFetched("defaultValue");
        return this.defaultValue;
    }

    public void _persistence_set_defaultValue(boolean bl) {
        this._persistence_checkFetchedForSet("defaultValue");
        this._persistence_propertyChange("defaultValue", new Boolean(this.defaultValue), new Boolean(bl));
        this.defaultValue = bl;
    }

    public String _persistence_get_postalCode() {
        this._persistence_checkFetched("postalCode");
        return this.postalCode;
    }

    public void _persistence_set_postalCode(String string) {
        this._persistence_checkFetchedForSet("postalCode");
        this._persistence_propertyChange("postalCode", this.postalCode, string);
        this.postalCode = string;
    }

    public String _persistence_get_addressFormat() {
        this._persistence_checkFetched("addressFormat");
        return this.addressFormat;
    }

    public void _persistence_set_addressFormat(String string) {
        this._persistence_checkFetchedForSet("addressFormat");
        this._persistence_propertyChange("addressFormat", this.addressFormat, string);
        this.addressFormat = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_entityId() {
        this._persistence_checkFetched("entityId");
        return this.entityId;
    }

    public void _persistence_set_entityId(String string) {
        this._persistence_checkFetchedForSet("entityId");
        this._persistence_propertyChange("entityId", this.entityId, string);
        this.entityId = string;
    }

    public String _persistence_get_attentionLine() {
        this._persistence_checkFetched("attentionLine");
        return this.attentionLine;
    }

    public void _persistence_set_attentionLine(String string) {
        this._persistence_checkFetchedForSet("attentionLine");
        this._persistence_propertyChange("attentionLine", this.attentionLine, string);
        this.attentionLine = string;
    }

    public String _persistence_get_noteMessage() {
        this._persistence_checkFetched("noteMessage");
        return this.noteMessage;
    }

    public void _persistence_set_noteMessage(String string) {
        this._persistence_checkFetchedForSet("noteMessage");
        this._persistence_propertyChange("noteMessage", this.noteMessage, string);
        this.noteMessage = string;
    }

    public String _persistence_get_stateProvinceCode() {
        this._persistence_checkFetched("stateProvinceCode");
        return this.stateProvinceCode;
    }

    public void _persistence_set_stateProvinceCode(String string) {
        this._persistence_checkFetchedForSet("stateProvinceCode");
        this._persistence_propertyChange("stateProvinceCode", this.stateProvinceCode, string);
        this.stateProvinceCode = string;
    }

    public String _persistence_get_addressTypeCode() {
        this._persistence_checkFetched("addressTypeCode");
        return this.addressTypeCode;
    }

    public void _persistence_set_addressTypeCode(String string) {
        this._persistence_checkFetchedForSet("addressTypeCode");
        this._persistence_propertyChange("addressTypeCode", this.addressTypeCode, string);
        this.addressTypeCode = string;
    }

    public boolean _persistence_get_validated() {
        this._persistence_checkFetched("validated");
        return this.validated;
    }

    public void _persistence_set_validated(boolean bl) {
        this._persistence_checkFetchedForSet("validated");
        this._persistence_propertyChange("validated", new Boolean(this.validated), new Boolean(bl));
        this.validated = bl;
    }

    public String _persistence_get_entityTypeCode() {
        this._persistence_checkFetched("entityTypeCode");
        return this.entityTypeCode;
    }

    public void _persistence_set_entityTypeCode(String string) {
        this._persistence_checkFetchedForSet("entityTypeCode");
        this._persistence_propertyChange("entityTypeCode", this.entityTypeCode, string);
        this.entityTypeCode = string;
    }

    public String _persistence_get_countryCode() {
        this._persistence_checkFetched("countryCode");
        return this.countryCode;
    }

    public void _persistence_set_countryCode(String string) {
        this._persistence_checkFetchedForSet("countryCode");
        this._persistence_propertyChange("countryCode", this.countryCode, string);
        this.countryCode = string;
    }

    public Timestamp _persistence_get_validatedDate() {
        this._persistence_checkFetched("validatedDate");
        return this.validatedDate;
    }

    public void _persistence_set_validatedDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("validatedDate");
        this._persistence_propertyChange("validatedDate", this.validatedDate, timestamp);
        this.validatedDate = timestamp;
    }

    public Timestamp _persistence_get_modifiedDate() {
        this._persistence_checkFetched("modifiedDate");
        return this.modifiedDate;
    }

    public void _persistence_set_modifiedDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("modifiedDate");
        this._persistence_propertyChange("modifiedDate", this.modifiedDate, timestamp);
        this.modifiedDate = timestamp;
    }

    public String _persistence_get_line3() {
        this._persistence_checkFetched("line3");
        return this.line3;
    }

    public void _persistence_set_line3(String string) {
        this._persistence_checkFetchedForSet("line3");
        this._persistence_propertyChange("line3", this.line3, string);
        this.line3 = string;
    }

    public String _persistence_get_line2() {
        this._persistence_checkFetched("line2");
        return this.line2;
    }

    public void _persistence_set_line2(String string) {
        this._persistence_checkFetchedForSet("line2");
        this._persistence_propertyChange("line2", this.line2, string);
        this.line2 = string;
    }

    public String _persistence_get_line1() {
        this._persistence_checkFetched("line1");
        return this.line1;
    }

    public void _persistence_set_line1(String string) {
        this._persistence_checkFetchedForSet("line1");
        this._persistence_propertyChange("line1", this.line1, string);
        this.line1 = string;
    }
}

