/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.env.Environment;

public class InternalSettingsPreparer {
    private static final String[] ALLOWED_SUFFIXES = new String[]{".yml", ".yaml", ".json"};
    public static final String SECRET_PROMPT_VALUE = "${prompt.secret}";
    public static final String TEXT_PROMPT_VALUE = "${prompt.text}";

    public static Settings prepareSettings(Settings input) {
        Settings.Builder output = Settings.builder();
        InternalSettingsPreparer.initializeSettings(output, input, Collections.emptyMap());
        InternalSettingsPreparer.finalizeSettings(output, null);
        return output.build();
    }

    public static Environment prepareEnvironment(Settings input, Terminal terminal) {
        return InternalSettingsPreparer.prepareEnvironment(input, terminal, Collections.emptyMap(), null);
    }

    public static Environment prepareEnvironment(Settings input, Terminal terminal, Map<String, String> properties, Path configPath) {
        Settings.Builder output = Settings.builder();
        InternalSettingsPreparer.initializeSettings(output, input, properties);
        Environment environment = new Environment(output.build(), configPath);
        if (Files.exists(environment.configFile().resolve("elasticsearch.yaml"), new LinkOption[0])) {
            throw new SettingsException("elasticsearch.yaml was deprecated in 5.5.0 and must be renamed to elasticsearch.yml");
        }
        if (Files.exists(environment.configFile().resolve("elasticsearch.json"), new LinkOption[0])) {
            throw new SettingsException("elasticsearch.json was deprecated in 5.5.0 and must be converted to elasticsearch.yml");
        }
        output = Settings.builder();
        Path path = environment.configFile().resolve("elasticsearch.yml");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                output.loadFromPath(path);
            }
            catch (IOException e) {
                throw new SettingsException("Failed to load settings from " + path.toString(), e);
            }
        }
        InternalSettingsPreparer.initializeSettings(output, input, properties);
        InternalSettingsPreparer.finalizeSettings(output, terminal);
        environment = new Environment(output.build(), configPath);
        output.put(Environment.PATH_LOGS_SETTING.getKey(), environment.logsFile().toAbsolutePath().normalize().toString());
        return new Environment(output.build(), configPath);
    }

    static void initializeSettings(Settings.Builder output, Settings input, Map<String, String> esSettings) {
        output.put(input);
        output.putProperties(esSettings, Function.identity());
        output.replacePropertyPlaceholders();
    }

    private static void finalizeSettings(Settings.Builder output, Terminal terminal) {
        ArrayList<String> forcedSettings = new ArrayList<String>();
        for (String setting : output.keys()) {
            if (!setting.startsWith("force.")) continue;
            forcedSettings.add(setting);
        }
        for (String forcedSetting : forcedSettings) {
            String value = output.remove(forcedSetting);
            output.put(forcedSetting.substring("force.".length()), value);
        }
        output.replacePropertyPlaceholders();
        if (output.get(ClusterName.CLUSTER_NAME_SETTING.getKey()) == null) {
            output.put(ClusterName.CLUSTER_NAME_SETTING.getKey(), ClusterName.CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY).value());
        }
        InternalSettingsPreparer.replacePromptPlaceholders(output, terminal);
    }

    private static void replacePromptPlaceholders(Settings.Builder settings, Terminal terminal) {
        ArrayList<String> secretToPrompt = new ArrayList<String>();
        ArrayList<String> textToPrompt = new ArrayList<String>();
        for (String key : settings.keys()) {
            switch (settings.get(key)) {
                case "${prompt.secret}": {
                    secretToPrompt.add(key);
                    break;
                }
                case "${prompt.text}": {
                    textToPrompt.add(key);
                }
            }
        }
        for (String setting : secretToPrompt) {
            String secretValue = InternalSettingsPreparer.promptForValue(setting, terminal, true);
            if (Strings.hasLength(secretValue)) {
                settings.put(setting, secretValue);
                continue;
            }
            settings.remove(setting);
        }
        for (String setting : textToPrompt) {
            String textValue = InternalSettingsPreparer.promptForValue(setting, terminal, false);
            if (Strings.hasLength(textValue)) {
                settings.put(setting, textValue);
                continue;
            }
            settings.remove(setting);
        }
    }

    private static String promptForValue(String key, Terminal terminal, boolean secret) {
        if (terminal == null) {
            throw new UnsupportedOperationException("found property [" + key + "] with value [" + (secret ? SECRET_PROMPT_VALUE : TEXT_PROMPT_VALUE) + "]. prompting for property values is only supported when running elasticsearch in the foreground");
        }
        terminal.println(Terminal.Verbosity.SILENT, "Prompting for property values is deprecated since " + Version.V_6_3_0 + ". Some setting values can be stored in the keystore. Consult the docs for more information.");
        if (secret) {
            return new String(terminal.readSecret("Enter value for [" + key + "]: "));
        }
        return terminal.readText("Enter value for [" + key + "]: ");
    }
}

