/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document.search;

import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.principal.EntityNamePrincipalName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.krad.bo.BusinessObject;

public class DocumentSearchCriteriaBo
implements BusinessObject {
    private String documentTypeName;
    private String documentId;
    private String statusCode;
    private String applicationDocumentId;
    private String applicationDocumentStatus;
    private String title;
    private String initiatorPrincipalName;
    private String initiatorPrincipalId;
    private String viewerPrincipalName;
    private String viewerPrincipalId;
    private String groupViewerName;
    private String groupViewerId;
    private String approverPrincipalName;
    private String approverPrincipalId;
    private String routeNodeName;
    private String routeNodeLogic;
    private Timestamp dateCreated;
    private Timestamp dateLastModified;
    private Timestamp dateApproved;
    private Timestamp dateFinalized;
    private Timestamp dateApplicationDocumentStatusChanged;
    private String saveName;

    public void refresh() {
    }

    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    public void setDocumentTypeName(String documentTypeName) {
        this.documentTypeName = documentTypeName;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getApplicationDocumentId() {
        return this.applicationDocumentId;
    }

    public void setApplicationDocumentId(String applicationDocumentId) {
        this.applicationDocumentId = applicationDocumentId;
    }

    public String getApplicationDocumentStatus() {
        return this.applicationDocumentStatus;
    }

    public void setApplicationDocumentStatus(String applicationDocumentStatus) {
        this.applicationDocumentStatus = applicationDocumentStatus;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInitiatorPrincipalName() {
        return this.initiatorPrincipalName;
    }

    public void setInitiatorPrincipalName(String initiatorPrincipalName) {
        this.initiatorPrincipalName = initiatorPrincipalName;
    }

    public String getInitiatorPrincipalId() {
        return this.initiatorPrincipalId;
    }

    public void setInitiatorPrincipalId(String initiatorPrincipalId) {
        this.initiatorPrincipalId = initiatorPrincipalId;
    }

    public String getViewerPrincipalName() {
        return this.viewerPrincipalName;
    }

    public void setViewerPrincipalName(String viewerPrincipalName) {
        this.viewerPrincipalName = viewerPrincipalName;
    }

    public String getViewerPrincipalId() {
        return this.viewerPrincipalId;
    }

    public void setViewerPrincipalId(String viewerPrincipalId) {
        this.viewerPrincipalId = viewerPrincipalId;
    }

    public String getGroupViewerName() {
        return this.groupViewerName;
    }

    public void setGroupViewerName(String groupViewerName) {
        this.groupViewerName = groupViewerName;
    }

    public String getGroupViewerId() {
        return this.groupViewerId;
    }

    public void setGroupViewerId(String groupViewerId) {
        this.groupViewerId = groupViewerId;
    }

    public String getApproverPrincipalName() {
        return this.approverPrincipalName;
    }

    public void setApproverPrincipalName(String approverPrincipalName) {
        this.approverPrincipalName = approverPrincipalName;
    }

    public String getApproverPrincipalId() {
        return this.approverPrincipalId;
    }

    public void setApproverPrincipalId(String approverPrincipalId) {
        this.approverPrincipalId = approverPrincipalId;
    }

    public String getRouteNodeName() {
        return this.routeNodeName;
    }

    public void setRouteNodeName(String routeNodeName) {
        this.routeNodeName = routeNodeName;
    }

    public String getRouteNodeLogic() {
        return this.routeNodeLogic;
    }

    public void setRouteNodeLogic(String routeNodeLogic) {
        this.routeNodeLogic = routeNodeLogic;
    }

    public Timestamp getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Timestamp dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Timestamp getDateLastModified() {
        return this.dateLastModified;
    }

    public void setDateLastModified(Timestamp dateLastModified) {
        this.dateLastModified = dateLastModified;
    }

    public Timestamp getDateApproved() {
        return this.dateApproved;
    }

    public void setDateApproved(Timestamp dateApproved) {
        this.dateApproved = dateApproved;
    }

    public Timestamp getDateFinalized() {
        return this.dateFinalized;
    }

    public void setDateFinalized(Timestamp dateFinalized) {
        this.dateFinalized = dateFinalized;
    }

    public Timestamp getDateApplicationDocumentStatusChanged() {
        return this.dateApplicationDocumentStatusChanged;
    }

    public void setDateApplicationDocumentStatusChanged(Timestamp dateApplicationDocumentStatusChanged) {
        this.dateApplicationDocumentStatusChanged = dateApplicationDocumentStatusChanged;
    }

    public String getSaveName() {
        return this.saveName;
    }

    public void setSaveName(String saveName) {
        this.saveName = saveName;
    }

    public DocumentType getDocumentType() {
        if (this.documentTypeName == null) {
            return null;
        }
        return KEWServiceLocator.getDocumentTypeService().findByName(this.documentTypeName);
    }

    public Person getInitiatorPerson() {
        if (this.initiatorPrincipalId == null) {
            return null;
        }
        return KimApiServiceLocator.getPersonService().getPerson(this.initiatorPrincipalId);
    }

    public String getInitiatorDisplayName() {
        EntityNamePrincipalName entityNamePrincipalName;
        if (StringUtils.isNotBlank((String)this.initiatorPrincipalId) && (entityNamePrincipalName = KimApiServiceLocator.getIdentityService().getDefaultNamesForPrincipalId(this.initiatorPrincipalId)) != null) {
            EntityName entityName = entityNamePrincipalName.getDefaultName();
            return entityName == null ? this.initiatorPrincipalId : entityName.getCompositeName();
        }
        return this.initiatorPrincipalId;
    }

    public Person getApproverPerson() {
        if (this.approverPrincipalName == null) {
            return null;
        }
        return KimApiServiceLocator.getPersonService().getPersonByPrincipalName(this.approverPrincipalName);
    }

    public Person getViewerPerson() {
        if (this.viewerPrincipalName == null) {
            return null;
        }
        return KimApiServiceLocator.getPersonService().getPersonByPrincipalName(this.viewerPrincipalName);
    }

    public GroupBo getGroupViewer() {
        if (this.groupViewerId == null) {
            return null;
        }
        Group grp = KimApiServiceLocator.getGroupService().getGroup(this.groupViewerId);
        if (null != grp) {
            return GroupBo.from((Group)grp);
        }
        return null;
    }

    public String getStatusLabel() {
        if (this.statusCode == null) {
            return "";
        }
        return DocumentStatus.fromCode((String)this.statusCode).getLabel();
    }

    public String getDocumentTypeLabel() {
        DocumentType documentType = this.getDocumentType();
        if (documentType != null) {
            return documentType.getLabel();
        }
        return "";
    }

    public String getRouteLog() {
        return "<img alt=\"Route Log for Document\" src=\"images/my_route_log.gif\"/>";
    }

    public void populateFromDocumentSearchResult(DocumentSearchResult result) {
        Document document = result.getDocument();
        this.documentTypeName = document.getDocumentTypeName();
        this.documentId = document.getDocumentId();
        this.statusCode = document.getStatus().getCode();
        this.applicationDocumentId = document.getApplicationDocumentId();
        this.applicationDocumentStatus = document.getApplicationDocumentStatus();
        this.title = document.getTitle();
        this.initiatorPrincipalName = this.principalIdToName(document.getInitiatorPrincipalId());
        this.initiatorPrincipalId = document.getInitiatorPrincipalId();
        this.dateCreated = new Timestamp(document.getDateCreated().getMillis());
    }

    private String principalIdToName(String principalId) {
        Principal principal;
        if (StringUtils.isNotBlank((String)principalId) && (principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId)) != null) {
            return principal.getPrincipalName();
        }
        return principalId;
    }
}

