/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.notification.impl.rule;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.bo.NotificationTypeRecipient;
import org.kuali.coeus.common.notification.impl.rule.event.AddNotificationRecipientEvent;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class AddNotificationRecipientRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<AddNotificationRecipientEvent> {
    private static final String FULL_NAME_FIELD = "fullName";

    @Override
    public boolean processRules(AddNotificationRecipientEvent addNotificationRecipientEvent) {
        boolean rulePassed = true;
        NotificationTypeRecipient notificationTypeRecipient = addNotificationRecipientEvent.getNotificationTypeRecipient();
        List<NotificationTypeRecipient> notificationTypeRecipients = addNotificationRecipientEvent.getNotificationTypeRecipients();
        this.getDictionaryValidationService().validateBusinessObject((Object)notificationTypeRecipient);
        rulePassed &= GlobalVariables.getMessageMap().hasNoErrors();
        rulePassed &= this.validateRecipient(notificationTypeRecipient);
        return rulePassed &= this.validateUniqueRecipients(notificationTypeRecipient, notificationTypeRecipients);
    }

    private boolean validateRecipient(NotificationTypeRecipient notificationTypeRecipient) {
        boolean isValid = true;
        if (StringUtils.isBlank((CharSequence)notificationTypeRecipient.getRoleName()) && StringUtils.isBlank((CharSequence)notificationTypeRecipient.getPersonId()) && StringUtils.isBlank((CharSequence)notificationTypeRecipient.getRolodexId())) {
            isValid = false;
            this.reportError(FULL_NAME_FIELD, "error.notification.empty.notifcation.recipient", new String[0]);
        }
        return isValid;
    }

    private boolean validateUniqueRecipients(NotificationTypeRecipient newNotificationTypeRecipient, List<NotificationTypeRecipient> existingNotificationTypeRecipients) {
        boolean isValid = true;
        for (NotificationTypeRecipient existingNotificationTypeRecipient : existingNotificationTypeRecipients) {
            if (!AddNotificationRecipientRule.isIdentifierEqual(newNotificationTypeRecipient.getRoleName(), existingNotificationTypeRecipient.getRoleName()) && !AddNotificationRecipientRule.isIdentifierEqual(newNotificationTypeRecipient.getPersonId(), existingNotificationTypeRecipient.getPersonId()) && !AddNotificationRecipientRule.isIdentifierEqual(newNotificationTypeRecipient.getRolodexId(), existingNotificationTypeRecipient.getRolodexId())) continue;
            isValid = false;
            this.reportError(FULL_NAME_FIELD, "error.notification.duplicate.notification.recipient", new String[0]);
        }
        return isValid;
    }

    private static boolean isIdentifierEqual(String newIdentifier, String existingIdentifier) {
        return (StringUtils.isNotBlank((CharSequence)newIdentifier) || StringUtils.isNotBlank((CharSequence)existingIdentifier)) && StringUtils.equals((CharSequence)newIdentifier, (CharSequence)existingIdentifier);
    }
}

