/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.ImpliedForeignKeyConstraint;
import net.sourceforge.schemaspy.model.RailsForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.Inflection;

public class DbAnalyzer {
    public static List<ImpliedForeignKeyConstraint> getImpliedConstraints(Collection<Table> collection) {
        Object object;
        Object object2;
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        TreeMap<TableColumn, Table> treeMap = new TreeMap<TableColumn, Table>(new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
                int n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
                if (n == 0) {
                    n = tableColumn.getType() != null && tableColumn2.getType() != null ? tableColumn.getType().compareTo(tableColumn2.getType()) : tableColumn.getTypeName().compareToIgnoreCase(tableColumn2.getTypeName());
                }
                if (n == 0) {
                    n = tableColumn.getLength() - tableColumn2.getLength();
                }
                return n;
            }
        });
        int n = 0;
        for (Table object3 : collection) {
            List<TableColumn> list = object3.getPrimaryColumns();
            if (list.size() == 1 && ((TableColumn)(object2 = list.get(0))).allowsImpliedChildren()) {
                object = (Table)treeMap.get(object2);
                if (object == null) {
                    treeMap.put((TableColumn)object2, object3);
                } else {
                    ++n;
                    TableColumn tableColumn = ((Table)object).getPrimaryColumns().get(0);
                    if (((TableColumn)object2).getChildren().size() > tableColumn.getChildren().size()) {
                        treeMap.put((TableColumn)object2, object3);
                    }
                }
            }
            object2 = object3.getColumns().iterator();
            while (object2.hasNext()) {
                object = (TableColumn)object2.next();
                if (((TableColumn)object).isForeignKey() || !((TableColumn)object).allowsImpliedParents()) continue;
                arrayList.add((TableColumn)object);
            }
        }
        if (n > treeMap.size()) {
            return new ArrayList<ImpliedForeignKeyConstraint>();
        }
        DbAnalyzer.sortColumnsByTable(arrayList);
        ArrayList arrayList2 = new ArrayList();
        for (TableColumn tableColumn : arrayList) {
            object2 = (Table)treeMap.get(tableColumn);
            if (object2 == null || object2 == tableColumn.getTable() || ((TableColumn)(object = ((Table)object2).getColumn(tableColumn.getName()))).getParentConstraint(tableColumn) != null) continue;
            arrayList2.add(new ImpliedForeignKeyConstraint((TableColumn)object, tableColumn));
        }
        return arrayList2;
    }

    public static List<RailsForeignKeyConstraint> getRailsConstraints(Map<String, Table> map) {
        ArrayList<RailsForeignKeyConstraint> arrayList = new ArrayList<RailsForeignKeyConstraint>(map.size());
        for (Table table : map.values()) {
            for (TableColumn tableColumn : table.getColumns()) {
                TableColumn tableColumn2;
                String string;
                String string2;
                Table table2;
                String string3 = tableColumn.getName().toLowerCase();
                if (tableColumn.isForeignKey() || !tableColumn.allowsImpliedParents() || !string3.endsWith("_id") || (table2 = map.get(string2 = Inflection.pluralize(string = string3.substring(0, string3.length() - 3)))) == null || (tableColumn2 = table2.getColumn("ID")) == null) continue;
                arrayList.add(new RailsForeignKeyConstraint(tableColumn2, tableColumn));
            }
        }
        return arrayList;
    }

    public static List<ForeignKeyConstraint> getForeignKeyConstraints(Collection<Table> collection) {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Table table : collection) {
            arrayList.addAll(table.getForeignKeys());
        }
        return arrayList;
    }

    public static List<Table> getOrphans(Collection<Table> collection) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Table table : collection) {
            if (!table.isOrphan(false)) continue;
            arrayList.add(table);
        }
        return DbAnalyzer.sortTablesByName(arrayList);
    }

    public static List<Table> getTablesWithoutIndexes(Collection<Table> collection) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Table table : collection) {
            if (table.getIndexes().size() != 0 || table.isView() || table.isLogical()) continue;
            arrayList.add(table);
        }
        return DbAnalyzer.sortTablesByName(arrayList);
    }

    public static List<Table> getTablesWithIncrementingColumnNames(Collection<Table> collection) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        block0: for (Table table : collection) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (TableColumn tableColumn : table.getColumns()) {
                Object object = tableColumn.getName();
                Object object2 = null;
                for (int i = ((String)object).length() - 1; i > 0 && Character.isDigit(((String)object).charAt(i)); --i) {
                    object2 = String.valueOf(((String)object).charAt(i)) + (String)(object2 == null ? "" : object2);
                }
                if (object2 == null) {
                    object2 = "1";
                    object = (String)object + (String)object2;
                }
                String string = ((String)object).substring(0, ((String)object).length() - ((String)object2).length());
                long l = Long.parseLong((String)object2);
                Long l2 = (Long)hashMap.get(string);
                if (l2 != null && Math.abs(l2 - l) == 1L) {
                    arrayList.add(table);
                    continue block0;
                }
                hashMap.put(string, new Long(l));
            }
        }
        return DbAnalyzer.sortTablesByName(arrayList);
    }

    public static List<Table> getTablesWithOneColumn(Collection<Table> collection) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Table table : collection) {
            if (table.getColumns().size() != 1) continue;
            arrayList.add(table);
        }
        return DbAnalyzer.sortTablesByName(arrayList);
    }

    public static List<Table> sortTablesByName(List<Table> list) {
        Collections.sort(list, new Comparator<Table>(){

            @Override
            public int compare(Table table, Table table2) {
                return table.compareTo(table2);
            }
        });
        return list;
    }

    public static List<TableColumn> sortColumnsByTable(List<TableColumn> list) {
        Collections.sort(list, new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
                int n = tableColumn.getTable().compareTo(tableColumn2.getTable());
                if (n == 0) {
                    n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
                }
                return n;
            }
        });
        return list;
    }

    public static List<TableColumn> getDefaultNullStringColumns(Collection<Table> collection) {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        for (Table table : collection) {
            for (TableColumn tableColumn : table.getColumns()) {
                String string;
                Object object = tableColumn.getDefaultValue();
                if (object == null || !(object instanceof String) || !(string = object.toString()).trim().equalsIgnoreCase("'null'")) continue;
                arrayList.add(tableColumn);
            }
        }
        return DbAnalyzer.sortColumnsByTable(arrayList);
    }

    public static List<String> getCatalogs(DatabaseMetaData databaseMetaData) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = databaseMetaData.getCatalogs();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString("TABLE_CAT"));
        }
        resultSet.close();
        return arrayList;
    }

    public static List<String> getSchemas(DatabaseMetaData databaseMetaData) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = databaseMetaData.getSchemas();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString("TABLE_SCHEM"));
        }
        resultSet.close();
        return arrayList;
    }

    public static List<String> getPopulatedSchemas(DatabaseMetaData databaseMetaData) throws SQLException {
        return DbAnalyzer.getPopulatedSchemas(databaseMetaData, ".*", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPopulatedSchemas(DatabaseMetaData databaseMetaData, String string, boolean bl) throws SQLException {
        TreeSet<String> treeSet = new TreeSet<String>();
        Pattern pattern = Pattern.compile(string);
        Logger logger = Logger.getLogger(DbAnalyzer.class.getName());
        boolean bl2 = logger.isLoggable(Level.FINE);
        for (String string2 : bl ? DbAnalyzer.getCatalogs(databaseMetaData) : DbAnalyzer.getSchemas(databaseMetaData)) {
            if (pattern.matcher(string2).matches()) {
                ResultSet resultSet = null;
                try {
                    resultSet = databaseMetaData.getTables(null, string2, "%", null);
                    if (resultSet.next()) {
                        if (bl2) {
                            logger.fine("Including schema " + string2 + ": matches + \"" + pattern + "\" and contains tables");
                        }
                        treeSet.add(string2);
                        continue;
                    }
                    if (!bl2) continue;
                    logger.fine("Excluding schema " + string2 + ": matches \"" + pattern + "\" but contains no tables");
                }
                catch (SQLException sQLException) {}
                continue;
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    continue;
                }
            }
            if (!bl2) continue;
            logger.fine("Excluding schema " + string2 + ": doesn't match \"" + pattern + "\"");
        }
        return new ArrayList<String>(treeSet);
    }

    public static void dumpResultSetRow(ResultSet resultSet, String string) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        System.out.println(n + " columns of " + string + ":");
        for (int i = 1; i <= n; ++i) {
            System.out.print(resultSetMetaData.getColumnLabel(i));
            System.out.print(": ");
            System.out.print(String.valueOf(resultSet.getString(i)));
            System.out.print("\t");
        }
        System.out.println();
    }
}

