/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ClassString;
import freemarker.ext.beans.MethodUtilities;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

abstract class OverloadedMethodsSubset {
    static final Object NO_SUCH_METHOD = new Object();
    static final Object AMBIGUOUS_METHOD = new Object();
    static final Object[] EMPTY_ARGS = new Object[0];
    private Class[][] unwrappingArgTypesByArgCount;
    private final Map selectorCache = new HashMap();
    private final List members = new LinkedList();
    private final Map signatures = new HashMap();

    OverloadedMethodsSubset() {
    }

    void addMember(Member member) {
        this.members.add(member);
        Class[] argTypes = MethodUtilities.getParameterTypes(member);
        int argCount = argTypes.length;
        this.signatures.put(member, argTypes.clone());
        this.onAddSignature(member, argTypes);
        if (this.unwrappingArgTypesByArgCount == null) {
            this.unwrappingArgTypesByArgCount = new Class[argCount + 1][];
            this.unwrappingArgTypesByArgCount[argCount] = argTypes;
        } else if (this.unwrappingArgTypesByArgCount.length <= argCount) {
            Class[][] newUnwrappingArgTypesByArgCount = new Class[argCount + 1][];
            System.arraycopy(this.unwrappingArgTypesByArgCount, 0, newUnwrappingArgTypesByArgCount, 0, this.unwrappingArgTypesByArgCount.length);
            this.unwrappingArgTypesByArgCount = newUnwrappingArgTypesByArgCount;
            this.unwrappingArgTypesByArgCount[argCount] = argTypes;
        } else {
            Class[] oldUnwrappingArgTypes = this.unwrappingArgTypesByArgCount[argCount];
            if (oldUnwrappingArgTypes == null) {
                this.unwrappingArgTypesByArgCount[argCount] = argTypes;
            } else {
                for (int i = 0; i < oldUnwrappingArgTypes.length; ++i) {
                    oldUnwrappingArgTypes[i] = MethodUtilities.getMostSpecificCommonType(oldUnwrappingArgTypes[i], argTypes[i]);
                }
            }
        }
        this.updateSignature(argCount);
        this.afterSignatureAdded(argCount);
    }

    Class[] getSignature(Member member) {
        return (Class[])this.signatures.get(member);
    }

    Class[][] getUnwrappingArgTypesByArgCount() {
        return this.unwrappingArgTypesByArgCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getMemberForArgs(Object[] args, boolean varArg) {
        Object objMember;
        ClassString argTypes = new ClassString(args);
        Map map = this.selectorCache;
        synchronized (map) {
            objMember = this.selectorCache.get(argTypes);
            if (objMember == null) {
                objMember = argTypes.getMostSpecific(this.members, varArg);
                this.selectorCache.put(argTypes, objMember);
            }
        }
        return objMember;
    }

    Iterator getMembers() {
        return this.members.iterator();
    }

    abstract void onAddSignature(Member var1, Class[] var2);

    abstract void updateSignature(int var1);

    abstract void afterSignatureAdded(int var1);

    abstract Object getMemberAndArguments(List var1, BeansWrapper var2) throws TemplateModelException;
}

