/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.mo.ModelBuilder;

public class BuilderUtils {
    private static final String COULDNT_INVOKE_BUILDER_CREATE = "couldn't invoke Builder.create()";

    public static <B> List<B> convertFromBuilderList(List<? extends ModelBuilder> toConvert) {
        if (CollectionUtils.isEmpty(toConvert)) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>(toConvert.size());
        for (ModelBuilder modelBuilder : toConvert) {
            results.add(modelBuilder.build());
        }
        return Collections.unmodifiableList(results);
    }

    public static <B> Set<B> convertFromBuilderSet(Set<? extends ModelBuilder> toConvert) {
        if (CollectionUtils.isEmpty(toConvert)) {
            return Collections.emptySet();
        }
        HashSet<Object> results = new HashSet<Object>(toConvert.size());
        for (ModelBuilder modelBuilder : toConvert) {
            results.add(modelBuilder.build());
        }
        return Collections.unmodifiableSet(results);
    }

    public static <A, B> List<B> transform(List<? extends A> toConvert, Transformer<A, B> xform) {
        if (CollectionUtils.isEmpty(toConvert)) {
            return new ArrayList();
        }
        ArrayList<B> results = new ArrayList<B>(toConvert.size());
        for (A elem : toConvert) {
            results.add(xform.transform(elem));
        }
        return results;
    }

    public static <A, B> Set<B> transform(Set<? extends A> toConvert, Transformer<A, B> xform) {
        if (CollectionUtils.isEmpty(toConvert)) {
            return new HashSet();
        }
        HashSet<B> results = new HashSet<B>(toConvert.size());
        for (A elem : toConvert) {
            results.add(xform.transform(elem));
        }
        return results;
    }

    public static interface Transformer<A, B> {
        public B transform(A var1);
    }
}

