/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.lock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.lock.ProposalLockService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.impl.PessimisticLockServiceImpl;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalLockService")
public class ProposalLockServiceImpl
extends PessimisticLockServiceImpl
implements ProposalLockService {
    private static final String FALSE = "FALSE";
    private static final String ADD_BUDGET = "addBudget";
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Autowired
    @Qualifier(value="dataDictionaryService")
    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        super.setDataDictionaryService(dataDictionaryService);
    }

    @Autowired
    @Qualifier(value="dataObjectService")
    public void setDataObjectService(DataObjectService dataObjectService) {
        super.setDataObjectService(dataObjectService);
    }

    @Override
    public boolean hasPersonnelLock(String documentNumber, Integer personNumber) {
        return this.getPessimisticLocksForDocument(documentNumber).stream().map(PessimisticLock::getLockDescriptor).map(PERSONNEL_LOCK_PATTERN::matcher).filter(Matcher::matches).filter(matcher -> matcher.groupCount() > 0).anyMatch(matcher -> StringUtils.equals((CharSequence)matcher.group(1), (CharSequence)String.valueOf(personNumber)));
    }

    @Override
    public List<PessimisticLock> getPersonnelLocks(String documentNumber) {
        return this.getPessimisticLocksForDocument(documentNumber).stream().filter(lock -> StringUtils.contains((CharSequence)lock.getLockDescriptor(), (CharSequence)"PROPOSAL DEVELOPMENT PERSONNEL")).collect(Collectors.toList());
    }

    @Override
    public PessimisticLock generatePersonnelLock(Document document, Integer personNumber) {
        PessimisticLock newLock = this.generateNewLock(document.getDocumentNumber(), document.getDocumentNumber() + "-PROPOSAL DEVELOPMENT PERSONNEL|" + personNumber);
        document.refreshPessimisticLocks();
        return newLock;
    }

    protected boolean isLockRequiredByUser(Document document, Map editMode, Person user) {
        String activeLockRegion = (String)this.globalVariableService.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        for (Map.Entry entry : editMode.entrySet()) {
            if (!this.isEntryEditMode(entry) || !StringUtils.isNotEmpty((CharSequence)activeLockRegion)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEntryEditMode(Map.Entry entry) {
        if ("fullEntry".equals(entry.getKey()) || "addNarratives".equals(entry.getKey()) || "modifyPermissions".equals(entry.getKey()) || "modifyProposal".equals(entry.getKey()) || "modifyBudgets".equals(entry.getKey()) || ADD_BUDGET.equals(entry.getKey())) {
            String fullEntryEditModeValue = (String)entry.getValue();
            return ObjectUtils.isNotNull((Object)fullEntryEditModeValue) && StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)fullEntryEditModeValue);
        }
        return false;
    }

    protected Map getEditModeWithEditableModesRemoved(Map currentEditMode) {
        HashMap editModeMap = new HashMap();
        for (Map.Entry entry : editModeMap.entrySet()) {
            if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)ADD_BUDGET)) continue;
            entry.setValue(FALSE);
        }
        return editModeMap;
    }

    protected PessimisticLock createNewPessimisticLock(Document document, Map editMode, Person user) {
        if (document.useCustomLockDescriptors()) {
            String lockDescriptor = document.getCustomLockDescriptor(user);
            ProposalDevelopmentDocument pdDocument = (ProposalDevelopmentDocument)document;
            if (StringUtils.isNotEmpty((CharSequence)lockDescriptor) && lockDescriptor.contains("BUDGET")) {
                for (ProposalDevelopmentBudgetExt budgetOverview : pdDocument.getDevelopmentProposal().getBudgets()) {
                    this.generateNewLock(budgetOverview.getDocumentNumber(), lockDescriptor, user);
                }
            }
            return this.generateNewLock(document.getDocumentNumber(), lockDescriptor, user);
        }
        return this.generateNewLock(document.getDocumentNumber(), user);
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

