/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.scheduling.seq;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.kuali.coeus.sys.framework.scheduling.seq.ScheduleSequence;
import org.kuali.coeus.sys.framework.scheduling.seq.ScheduleSequenceDecorator;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class XMonthlyScheduleSequenceDecorator
extends ScheduleSequenceDecorator {
    private Integer frequency;

    public XMonthlyScheduleSequenceDecorator(ScheduleSequence scheduleSequence, Integer frequency) {
        super(scheduleSequence);
        this.frequency = frequency;
    }

    @Override
    public List<Date> executeScheduleSequence(String expression, Date startDate, Date endDate) throws ParseException {
        CronTriggerImpl ct = new CronTriggerImpl("t", "g", "j", "g", new Date(), null, expression);
        ct.setTimeZone(TimeZone.getDefault());
        ArrayList<Date> dates = TriggerUtils.computeFireTimesBetween((OperableTrigger)ct, null, (Date)startDate, (Date)endDate);
        if (this.frequency != 1) {
            ArrayList<Date> filteredDates = new ArrayList<Date>();
            int i = 0;
            for (Date date : dates) {
                if (i % this.frequency == 0) {
                    filteredDates.add(date);
                }
                ++i;
            }
            dates = filteredDates;
        }
        return dates;
    }
}

