/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import com.codiform.moo.TranslationException;
import com.codiform.moo.TranslationInitializationException;
import com.codiform.moo.translator.TranslationTargetFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DefaultMapTargetFactory
implements TranslationTargetFactory {
    @Override
    public <T> T getTranslationTargetInstance(Object source, Class<T> targetType) {
        Class<T> type = this.getDefaultTypeForTarget(targetType);
        if (type == null) {
            throw new TranslationException("Cannot determine default collection type for type: " + targetType);
        }
        return this.construct(type);
    }

    private <T> Class<? extends T> getDefaultTypeForTarget(Class<T> target) {
        if (target.isInterface()) {
            if (SortedMap.class.equals(target)) {
                return TreeMap.class;
            }
            if (Map.class.equals(target)) {
                return HashMap.class;
            }
            return null;
        }
        if (Map.class.isAssignableFrom(target)) {
            return target;
        }
        return null;
    }

    private <T> T construct(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            throw new TranslationInitializationException("No no-argument constructor in class " + type.getName(), exception);
        }
        catch (InstantiationException exception) {
            throw new TranslationInitializationException(String.format("Error while instantiating %s", type), exception);
        }
        catch (IllegalAccessException exception) {
            throw new TranslationInitializationException(String.format("Not allowed to instantiate %s", type), exception);
        }
        catch (IllegalArgumentException exception) {
            throw new TranslationInitializationException(String.format("Error while instantiating %s", type), exception);
        }
        catch (InvocationTargetException exception) {
            throw new TranslationInitializationException(String.format("Error thrown by constructor of %s", type), exception);
        }
    }
}

