/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.model.xml.TableColumnMeta;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TableMeta {
    private final String name;
    private final String comments;
    private final List<TableColumnMeta> columns = new ArrayList<TableColumnMeta>();
    private final String remoteCatalog;
    private final String remoteSchema;
    private static final Logger logger = Logger.getLogger(TableMeta.class.getName());

    TableMeta(Node node) {
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.name = namedNodeMap.getNamedItem("name").getNodeValue();
        Node node2 = namedNodeMap.getNamedItem("comments");
        if (node2 == null) {
            node2 = namedNodeMap.getNamedItem("remarks");
        }
        this.comments = node2 != null ? (((String)(object = node2.getNodeValue().trim())).length() == 0 ? null : object) : null;
        node2 = namedNodeMap.getNamedItem("remoteSchema");
        this.remoteSchema = node2 == null ? null : node2.getNodeValue().trim();
        node2 = namedNodeMap.getNamedItem("remoteCatalog");
        this.remoteCatalog = node2 == null ? null : node2.getNodeValue().trim();
        logger.fine("Found XML table metadata for " + this.name + " remoteCatalog: " + this.remoteCatalog + " remoteSchema: " + this.remoteSchema + " comments: " + this.comments);
        object = ((Element)((Object)node.getChildNodes())).getElementsByTagName("column");
        for (int i = 0; i < object.getLength(); ++i) {
            Node node3 = object.item(i);
            this.columns.add(new TableColumnMeta(node3));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getComments() {
        return this.comments;
    }

    public List<TableColumnMeta> getColumns() {
        return this.columns;
    }

    public String getRemoteCatalog() {
        return this.remoteCatalog;
    }

    public String getRemoteSchema() {
        return this.remoteSchema;
    }
}

