/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeAttributeContract;
import org.kuali.rice.kim.api.type.KimTypeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="kimType")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KimTypeType", propOrder={"id", "serviceName", "namespaceCode", "name", "attributeDefinitions", "active", "versionNumber", "objectId", "_futureElements"})
public final class KimType
extends AbstractDataTransferObject
implements KimTypeContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="serviceName", required=false)
    private final String serviceName;
    @XmlElement(name="namespaceCode", required=false)
    private final String namespaceCode;
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElementWrapper(name="attributeDefinitions", required=false)
    @XmlElement(name="attributeDefinition", required=false)
    private final List<KimTypeAttribute> attributeDefinitions;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KimType() {
        this.id = null;
        this.serviceName = null;
        this.namespaceCode = null;
        this.name = null;
        this.attributeDefinitions = Collections.emptyList();
        this.active = false;
        this.versionNumber = 1L;
        this.objectId = null;
    }

    private KimType(Builder builder) {
        this.id = builder.getId();
        this.serviceName = builder.getServiceName();
        this.namespaceCode = builder.getNamespaceCode();
        this.name = builder.getName();
        ArrayList<KimTypeAttribute> temp = new ArrayList<KimTypeAttribute>();
        for (KimTypeAttribute.Builder attr : builder.getAttributeDefinitions()) {
            attr.setKimTypeId(this.id);
            temp.add(attr.build());
        }
        this.attributeDefinitions = Collections.unmodifiableList(temp);
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public KimTypeAttribute getAttributeDefinitionById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is blank");
        }
        if (this.attributeDefinitions != null) {
            for (KimTypeAttribute att : this.attributeDefinitions) {
                if (att == null || att.getKimAttribute() == null || !id.equals(att.getKimAttribute().getId())) continue;
                return att;
            }
        }
        return null;
    }

    public KimTypeAttribute getAttributeDefinitionByName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        if (this.attributeDefinitions != null) {
            for (KimTypeAttribute att : this.attributeDefinitions) {
                if (att == null || att.getKimAttribute() == null || !name.equals(att.getKimAttribute().getAttributeName())) continue;
                return att;
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<KimTypeAttribute> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/KimTypeType";
    }

    static class Elements {
        static final String ID = "id";
        static final String SERVICE_NAME = "serviceName";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String NAME = "name";
        static final String ATTRIBUTE_DEFNS = "attributeDefinitions";
        static final String ATTRIBUTE_DEFN = "attributeDefinition";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "kimType";
        static final String TYPE_NAME = "KimTypeType";

        Constants() {
        }
    }

    public static final class Builder
    implements KimTypeContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String serviceName;
        private String namespaceCode;
        private String name;
        private List<KimTypeAttribute.Builder> attributeDefinitions = new ArrayList<KimTypeAttribute.Builder>();
        private boolean active;
        private Long versionNumber;
        private String objectId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(KimTypeContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = new Builder();
            builder.setId(contract.getId());
            builder.setServiceName(contract.getServiceName());
            builder.setNamespaceCode(contract.getNamespaceCode());
            builder.setName(contract.getName());
            if (contract.getAttributeDefinitions() != null) {
                ArrayList<KimTypeAttribute.Builder> temp = new ArrayList<KimTypeAttribute.Builder>();
                for (KimTypeAttributeContract kimTypeAttributeContract : contract.getAttributeDefinitions()) {
                    if (kimTypeAttributeContract == null) continue;
                    temp.add(KimTypeAttribute.Builder.create(kimTypeAttributeContract));
                }
                builder.setAttributeDefinitions(Collections.unmodifiableList(temp));
            }
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        public void setNamespaceCode(String namespaceCode) {
            this.namespaceCode = namespaceCode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<KimTypeAttribute.Builder> getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        public void setAttributeDefinitions(List<KimTypeAttribute.Builder> attributeDefinitions) {
            if (attributeDefinitions == null) {
                throw new IllegalArgumentException("attributeDefinitions is null");
            }
            this.attributeDefinitions = attributeDefinitions;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public KimType build() {
            return new KimType(this);
        }
    }
}

