/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DataBufferWrapper;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.buffer.LimitedDataBufferList;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public final class StringDecoder
extends AbstractDataBufferDecoder<String> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final List<String> DEFAULT_DELIMITERS = Arrays.asList("\r\n", "\n");
    private final List<String> delimiters;
    private final boolean stripDelimiter;
    private final ConcurrentMap<Charset, byte[][]> delimitersCache = new ConcurrentHashMap<Charset, byte[][]>();

    private StringDecoder(List<String> delimiters, boolean stripDelimiter, MimeType ... mimeTypes) {
        super(mimeTypes);
        Assert.notEmpty(delimiters, "'delimiters' must not be empty");
        this.delimiters = new ArrayList<String>(delimiters);
        this.stripDelimiter = stripDelimiter;
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return elementType.resolve() == String.class && super.canDecode(elementType, mimeType);
    }

    @Override
    public Flux<String> decode(Publisher<DataBuffer> input, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        byte[][] delimiterBytes = this.getDelimiterBytes(mimeType);
        Flux inputFlux = Flux.defer(() -> {
            DataBufferUtils.Matcher matcher = DataBufferUtils.matcher(delimiterBytes);
            if (this.getMaxInMemorySize() != -1) {
                LimitedDataBufferList limiter = new LimitedDataBufferList(this.getMaxInMemorySize());
                return Flux.from((Publisher)input).concatMapIterable(buffer -> StringDecoder.endFrameAfterDelimiter(buffer, matcher, limiter)).bufferUntil(buffer -> buffer instanceof EndFrameBuffer).map(buffers -> StringDecoder.joinAndStrip(buffers, this.stripDelimiter)).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release);
            }
            ConcatMapIterableDiscardWorkaroundCache cache = new ConcatMapIterableDiscardWorkaroundCache();
            return Flux.from((Publisher)input).concatMapIterable(buffer -> cache.addAll(StringDecoder.endFrameAfterDelimiter(buffer, matcher, null))).doOnNext((Consumer)cache).doOnCancel((Runnable)cache).bufferUntil(buffer -> buffer instanceof EndFrameBuffer).map(buffers -> StringDecoder.joinAndStrip(buffers, this.stripDelimiter)).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release);
        });
        return super.decode((Publisher<DataBuffer>)inputFlux, elementType, mimeType, hints);
    }

    private byte[][] getDelimiterBytes(@Nullable MimeType mimeType) {
        return this.delimitersCache.computeIfAbsent(StringDecoder.getCharset(mimeType), charset -> {
            byte[][] result = new byte[this.delimiters.size()][];
            for (int i = 0; i < this.delimiters.size(); ++i) {
                result[i] = this.delimiters.get(i).getBytes((Charset)charset);
            }
            return result;
        });
    }

    @Override
    public String decode(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Charset charset = StringDecoder.getCharset(mimeType);
        CharBuffer charBuffer = charset.decode(dataBuffer.asByteBuffer());
        DataBufferUtils.release(dataBuffer);
        String value = charBuffer.toString();
        LogFormatUtils.traceDebug(this.logger, traceOn -> {
            String formatted = LogFormatUtils.formatValue(value, traceOn == false);
            return Hints.getLogPrefix(hints) + "Decoded " + formatted;
        });
        return value;
    }

    private static Charset getCharset(@Nullable MimeType mimeType) {
        if (mimeType != null && mimeType.getCharset() != null) {
            return mimeType.getCharset();
        }
        return DEFAULT_CHARSET;
    }

    private static List<DataBuffer> endFrameAfterDelimiter(DataBuffer dataBuffer, DataBufferUtils.Matcher matcher, @Nullable LimitedDataBufferList limiter) {
        ArrayList<DataBuffer> result = new ArrayList<DataBuffer>();
        try {
            do {
                int endIdx;
                if ((endIdx = matcher.match(dataBuffer)) != -1) {
                    int readPosition = dataBuffer.readPosition();
                    int length = endIdx - readPosition + 1;
                    DataBuffer slice = dataBuffer.retainedSlice(readPosition, length);
                    result.add(slice);
                    result.add(new EndFrameBuffer(matcher.delimiter()));
                    dataBuffer.readPosition(endIdx + 1);
                    if (limiter == null) continue;
                    limiter.add(slice);
                    limiter.clear();
                    continue;
                }
                result.add(DataBufferUtils.retain(dataBuffer));
                if (limiter != null) {
                    limiter.add(dataBuffer);
                }
                break;
            } while (dataBuffer.readableByteCount() > 0);
        }
        catch (DataBufferLimitException ex) {
            if (limiter != null) {
                limiter.releaseAndClear();
            }
            throw ex;
        }
        finally {
            DataBufferUtils.release(dataBuffer);
        }
        return result;
    }

    private static DataBuffer joinAndStrip(List<DataBuffer> dataBuffers, boolean stripDelimiter) {
        Assert.state(!dataBuffers.isEmpty(), "DataBuffers should not be empty");
        byte[] matchingDelimiter = null;
        int lastIdx = dataBuffers.size() - 1;
        DataBuffer lastBuffer = dataBuffers.get(lastIdx);
        if (lastBuffer instanceof EndFrameBuffer) {
            matchingDelimiter = ((EndFrameBuffer)lastBuffer).delimiter();
            dataBuffers.remove(lastIdx);
        }
        DataBuffer result = dataBuffers.get(0).factory().join(dataBuffers);
        if (stripDelimiter && matchingDelimiter != null) {
            result.writePosition(result.writePosition() - matchingDelimiter.length);
        }
        return result;
    }

    @Deprecated
    public static StringDecoder textPlainOnly(boolean ignored) {
        return StringDecoder.textPlainOnly();
    }

    public static StringDecoder textPlainOnly() {
        return StringDecoder.textPlainOnly(DEFAULT_DELIMITERS, true);
    }

    public static StringDecoder textPlainOnly(List<String> delimiters, boolean stripDelimiter) {
        return new StringDecoder(delimiters, stripDelimiter, new MimeType("text", "plain", DEFAULT_CHARSET));
    }

    @Deprecated
    public static StringDecoder allMimeTypes(boolean ignored) {
        return StringDecoder.allMimeTypes();
    }

    public static StringDecoder allMimeTypes() {
        return StringDecoder.allMimeTypes(DEFAULT_DELIMITERS, true);
    }

    public static StringDecoder allMimeTypes(List<String> delimiters, boolean stripDelimiter) {
        return new StringDecoder(delimiters, stripDelimiter, new MimeType("text", "plain", DEFAULT_CHARSET), MimeTypeUtils.ALL);
    }

    private class ConcatMapIterableDiscardWorkaroundCache
    implements Consumer<DataBuffer>,
    Runnable {
        private final List<DataBuffer> buffers = new ArrayList<DataBuffer>();

        private ConcatMapIterableDiscardWorkaroundCache() {
        }

        public List<DataBuffer> addAll(List<DataBuffer> buffersToAdd) {
            this.buffers.addAll(buffersToAdd);
            return buffersToAdd;
        }

        @Override
        public void accept(DataBuffer dataBuffer) {
            this.buffers.remove(dataBuffer);
        }

        @Override
        public void run() {
            this.buffers.forEach(buffer -> {
                try {
                    DataBufferUtils.release(buffer);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
    }

    private static class EndFrameBuffer
    extends DataBufferWrapper {
        private static final DataBuffer BUFFER = new DefaultDataBufferFactory().wrap(new byte[0]);
        private byte[] delimiter;

        public EndFrameBuffer(byte[] delimiter) {
            super(BUFFER);
            this.delimiter = delimiter;
        }

        public byte[] delimiter() {
            return this.delimiter;
        }
    }
}

