/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.proxy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.dao.BusinessObjectDao;
import org.kuali.rice.krad.dao.DocumentDao;
import org.kuali.rice.krad.dao.impl.DocumentDaoOjb;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentAdHocService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiModuleService;
import org.kuali.rice.krad.service.ModuleService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DocumentDaoProxy
implements DocumentDao {
    private DocumentDao documentDaoOjb;
    private static KualiModuleService kualiModuleService;
    private static Map<String, DocumentDao> documentDaoValues;

    private DocumentDao getDao(Class<? extends Document> clazz) {
        ModuleService moduleService = DocumentDaoProxy.getKualiModuleService().getResponsibleModuleService(clazz);
        if (moduleService != null) {
            ModuleConfiguration moduleConfig = moduleService.getModuleConfiguration();
            String dataSourceName = "";
            if (moduleConfig != null) {
                dataSourceName = moduleConfig.getDataSourceName();
            }
            if (StringUtils.isNotEmpty((String)dataSourceName)) {
                if (documentDaoValues.get(dataSourceName) != null) {
                    return documentDaoValues.get(dataSourceName);
                }
                DocumentDaoOjb documentDaoOjbInstance = new DocumentDaoOjb(this.documentDaoOjb.getBusinessObjectDao(), this.documentDaoOjb.getDocumentAdHocService());
                documentDaoOjbInstance.setJcdAlias(dataSourceName);
                documentDaoValues.put(dataSourceName, documentDaoOjbInstance);
                return documentDaoOjbInstance;
            }
        }
        return this.documentDaoOjb;
    }

    @Override
    public <T extends Document> T save(T document) {
        return this.getDao(document.getClass()).save(document);
    }

    @Override
    public <T extends Document> T findByDocumentHeaderId(Class<T> clazz, String id) {
        return this.getDao(clazz).findByDocumentHeaderId(clazz, id);
    }

    @Override
    public <T extends Document> List<T> findByDocumentHeaderIds(Class<T> clazz, List<String> idList) {
        return this.getDao(clazz).findByDocumentHeaderIds(clazz, idList);
    }

    @Override
    public BusinessObjectDao getBusinessObjectDao() {
        return this.documentDaoOjb.getBusinessObjectDao();
    }

    @Override
    public DocumentAdHocService getDocumentAdHocService() {
        return this.documentDaoOjb.getDocumentAdHocService();
    }

    public void setDocumentDaoOjb(DocumentDao documentDaoOjb) {
        this.documentDaoOjb = documentDaoOjb;
    }

    private static synchronized KualiModuleService getKualiModuleService() {
        if (kualiModuleService == null) {
            kualiModuleService = KRADServiceLocatorWeb.getKualiModuleService();
        }
        return kualiModuleService;
    }

    static {
        documentDaoValues = new ConcurrentHashMap<String, DocumentDao>();
    }
}

