/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.UnexpectedTypeException;
import freemarker.core._ErrorDescriptionBuilder;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;

class HashBuiltins {
    private HashBuiltins() {
    }

    static class valuesBI
    extends HashExBuiltin {
        valuesBI() {
        }

        TemplateModel calculateResult(TemplateHashModelEx hashExModel, Environment env) throws TemplateModelException, InvalidReferenceException {
            TemplateCollectionModel values = hashExModel.values();
            if (values == null) {
                throw this.newNullPropertyException("values", hashExModel, env);
            }
            return values instanceof TemplateSequenceModel ? values : new CollectionAndSequence(values);
        }
    }

    static class keysBI
    extends HashExBuiltin {
        keysBI() {
        }

        TemplateModel calculateResult(TemplateHashModelEx hashExModel, Environment env) throws TemplateModelException, InvalidReferenceException {
            TemplateCollectionModel keys = hashExModel.keys();
            if (keys == null) {
                throw this.newNullPropertyException("keys", hashExModel, env);
            }
            return keys instanceof TemplateSequenceModel ? keys : new CollectionAndSequence(keys);
        }
    }

    private static abstract class HashExBuiltin
    extends BuiltIn {
        private HashExBuiltin() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (model instanceof TemplateHashModelEx) {
                return this.calculateResult((TemplateHashModelEx)model, env);
            }
            throw new UnexpectedTypeException(this.target, model, "extended hash", env);
        }

        abstract TemplateModel calculateResult(TemplateHashModelEx var1, Environment var2) throws TemplateModelException, InvalidReferenceException;

        protected InvalidReferenceException newNullPropertyException(String propertyName, TemplateModel tm, Environment env) {
            if (env.getFastInvalidReferenceExceptions()) {
                return InvalidReferenceException.FAST_INSTANCE;
            }
            return new InvalidReferenceException(new _ErrorDescriptionBuilder(new Object[]{"The exteneded hash (of class ", tm.getClass().getName(), ") has returned null for its \"", propertyName, "\" property. This is maybe a bug. The extended hash was returned by this expression:"}).blame(this.target), env);
        }
    }
}

