/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.tree.Node;
import org.kuali.rice.core.api.util.tree.Tree;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.container.NodePrototype;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

@BeanTags(value={@BeanTag(name="treeGroup", parent="Uif-TreeGroup"), @BeanTag(name="treeSection", parent="Uif-TreeSection"), @BeanTag(name="treeSubSection", parent="Uif-TreeSubSection")})
public class TreeGroup
extends GroupBase
implements DataBinding {
    private static final long serialVersionUID = 5841343037089286740L;
    private String propertyName;
    private BindingInfo bindingInfo;
    private Map<Class<?>, NodePrototype> nodePrototypeMap;
    private NodePrototype defaultNodePrototype;
    private Tree<Group, Message> treeGroups = new Tree();
    private org.kuali.rice.krad.uif.widget.Tree tree;

    @Override
    public void performInitialization(Object model) {
        this.setFieldBindingObjectPath(this.getBindingInfo().getBindingObjectPath());
        super.performInitialization(model);
        if (this.bindingInfo != null) {
            ViewLifecycle.getActiveLifecycle();
            this.bindingInfo.setDefaults(ViewLifecycle.getView(), this.getPropertyName());
        }
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        this.buildTreeGroups(model);
    }

    protected void buildTreeGroups(Object model) {
        Tree treeData = (Tree)ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath());
        Tree treeGroups = new Tree();
        String bindingPrefix = this.getBindingInfo().getBindingPrefixForNested();
        Node<Group, Message> rootNode = this.buildTreeNode((Node<Object, String>)treeData.getRootElement(), bindingPrefix + ".rootElement", "root");
        treeGroups.setRootElement(rootNode);
        this.setTreeGroups((Tree<Group, Message>)treeGroups);
    }

    protected Node<Group, Message> buildTreeNode(Node<Object, String> nodeData, String bindingPrefix, String parentNode) {
        if (nodeData == null) {
            return null;
        }
        Node node = new Node();
        node.setNodeType(nodeData.getNodeType());
        NodePrototype prototype = this.getNodePrototype(nodeData);
        Message message = ComponentUtils.copy(prototype.getLabelPrototype(), parentNode);
        ContextUtils.pushObjectToContextDeep(message, "node", nodeData);
        message.setMessageText((String)nodeData.getNodeLabel());
        node.setNodeLabel((Object)message);
        Group nodeGroup = ComponentUtils.copyComponent(prototype.getDataGroupPrototype(), bindingPrefix + ".data", parentNode);
        ContextUtils.pushObjectToContextDeep(nodeGroup, "node", nodeData);
        String nodePath = bindingPrefix + ".data";
        if (StringUtils.isNotBlank((String)this.getBindingInfo().getBindingObjectPath())) {
            nodePath = this.getBindingInfo().getBindingObjectPath() + "." + nodePath;
        }
        ContextUtils.pushObjectToContextDeep(nodeGroup, "nodePath", (Object)nodePath);
        node.setData((Object)nodeGroup);
        ArrayList<Node<Group, Message>> nodeChildren = new ArrayList<Node<Group, Message>>();
        int childIndex = 0;
        for (Node childDataNode : nodeData.getChildren()) {
            String nextBindingPrefix = bindingPrefix + ".children[" + childIndex + "]";
            Node<Group, Message> childNode = this.buildTreeNode((Node<Object, String>)childDataNode, nextBindingPrefix, "_node_" + childIndex + ("root".equals(parentNode) ? "_parent_" : "_parent") + parentNode);
            nodeChildren.add(childNode);
            ++childIndex;
        }
        node.setChildren(nodeChildren);
        return node;
    }

    private NodePrototype getNodePrototype(Node<Object, String> nodeData) {
        Class<?> dataClass;
        NodePrototype result = null;
        if (nodeData != null && nodeData.getData() != null && (result = this.nodePrototypeMap.get(dataClass = nodeData.getData().getClass())) == null) {
            for (Map.Entry<Class<?>, NodePrototype> prototypeEntry : this.nodePrototypeMap.entrySet()) {
                if (!prototypeEntry.getKey().isAssignableFrom(dataClass)) continue;
                result = prototypeEntry.getValue();
                break;
            }
        }
        if (result == null) {
            result = this.defaultNodePrototype;
        }
        return result;
    }

    public List<Component> getNodeComponents() {
        ArrayList<Component> components = new ArrayList<Component>();
        this.addNodeComponents((Node<Group, Message>)this.treeGroups.getRootElement(), components);
        return components;
    }

    @ViewLifecycleRestriction(value={"INITIALIZE"})
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.defaultNodePrototype != null) {
            components.add(this.defaultNodePrototype.getLabelPrototype());
            components.add(this.defaultNodePrototype.getDataGroupPrototype());
        }
        if (this.nodePrototypeMap != null) {
            for (Map.Entry<Class<?>, NodePrototype> prototypeEntry : this.nodePrototypeMap.entrySet()) {
                NodePrototype prototype = prototypeEntry.getValue();
                if (prototype == null) continue;
                components.add(prototype.getLabelPrototype());
                components.add(prototype.getDataGroupPrototype());
            }
        }
        return components;
    }

    protected void addNodeComponents(Node<Group, Message> node, List<Component> components) {
        if (node != null) {
            components.add((Component)node.getNodeLabel());
            components.add((Component)node.getData());
            for (Node nodeChild : node.getChildren()) {
                this.addNodeComponents((Node<Group, Message>)nodeChild, components);
            }
        }
    }

    @Override
    @BeanTagAttribute
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    @BeanTagAttribute
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public NodePrototype getDefaultNodePrototype() {
        return this.defaultNodePrototype;
    }

    public void setDefaultNodePrototype(NodePrototype defaultNodePrototype) {
        this.defaultNodePrototype = defaultNodePrototype;
    }

    @BeanTagAttribute
    public Map<Class<?>, NodePrototype> getNodePrototypeMap() {
        return this.nodePrototypeMap;
    }

    public void setNodePrototypeMap(Map<Class<?>, NodePrototype> nodePrototypeMap) {
        this.nodePrototypeMap = nodePrototypeMap;
    }

    @BeanTagAttribute
    public Tree<Group, Message> getTreeGroups() {
        return this.treeGroups;
    }

    public void setTreeGroups(Tree<Group, Message> treeGroups) {
        this.treeGroups = treeGroups;
    }

    @BeanTagAttribute
    public org.kuali.rice.krad.uif.widget.Tree getTree() {
        return this.tree;
    }

    public void setTree(org.kuali.rice.krad.uif.widget.Tree tree) {
        this.tree = tree;
    }

    protected Node<Group, Message> copyNode(Node<Group, Message> node) {
        Node nodeCopy = new Node();
        if (node == null) {
            return null;
        }
        nodeCopy.setNodeType(node.getNodeType());
        if (node.getData() != null) {
            nodeCopy.setData((Object)((Group)CopyUtils.copy((Copyable)node.getData())));
        }
        if (node.getNodeLabel() != null) {
            nodeCopy.setNodeLabel((Object)((Message)CopyUtils.copy((Copyable)node.getNodeLabel())));
        }
        if (node.getChildren() != null) {
            ArrayList<Node<Group, Message>> childrenCopy = new ArrayList<Node<Group, Message>>();
            for (Node childNode : node.getChildren()) {
                childrenCopy.add(this.copyNode((Node<Group, Message>)childNode));
            }
            nodeCopy.setChildren(childrenCopy);
        }
        return nodeCopy;
    }
}

