/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardProjectPersonAddRule;
import org.kuali.kra.award.contacts.AwardProjectPersonRuleAddEvent;
import org.kuali.kra.award.contacts.BaseAwardContactAddRule;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardProjectPersonAddRuleImpl
extends BaseAwardContactAddRule
implements AwardProjectPersonAddRule {
    @Override
    public boolean processAddAwardProjectPersonBusinessRules(AwardProjectPersonRuleAddEvent event) {
        AwardPerson newProjectPerson = event.getNewProjectPerson();
        Award award = ((AwardDocument)event.getDocument()).getAward();
        return this.checkForSelectedContactAndRole(newProjectPerson) && this.checkForExistingPrincipalInvestigators(award, newProjectPerson) & this.checkForDuplicatePerson(award, newProjectPerson) && this.checkForKeyPersonProjectRoles(newProjectPerson);
    }

    boolean checkForSelectedContactAndRole(AwardContact newContact) {
        return super.checkForSelectedContactAndRole(newContact, "projectPersonnelBean.newAwardContact");
    }

    boolean checkForExistingPrincipalInvestigators(Award award, AwardPerson newProjectPerson) {
        boolean valid = true;
        if (newProjectPerson.isPrincipalInvestigator()) {
            for (AwardPerson p : award.getProjectPersons()) {
                if (!p.isPrincipalInvestigator()) continue;
                valid = false;
                break;
            }
        }
        if (!valid) {
            GlobalVariables.getMessageMap().putError("projectPersonnelBean.newAwardContact", "error.awardProjectPerson.pi.exists", new String[0]);
        }
        return valid;
    }

    boolean checkForDuplicatePerson(Award award, AwardPerson newProjectPerson) {
        boolean valid = true;
        for (AwardPerson p : award.getProjectPersons()) {
            if (!p.getClass().equals(newProjectPerson.getClass()) || !p.getContact().getIdentifier().equals(newProjectPerson.getContact().getIdentifier())) continue;
            valid = false;
            break;
        }
        if (!valid) {
            GlobalVariables.getMessageMap().putError("projectPersonnelBean.newAwardContact", "error.awardProjectPerson.person.exists", new String[]{newProjectPerson.getContact().getFullName()});
        }
        return valid;
    }

    boolean checkForKeyPersonProjectRoles(AwardPerson newProjectPerson) {
        boolean valid = true;
        if (StringUtils.equalsIgnoreCase((CharSequence)newProjectPerson.getContactRole().getRoleCode(), (CharSequence)"KP") && StringUtils.isBlank((CharSequence)newProjectPerson.getKeyPersonRole())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("projectPersonnelBean.newAwardContact.keyPersonRole", "error.awardProjectPerson.keyperson.role.required", new String[]{newProjectPerson.getFullName()});
        }
        return valid;
    }
}

